; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+zve64x -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,CHECK-ZVE64X,RV32,RV32I
; RUN: llc -mtriple=riscv64 -mattr=+zve64x -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,CHECK-ZVE64X,RV64,RV64I
; RUN: llc -mtriple=riscv32 -mattr=+zve64f,+f -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,CHECK-F,RV32,RV32F
; RUN: llc -mtriple=riscv64 -mattr=+zve64f,+f -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,CHECK-F,RV64,RV64F
; RUN: llc -mtriple=riscv32 -mattr=+v,+d -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,CHECK-D,RV32,RV32D
; RUN: llc -mtriple=riscv64 -mattr=+v,+d -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,CHECK-D,RV64,RV64D
; RUN: llc -mtriple=riscv32 -mattr=+v,+experimental-zvbb -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK-ZVBB
; RUN: llc -mtriple=riscv64 -mattr=+v,+experimental-zvbb -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK-ZVBB

define <vscale x 1 x i8> @cttz_nxv1i8(<vscale x 1 x i8> %va) {
; CHECK-ZVE64X-LABEL: cttz_nxv1i8:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    li a0, 1
; CHECK-ZVE64X-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; CHECK-ZVE64X-NEXT:    vsub.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vand.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    li a0, 85
; CHECK-ZVE64X-NEXT:    vand.vx v9, v9, a0
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    li a0, 51
; CHECK-ZVE64X-NEXT:    vand.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v9, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vi v8, v8, 15
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: cttz_nxv1i8:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-F-NEXT:    vrsub.vi v9, v8, 0
; CHECK-F-NEXT:    vand.vv v9, v8, v9
; CHECK-F-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-F-NEXT:    vzext.vf2 v10, v9
; CHECK-F-NEXT:    vfwcvt.f.xu.v v9, v10
; CHECK-F-NEXT:    vnsrl.wi v9, v9, 23
; CHECK-F-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-F-NEXT:    vnsrl.wi v9, v9, 0
; CHECK-F-NEXT:    li a0, 127
; CHECK-F-NEXT:    vmseq.vi v0, v8, 0
; CHECK-F-NEXT:    vsub.vx v8, v9, a0
; CHECK-F-NEXT:    vmerge.vim v8, v8, 8, v0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_nxv1i8:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-D-NEXT:    vrsub.vi v9, v8, 0
; CHECK-D-NEXT:    vand.vv v9, v8, v9
; CHECK-D-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-D-NEXT:    vzext.vf2 v10, v9
; CHECK-D-NEXT:    vfwcvt.f.xu.v v9, v10
; CHECK-D-NEXT:    vnsrl.wi v9, v9, 23
; CHECK-D-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-D-NEXT:    vnsrl.wi v9, v9, 0
; CHECK-D-NEXT:    li a0, 127
; CHECK-D-NEXT:    vmseq.vi v0, v8, 0
; CHECK-D-NEXT:    vsub.vx v8, v9, a0
; CHECK-D-NEXT:    vmerge.vim v8, v8, 8, v0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_nxv1i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 1 x i8> @llvm.cttz.nxv1i8(<vscale x 1 x i8> %va, i1 false)
  ret <vscale x 1 x i8> %a
}
declare <vscale x 1 x i8> @llvm.cttz.nxv1i8(<vscale x 1 x i8>, i1)

define <vscale x 2 x i8> @cttz_nxv2i8(<vscale x 2 x i8> %va) {
; CHECK-ZVE64X-LABEL: cttz_nxv2i8:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    li a0, 1
; CHECK-ZVE64X-NEXT:    vsetvli a1, zero, e8, mf4, ta, ma
; CHECK-ZVE64X-NEXT:    vsub.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vand.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    li a0, 85
; CHECK-ZVE64X-NEXT:    vand.vx v9, v9, a0
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    li a0, 51
; CHECK-ZVE64X-NEXT:    vand.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v9, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vi v8, v8, 15
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: cttz_nxv2i8:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-F-NEXT:    vrsub.vi v9, v8, 0
; CHECK-F-NEXT:    vand.vv v9, v8, v9
; CHECK-F-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-F-NEXT:    vzext.vf2 v10, v9
; CHECK-F-NEXT:    vfwcvt.f.xu.v v9, v10
; CHECK-F-NEXT:    vnsrl.wi v9, v9, 23
; CHECK-F-NEXT:    vsetvli zero, zero, e8, mf4, ta, ma
; CHECK-F-NEXT:    vnsrl.wi v9, v9, 0
; CHECK-F-NEXT:    li a0, 127
; CHECK-F-NEXT:    vmseq.vi v0, v8, 0
; CHECK-F-NEXT:    vsub.vx v8, v9, a0
; CHECK-F-NEXT:    vmerge.vim v8, v8, 8, v0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_nxv2i8:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-D-NEXT:    vrsub.vi v9, v8, 0
; CHECK-D-NEXT:    vand.vv v9, v8, v9
; CHECK-D-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-D-NEXT:    vzext.vf2 v10, v9
; CHECK-D-NEXT:    vfwcvt.f.xu.v v9, v10
; CHECK-D-NEXT:    vnsrl.wi v9, v9, 23
; CHECK-D-NEXT:    vsetvli zero, zero, e8, mf4, ta, ma
; CHECK-D-NEXT:    vnsrl.wi v9, v9, 0
; CHECK-D-NEXT:    li a0, 127
; CHECK-D-NEXT:    vmseq.vi v0, v8, 0
; CHECK-D-NEXT:    vsub.vx v8, v9, a0
; CHECK-D-NEXT:    vmerge.vim v8, v8, 8, v0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_nxv2i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 2 x i8> @llvm.cttz.nxv2i8(<vscale x 2 x i8> %va, i1 false)
  ret <vscale x 2 x i8> %a
}
declare <vscale x 2 x i8> @llvm.cttz.nxv2i8(<vscale x 2 x i8>, i1)

define <vscale x 4 x i8> @cttz_nxv4i8(<vscale x 4 x i8> %va) {
; CHECK-ZVE64X-LABEL: cttz_nxv4i8:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    li a0, 1
; CHECK-ZVE64X-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; CHECK-ZVE64X-NEXT:    vsub.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vand.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    li a0, 85
; CHECK-ZVE64X-NEXT:    vand.vx v9, v9, a0
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    li a0, 51
; CHECK-ZVE64X-NEXT:    vand.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v9, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vi v8, v8, 15
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: cttz_nxv4i8:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-F-NEXT:    vrsub.vi v9, v8, 0
; CHECK-F-NEXT:    vand.vv v9, v8, v9
; CHECK-F-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-F-NEXT:    vzext.vf2 v10, v9
; CHECK-F-NEXT:    vfwcvt.f.xu.v v12, v10
; CHECK-F-NEXT:    vnsrl.wi v9, v12, 23
; CHECK-F-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; CHECK-F-NEXT:    vnsrl.wi v9, v9, 0
; CHECK-F-NEXT:    li a0, 127
; CHECK-F-NEXT:    vmseq.vi v0, v8, 0
; CHECK-F-NEXT:    vsub.vx v8, v9, a0
; CHECK-F-NEXT:    vmerge.vim v8, v8, 8, v0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_nxv4i8:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-D-NEXT:    vrsub.vi v9, v8, 0
; CHECK-D-NEXT:    vand.vv v9, v8, v9
; CHECK-D-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-D-NEXT:    vzext.vf2 v10, v9
; CHECK-D-NEXT:    vfwcvt.f.xu.v v12, v10
; CHECK-D-NEXT:    vnsrl.wi v9, v12, 23
; CHECK-D-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; CHECK-D-NEXT:    vnsrl.wi v9, v9, 0
; CHECK-D-NEXT:    li a0, 127
; CHECK-D-NEXT:    vmseq.vi v0, v8, 0
; CHECK-D-NEXT:    vsub.vx v8, v9, a0
; CHECK-D-NEXT:    vmerge.vim v8, v8, 8, v0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_nxv4i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 4 x i8> @llvm.cttz.nxv4i8(<vscale x 4 x i8> %va, i1 false)
  ret <vscale x 4 x i8> %a
}
declare <vscale x 4 x i8> @llvm.cttz.nxv4i8(<vscale x 4 x i8>, i1)

define <vscale x 8 x i8> @cttz_nxv8i8(<vscale x 8 x i8> %va) {
; CHECK-ZVE64X-LABEL: cttz_nxv8i8:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    li a0, 1
; CHECK-ZVE64X-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-ZVE64X-NEXT:    vsub.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vand.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    li a0, 85
; CHECK-ZVE64X-NEXT:    vand.vx v9, v9, a0
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    li a0, 51
; CHECK-ZVE64X-NEXT:    vand.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v9, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vi v8, v8, 15
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: cttz_nxv8i8:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-F-NEXT:    vrsub.vi v9, v8, 0
; CHECK-F-NEXT:    vand.vv v9, v8, v9
; CHECK-F-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-F-NEXT:    vzext.vf2 v10, v9
; CHECK-F-NEXT:    vfwcvt.f.xu.v v12, v10
; CHECK-F-NEXT:    vnsrl.wi v10, v12, 23
; CHECK-F-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; CHECK-F-NEXT:    vnsrl.wi v9, v10, 0
; CHECK-F-NEXT:    li a0, 127
; CHECK-F-NEXT:    vmseq.vi v0, v8, 0
; CHECK-F-NEXT:    vsub.vx v8, v9, a0
; CHECK-F-NEXT:    vmerge.vim v8, v8, 8, v0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_nxv8i8:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-D-NEXT:    vrsub.vi v9, v8, 0
; CHECK-D-NEXT:    vand.vv v9, v8, v9
; CHECK-D-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-D-NEXT:    vzext.vf2 v10, v9
; CHECK-D-NEXT:    vfwcvt.f.xu.v v12, v10
; CHECK-D-NEXT:    vnsrl.wi v10, v12, 23
; CHECK-D-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; CHECK-D-NEXT:    vnsrl.wi v9, v10, 0
; CHECK-D-NEXT:    li a0, 127
; CHECK-D-NEXT:    vmseq.vi v0, v8, 0
; CHECK-D-NEXT:    vsub.vx v8, v9, a0
; CHECK-D-NEXT:    vmerge.vim v8, v8, 8, v0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_nxv8i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 8 x i8> @llvm.cttz.nxv8i8(<vscale x 8 x i8> %va, i1 false)
  ret <vscale x 8 x i8> %a
}
declare <vscale x 8 x i8> @llvm.cttz.nxv8i8(<vscale x 8 x i8>, i1)

define <vscale x 16 x i8> @cttz_nxv16i8(<vscale x 16 x i8> %va) {
; CHECK-ZVE64X-LABEL: cttz_nxv16i8:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    li a0, 1
; CHECK-ZVE64X-NEXT:    vsetvli a1, zero, e8, m2, ta, ma
; CHECK-ZVE64X-NEXT:    vsub.vx v10, v8, a0
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vand.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 1
; CHECK-ZVE64X-NEXT:    li a0, 85
; CHECK-ZVE64X-NEXT:    vand.vx v10, v10, a0
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    li a0, 51
; CHECK-ZVE64X-NEXT:    vand.vx v10, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v10, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vand.vi v8, v8, 15
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: cttz_nxv16i8:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-F-NEXT:    vrsub.vi v10, v8, 0
; CHECK-F-NEXT:    vand.vv v10, v8, v10
; CHECK-F-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; CHECK-F-NEXT:    vzext.vf2 v12, v10
; CHECK-F-NEXT:    vfwcvt.f.xu.v v16, v12
; CHECK-F-NEXT:    vnsrl.wi v12, v16, 23
; CHECK-F-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; CHECK-F-NEXT:    vnsrl.wi v10, v12, 0
; CHECK-F-NEXT:    li a0, 127
; CHECK-F-NEXT:    vmseq.vi v0, v8, 0
; CHECK-F-NEXT:    vsub.vx v8, v10, a0
; CHECK-F-NEXT:    vmerge.vim v8, v8, 8, v0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_nxv16i8:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-D-NEXT:    vrsub.vi v10, v8, 0
; CHECK-D-NEXT:    vand.vv v10, v8, v10
; CHECK-D-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; CHECK-D-NEXT:    vzext.vf2 v12, v10
; CHECK-D-NEXT:    vfwcvt.f.xu.v v16, v12
; CHECK-D-NEXT:    vnsrl.wi v12, v16, 23
; CHECK-D-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; CHECK-D-NEXT:    vnsrl.wi v10, v12, 0
; CHECK-D-NEXT:    li a0, 127
; CHECK-D-NEXT:    vmseq.vi v0, v8, 0
; CHECK-D-NEXT:    vsub.vx v8, v10, a0
; CHECK-D-NEXT:    vmerge.vim v8, v8, 8, v0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_nxv16i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 16 x i8> @llvm.cttz.nxv16i8(<vscale x 16 x i8> %va, i1 false)
  ret <vscale x 16 x i8> %a
}
declare <vscale x 16 x i8> @llvm.cttz.nxv16i8(<vscale x 16 x i8>, i1)

define <vscale x 32 x i8> @cttz_nxv32i8(<vscale x 32 x i8> %va) {
; CHECK-LABEL: cttz_nxv32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 1
; CHECK-NEXT:    vsetvli a1, zero, e8, m4, ta, ma
; CHECK-NEXT:    vsub.vx v12, v8, a0
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v8, v12
; CHECK-NEXT:    vsrl.vi v12, v8, 1
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v12, v12, a0
; CHECK-NEXT:    vsub.vv v8, v8, v12
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v12, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v12, v8
; CHECK-NEXT:    vsrl.vi v12, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v12
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_nxv32i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 32 x i8> @llvm.cttz.nxv32i8(<vscale x 32 x i8> %va, i1 false)
  ret <vscale x 32 x i8> %a
}
declare <vscale x 32 x i8> @llvm.cttz.nxv32i8(<vscale x 32 x i8>, i1)

define <vscale x 64 x i8> @cttz_nxv64i8(<vscale x 64 x i8> %va) {
; CHECK-LABEL: cttz_nxv64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 1
; CHECK-NEXT:    vsetvli a1, zero, e8, m8, ta, ma
; CHECK-NEXT:    vsub.vx v16, v8, a0
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v8, v16
; CHECK-NEXT:    vsrl.vi v16, v8, 1
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v16, v16, a0
; CHECK-NEXT:    vsub.vv v8, v8, v16
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v16, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v16, v8
; CHECK-NEXT:    vsrl.vi v16, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v16
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_nxv64i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 64 x i8> @llvm.cttz.nxv64i8(<vscale x 64 x i8> %va, i1 false)
  ret <vscale x 64 x i8> %a
}
declare <vscale x 64 x i8> @llvm.cttz.nxv64i8(<vscale x 64 x i8>, i1)

define <vscale x 1 x i16> @cttz_nxv1i16(<vscale x 1 x i16> %va) {
; RV32I-LABEL: cttz_nxv1i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; RV32I-NEXT:    vsub.vx v9, v8, a0
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vand.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    lui a0, 5
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v9, v9, a0
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 3
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v9, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 1
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    li a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 8
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cttz_nxv1i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; RV64I-NEXT:    vsub.vx v9, v8, a0
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vand.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    lui a0, 5
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 3
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 1
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    li a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 8
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: cttz_nxv1i16:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-F-NEXT:    vrsub.vi v9, v8, 0
; CHECK-F-NEXT:    vand.vv v9, v8, v9
; CHECK-F-NEXT:    vfwcvt.f.xu.v v10, v9
; CHECK-F-NEXT:    vnsrl.wi v9, v10, 23
; CHECK-F-NEXT:    li a0, 127
; CHECK-F-NEXT:    vsub.vx v9, v9, a0
; CHECK-F-NEXT:    vmseq.vi v0, v8, 0
; CHECK-F-NEXT:    li a0, 16
; CHECK-F-NEXT:    vmerge.vxm v8, v9, a0, v0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_nxv1i16:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-D-NEXT:    vrsub.vi v9, v8, 0
; CHECK-D-NEXT:    vand.vv v9, v8, v9
; CHECK-D-NEXT:    vfwcvt.f.xu.v v10, v9
; CHECK-D-NEXT:    vnsrl.wi v9, v10, 23
; CHECK-D-NEXT:    li a0, 127
; CHECK-D-NEXT:    vsub.vx v9, v9, a0
; CHECK-D-NEXT:    vmseq.vi v0, v8, 0
; CHECK-D-NEXT:    li a0, 16
; CHECK-D-NEXT:    vmerge.vxm v8, v9, a0, v0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_nxv1i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 1 x i16> @llvm.cttz.nxv1i16(<vscale x 1 x i16> %va, i1 false)
  ret <vscale x 1 x i16> %a
}
declare <vscale x 1 x i16> @llvm.cttz.nxv1i16(<vscale x 1 x i16>, i1)

define <vscale x 2 x i16> @cttz_nxv2i16(<vscale x 2 x i16> %va) {
; RV32I-LABEL: cttz_nxv2i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; RV32I-NEXT:    vsub.vx v9, v8, a0
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vand.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    lui a0, 5
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v9, v9, a0
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 3
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v9, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 1
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    li a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 8
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cttz_nxv2i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; RV64I-NEXT:    vsub.vx v9, v8, a0
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vand.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    lui a0, 5
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 3
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 1
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    li a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 8
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: cttz_nxv2i16:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-F-NEXT:    vrsub.vi v9, v8, 0
; CHECK-F-NEXT:    vand.vv v9, v8, v9
; CHECK-F-NEXT:    vfwcvt.f.xu.v v10, v9
; CHECK-F-NEXT:    vnsrl.wi v9, v10, 23
; CHECK-F-NEXT:    li a0, 127
; CHECK-F-NEXT:    vsub.vx v9, v9, a0
; CHECK-F-NEXT:    vmseq.vi v0, v8, 0
; CHECK-F-NEXT:    li a0, 16
; CHECK-F-NEXT:    vmerge.vxm v8, v9, a0, v0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_nxv2i16:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-D-NEXT:    vrsub.vi v9, v8, 0
; CHECK-D-NEXT:    vand.vv v9, v8, v9
; CHECK-D-NEXT:    vfwcvt.f.xu.v v10, v9
; CHECK-D-NEXT:    vnsrl.wi v9, v10, 23
; CHECK-D-NEXT:    li a0, 127
; CHECK-D-NEXT:    vsub.vx v9, v9, a0
; CHECK-D-NEXT:    vmseq.vi v0, v8, 0
; CHECK-D-NEXT:    li a0, 16
; CHECK-D-NEXT:    vmerge.vxm v8, v9, a0, v0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_nxv2i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 2 x i16> @llvm.cttz.nxv2i16(<vscale x 2 x i16> %va, i1 false)
  ret <vscale x 2 x i16> %a
}
declare <vscale x 2 x i16> @llvm.cttz.nxv2i16(<vscale x 2 x i16>, i1)

define <vscale x 4 x i16> @cttz_nxv4i16(<vscale x 4 x i16> %va) {
; RV32I-LABEL: cttz_nxv4i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; RV32I-NEXT:    vsub.vx v9, v8, a0
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vand.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    lui a0, 5
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v9, v9, a0
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 3
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v9, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 1
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    li a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 8
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cttz_nxv4i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; RV64I-NEXT:    vsub.vx v9, v8, a0
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vand.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    lui a0, 5
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 3
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 1
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    li a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 8
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: cttz_nxv4i16:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-F-NEXT:    vrsub.vi v9, v8, 0
; CHECK-F-NEXT:    vand.vv v9, v8, v9
; CHECK-F-NEXT:    vfwcvt.f.xu.v v10, v9
; CHECK-F-NEXT:    vnsrl.wi v9, v10, 23
; CHECK-F-NEXT:    li a0, 127
; CHECK-F-NEXT:    vsub.vx v9, v9, a0
; CHECK-F-NEXT:    vmseq.vi v0, v8, 0
; CHECK-F-NEXT:    li a0, 16
; CHECK-F-NEXT:    vmerge.vxm v8, v9, a0, v0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_nxv4i16:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-D-NEXT:    vrsub.vi v9, v8, 0
; CHECK-D-NEXT:    vand.vv v9, v8, v9
; CHECK-D-NEXT:    vfwcvt.f.xu.v v10, v9
; CHECK-D-NEXT:    vnsrl.wi v9, v10, 23
; CHECK-D-NEXT:    li a0, 127
; CHECK-D-NEXT:    vsub.vx v9, v9, a0
; CHECK-D-NEXT:    vmseq.vi v0, v8, 0
; CHECK-D-NEXT:    li a0, 16
; CHECK-D-NEXT:    vmerge.vxm v8, v9, a0, v0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_nxv4i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 4 x i16> @llvm.cttz.nxv4i16(<vscale x 4 x i16> %va, i1 false)
  ret <vscale x 4 x i16> %a
}
declare <vscale x 4 x i16> @llvm.cttz.nxv4i16(<vscale x 4 x i16>, i1)

define <vscale x 8 x i16> @cttz_nxv8i16(<vscale x 8 x i16> %va) {
; RV32I-LABEL: cttz_nxv8i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; RV32I-NEXT:    vsub.vx v10, v8, a0
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vand.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 1
; RV32I-NEXT:    lui a0, 5
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v10, v10, a0
; RV32I-NEXT:    vsub.vv v8, v8, v10
; RV32I-NEXT:    lui a0, 3
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v10, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v10, v8
; RV32I-NEXT:    vsrl.vi v10, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v10
; RV32I-NEXT:    lui a0, 1
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    li a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 8
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cttz_nxv8i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; RV64I-NEXT:    vsub.vx v10, v8, a0
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vand.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 1
; RV64I-NEXT:    lui a0, 5
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v10, v10, a0
; RV64I-NEXT:    vsub.vv v8, v8, v10
; RV64I-NEXT:    lui a0, 3
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v10, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v10, v8
; RV64I-NEXT:    vsrl.vi v10, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v10
; RV64I-NEXT:    lui a0, 1
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    li a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 8
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: cttz_nxv8i16:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-F-NEXT:    vrsub.vi v10, v8, 0
; CHECK-F-NEXT:    vand.vv v10, v8, v10
; CHECK-F-NEXT:    vfwcvt.f.xu.v v12, v10
; CHECK-F-NEXT:    vnsrl.wi v10, v12, 23
; CHECK-F-NEXT:    li a0, 127
; CHECK-F-NEXT:    vsub.vx v10, v10, a0
; CHECK-F-NEXT:    vmseq.vi v0, v8, 0
; CHECK-F-NEXT:    li a0, 16
; CHECK-F-NEXT:    vmerge.vxm v8, v10, a0, v0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_nxv8i16:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-D-NEXT:    vrsub.vi v10, v8, 0
; CHECK-D-NEXT:    vand.vv v10, v8, v10
; CHECK-D-NEXT:    vfwcvt.f.xu.v v12, v10
; CHECK-D-NEXT:    vnsrl.wi v10, v12, 23
; CHECK-D-NEXT:    li a0, 127
; CHECK-D-NEXT:    vsub.vx v10, v10, a0
; CHECK-D-NEXT:    vmseq.vi v0, v8, 0
; CHECK-D-NEXT:    li a0, 16
; CHECK-D-NEXT:    vmerge.vxm v8, v10, a0, v0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_nxv8i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 8 x i16> @llvm.cttz.nxv8i16(<vscale x 8 x i16> %va, i1 false)
  ret <vscale x 8 x i16> %a
}
declare <vscale x 8 x i16> @llvm.cttz.nxv8i16(<vscale x 8 x i16>, i1)

define <vscale x 16 x i16> @cttz_nxv16i16(<vscale x 16 x i16> %va) {
; RV32I-LABEL: cttz_nxv16i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    vsetvli a1, zero, e16, m4, ta, ma
; RV32I-NEXT:    vsub.vx v12, v8, a0
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vand.vv v8, v8, v12
; RV32I-NEXT:    vsrl.vi v12, v8, 1
; RV32I-NEXT:    lui a0, 5
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v12, v12, a0
; RV32I-NEXT:    vsub.vv v8, v8, v12
; RV32I-NEXT:    lui a0, 3
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v12, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v12, v8
; RV32I-NEXT:    vsrl.vi v12, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v12
; RV32I-NEXT:    lui a0, 1
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    li a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 8
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cttz_nxv16i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    vsetvli a1, zero, e16, m4, ta, ma
; RV64I-NEXT:    vsub.vx v12, v8, a0
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vand.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vi v12, v8, 1
; RV64I-NEXT:    lui a0, 5
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v12, v12, a0
; RV64I-NEXT:    vsub.vv v8, v8, v12
; RV64I-NEXT:    lui a0, 3
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v12, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v12, v8
; RV64I-NEXT:    vsrl.vi v12, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v12
; RV64I-NEXT:    lui a0, 1
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    li a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 8
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: cttz_nxv16i16:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-F-NEXT:    vrsub.vi v12, v8, 0
; CHECK-F-NEXT:    vand.vv v12, v8, v12
; CHECK-F-NEXT:    vfwcvt.f.xu.v v16, v12
; CHECK-F-NEXT:    vnsrl.wi v12, v16, 23
; CHECK-F-NEXT:    li a0, 127
; CHECK-F-NEXT:    vsub.vx v12, v12, a0
; CHECK-F-NEXT:    vmseq.vi v0, v8, 0
; CHECK-F-NEXT:    li a0, 16
; CHECK-F-NEXT:    vmerge.vxm v8, v12, a0, v0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_nxv16i16:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-D-NEXT:    vrsub.vi v12, v8, 0
; CHECK-D-NEXT:    vand.vv v12, v8, v12
; CHECK-D-NEXT:    vfwcvt.f.xu.v v16, v12
; CHECK-D-NEXT:    vnsrl.wi v12, v16, 23
; CHECK-D-NEXT:    li a0, 127
; CHECK-D-NEXT:    vsub.vx v12, v12, a0
; CHECK-D-NEXT:    vmseq.vi v0, v8, 0
; CHECK-D-NEXT:    li a0, 16
; CHECK-D-NEXT:    vmerge.vxm v8, v12, a0, v0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_nxv16i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 16 x i16> @llvm.cttz.nxv16i16(<vscale x 16 x i16> %va, i1 false)
  ret <vscale x 16 x i16> %a
}
declare <vscale x 16 x i16> @llvm.cttz.nxv16i16(<vscale x 16 x i16>, i1)

define <vscale x 32 x i16> @cttz_nxv32i16(<vscale x 32 x i16> %va) {
; RV32-LABEL: cttz_nxv32i16:
; RV32:       # %bb.0:
; RV32-NEXT:    li a0, 1
; RV32-NEXT:    vsetvli a1, zero, e16, m8, ta, ma
; RV32-NEXT:    vsub.vx v16, v8, a0
; RV32-NEXT:    vnot.v v8, v8
; RV32-NEXT:    vand.vv v8, v8, v16
; RV32-NEXT:    vsrl.vi v16, v8, 1
; RV32-NEXT:    lui a0, 5
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    vand.vx v16, v16, a0
; RV32-NEXT:    vsub.vv v8, v8, v16
; RV32-NEXT:    lui a0, 3
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    vand.vx v16, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    vadd.vv v8, v16, v8
; RV32-NEXT:    vsrl.vi v16, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v16
; RV32-NEXT:    lui a0, 1
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    li a0, 257
; RV32-NEXT:    vmul.vx v8, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 8
; RV32-NEXT:    ret
;
; RV64-LABEL: cttz_nxv32i16:
; RV64:       # %bb.0:
; RV64-NEXT:    li a0, 1
; RV64-NEXT:    vsetvli a1, zero, e16, m8, ta, ma
; RV64-NEXT:    vsub.vx v16, v8, a0
; RV64-NEXT:    vnot.v v8, v8
; RV64-NEXT:    vand.vv v8, v8, v16
; RV64-NEXT:    vsrl.vi v16, v8, 1
; RV64-NEXT:    lui a0, 5
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    vand.vx v16, v16, a0
; RV64-NEXT:    vsub.vv v8, v8, v16
; RV64-NEXT:    lui a0, 3
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    vand.vx v16, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vadd.vv v8, v16, v8
; RV64-NEXT:    vsrl.vi v16, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v16
; RV64-NEXT:    lui a0, 1
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    li a0, 257
; RV64-NEXT:    vmul.vx v8, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 8
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_nxv32i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 32 x i16> @llvm.cttz.nxv32i16(<vscale x 32 x i16> %va, i1 false)
  ret <vscale x 32 x i16> %a
}
declare <vscale x 32 x i16> @llvm.cttz.nxv32i16(<vscale x 32 x i16>, i1)

define <vscale x 1 x i32> @cttz_nxv1i32(<vscale x 1 x i32> %va) {
; RV32I-LABEL: cttz_nxv1i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; RV32I-NEXT:    vsub.vx v9, v8, a0
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vand.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v9, v9, a0
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v9, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 24
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cttz_nxv1i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; RV64I-NEXT:    vsub.vx v9, v8, a0
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vand.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 209715
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 61681
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    lui a0, 4112
; RV64I-NEXT:    addiw a0, a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 24
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: cttz_nxv1i32:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-F-NEXT:    vrsub.vi v9, v8, 0
; CHECK-F-NEXT:    vand.vv v9, v8, v9
; CHECK-F-NEXT:    fsrmi a0, 1
; CHECK-F-NEXT:    vfcvt.f.xu.v v9, v9
; CHECK-F-NEXT:    vsrl.vi v9, v9, 23
; CHECK-F-NEXT:    li a1, 127
; CHECK-F-NEXT:    vsub.vx v9, v9, a1
; CHECK-F-NEXT:    vmseq.vi v0, v8, 0
; CHECK-F-NEXT:    li a1, 32
; CHECK-F-NEXT:    vmerge.vxm v8, v9, a1, v0
; CHECK-F-NEXT:    fsrm a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_nxv1i32:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-D-NEXT:    vrsub.vi v9, v8, 0
; CHECK-D-NEXT:    vand.vv v9, v8, v9
; CHECK-D-NEXT:    vfwcvt.f.xu.v v10, v9
; CHECK-D-NEXT:    li a0, 52
; CHECK-D-NEXT:    vnsrl.wx v9, v10, a0
; CHECK-D-NEXT:    li a0, 1023
; CHECK-D-NEXT:    vsub.vx v9, v9, a0
; CHECK-D-NEXT:    vmseq.vi v0, v8, 0
; CHECK-D-NEXT:    li a0, 32
; CHECK-D-NEXT:    vmerge.vxm v8, v9, a0, v0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_nxv1i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 1 x i32> @llvm.cttz.nxv1i32(<vscale x 1 x i32> %va, i1 false)
  ret <vscale x 1 x i32> %a
}
declare <vscale x 1 x i32> @llvm.cttz.nxv1i32(<vscale x 1 x i32>, i1)

define <vscale x 2 x i32> @cttz_nxv2i32(<vscale x 2 x i32> %va) {
; RV32I-LABEL: cttz_nxv2i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; RV32I-NEXT:    vsub.vx v9, v8, a0
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vand.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v9, v9, a0
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v9, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 24
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cttz_nxv2i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; RV64I-NEXT:    vsub.vx v9, v8, a0
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vand.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 209715
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 61681
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    lui a0, 4112
; RV64I-NEXT:    addiw a0, a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 24
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: cttz_nxv2i32:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-F-NEXT:    vrsub.vi v9, v8, 0
; CHECK-F-NEXT:    vand.vv v9, v8, v9
; CHECK-F-NEXT:    fsrmi a0, 1
; CHECK-F-NEXT:    vfcvt.f.xu.v v9, v9
; CHECK-F-NEXT:    vsrl.vi v9, v9, 23
; CHECK-F-NEXT:    li a1, 127
; CHECK-F-NEXT:    vsub.vx v9, v9, a1
; CHECK-F-NEXT:    vmseq.vi v0, v8, 0
; CHECK-F-NEXT:    li a1, 32
; CHECK-F-NEXT:    vmerge.vxm v8, v9, a1, v0
; CHECK-F-NEXT:    fsrm a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_nxv2i32:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-D-NEXT:    vrsub.vi v9, v8, 0
; CHECK-D-NEXT:    vand.vv v9, v8, v9
; CHECK-D-NEXT:    vfwcvt.f.xu.v v10, v9
; CHECK-D-NEXT:    li a0, 52
; CHECK-D-NEXT:    vnsrl.wx v9, v10, a0
; CHECK-D-NEXT:    li a0, 1023
; CHECK-D-NEXT:    vsub.vx v9, v9, a0
; CHECK-D-NEXT:    vmseq.vi v0, v8, 0
; CHECK-D-NEXT:    li a0, 32
; CHECK-D-NEXT:    vmerge.vxm v8, v9, a0, v0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_nxv2i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 2 x i32> @llvm.cttz.nxv2i32(<vscale x 2 x i32> %va, i1 false)
  ret <vscale x 2 x i32> %a
}
declare <vscale x 2 x i32> @llvm.cttz.nxv2i32(<vscale x 2 x i32>, i1)

define <vscale x 4 x i32> @cttz_nxv4i32(<vscale x 4 x i32> %va) {
; RV32I-LABEL: cttz_nxv4i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; RV32I-NEXT:    vsub.vx v10, v8, a0
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vand.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 1
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v10, v10, a0
; RV32I-NEXT:    vsub.vv v8, v8, v10
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v10, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v10, v8
; RV32I-NEXT:    vsrl.vi v10, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v10
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 24
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cttz_nxv4i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; RV64I-NEXT:    vsub.vx v10, v8, a0
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vand.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v10, v10, a0
; RV64I-NEXT:    vsub.vv v8, v8, v10
; RV64I-NEXT:    lui a0, 209715
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v10, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v10, v8
; RV64I-NEXT:    vsrl.vi v10, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v10
; RV64I-NEXT:    lui a0, 61681
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    lui a0, 4112
; RV64I-NEXT:    addiw a0, a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 24
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: cttz_nxv4i32:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-F-NEXT:    vrsub.vi v10, v8, 0
; CHECK-F-NEXT:    vand.vv v10, v8, v10
; CHECK-F-NEXT:    fsrmi a0, 1
; CHECK-F-NEXT:    vfcvt.f.xu.v v10, v10
; CHECK-F-NEXT:    vsrl.vi v10, v10, 23
; CHECK-F-NEXT:    li a1, 127
; CHECK-F-NEXT:    vsub.vx v10, v10, a1
; CHECK-F-NEXT:    vmseq.vi v0, v8, 0
; CHECK-F-NEXT:    li a1, 32
; CHECK-F-NEXT:    vmerge.vxm v8, v10, a1, v0
; CHECK-F-NEXT:    fsrm a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_nxv4i32:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-D-NEXT:    vrsub.vi v10, v8, 0
; CHECK-D-NEXT:    vand.vv v10, v8, v10
; CHECK-D-NEXT:    vfwcvt.f.xu.v v12, v10
; CHECK-D-NEXT:    li a0, 52
; CHECK-D-NEXT:    vnsrl.wx v10, v12, a0
; CHECK-D-NEXT:    li a0, 1023
; CHECK-D-NEXT:    vsub.vx v10, v10, a0
; CHECK-D-NEXT:    vmseq.vi v0, v8, 0
; CHECK-D-NEXT:    li a0, 32
; CHECK-D-NEXT:    vmerge.vxm v8, v10, a0, v0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_nxv4i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 4 x i32> @llvm.cttz.nxv4i32(<vscale x 4 x i32> %va, i1 false)
  ret <vscale x 4 x i32> %a
}
declare <vscale x 4 x i32> @llvm.cttz.nxv4i32(<vscale x 4 x i32>, i1)

define <vscale x 8 x i32> @cttz_nxv8i32(<vscale x 8 x i32> %va) {
; RV32I-LABEL: cttz_nxv8i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; RV32I-NEXT:    vsub.vx v12, v8, a0
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vand.vv v8, v8, v12
; RV32I-NEXT:    vsrl.vi v12, v8, 1
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v12, v12, a0
; RV32I-NEXT:    vsub.vv v8, v8, v12
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v12, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v12, v8
; RV32I-NEXT:    vsrl.vi v12, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v12
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 24
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cttz_nxv8i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; RV64I-NEXT:    vsub.vx v12, v8, a0
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vand.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vi v12, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v12, v12, a0
; RV64I-NEXT:    vsub.vv v8, v8, v12
; RV64I-NEXT:    lui a0, 209715
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v12, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v12, v8
; RV64I-NEXT:    vsrl.vi v12, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v12
; RV64I-NEXT:    lui a0, 61681
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    lui a0, 4112
; RV64I-NEXT:    addiw a0, a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 24
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: cttz_nxv8i32:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-F-NEXT:    vrsub.vi v12, v8, 0
; CHECK-F-NEXT:    vand.vv v12, v8, v12
; CHECK-F-NEXT:    fsrmi a0, 1
; CHECK-F-NEXT:    vfcvt.f.xu.v v12, v12
; CHECK-F-NEXT:    vsrl.vi v12, v12, 23
; CHECK-F-NEXT:    li a1, 127
; CHECK-F-NEXT:    vsub.vx v12, v12, a1
; CHECK-F-NEXT:    vmseq.vi v0, v8, 0
; CHECK-F-NEXT:    li a1, 32
; CHECK-F-NEXT:    vmerge.vxm v8, v12, a1, v0
; CHECK-F-NEXT:    fsrm a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_nxv8i32:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-D-NEXT:    vrsub.vi v12, v8, 0
; CHECK-D-NEXT:    vand.vv v12, v8, v12
; CHECK-D-NEXT:    vfwcvt.f.xu.v v16, v12
; CHECK-D-NEXT:    li a0, 52
; CHECK-D-NEXT:    vnsrl.wx v12, v16, a0
; CHECK-D-NEXT:    li a0, 1023
; CHECK-D-NEXT:    vsub.vx v12, v12, a0
; CHECK-D-NEXT:    vmseq.vi v0, v8, 0
; CHECK-D-NEXT:    li a0, 32
; CHECK-D-NEXT:    vmerge.vxm v8, v12, a0, v0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_nxv8i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 8 x i32> @llvm.cttz.nxv8i32(<vscale x 8 x i32> %va, i1 false)
  ret <vscale x 8 x i32> %a
}
declare <vscale x 8 x i32> @llvm.cttz.nxv8i32(<vscale x 8 x i32>, i1)

define <vscale x 16 x i32> @cttz_nxv16i32(<vscale x 16 x i32> %va) {
; RV32I-LABEL: cttz_nxv16i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    vsetvli a1, zero, e32, m8, ta, ma
; RV32I-NEXT:    vsub.vx v16, v8, a0
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vand.vv v8, v8, v16
; RV32I-NEXT:    vsrl.vi v16, v8, 1
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v16, v16, a0
; RV32I-NEXT:    vsub.vv v8, v8, v16
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v16, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v16, v8
; RV32I-NEXT:    vsrl.vi v16, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v16
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 24
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cttz_nxv16i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    vsetvli a1, zero, e32, m8, ta, ma
; RV64I-NEXT:    vsub.vx v16, v8, a0
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vand.vv v8, v8, v16
; RV64I-NEXT:    vsrl.vi v16, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v16, v16, a0
; RV64I-NEXT:    vsub.vv v8, v8, v16
; RV64I-NEXT:    lui a0, 209715
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v16, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v16, v8
; RV64I-NEXT:    vsrl.vi v16, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v16
; RV64I-NEXT:    lui a0, 61681
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    lui a0, 4112
; RV64I-NEXT:    addiw a0, a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 24
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: cttz_nxv16i32:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-F-NEXT:    vrsub.vi v16, v8, 0
; CHECK-F-NEXT:    vand.vv v16, v8, v16
; CHECK-F-NEXT:    fsrmi a0, 1
; CHECK-F-NEXT:    vfcvt.f.xu.v v16, v16
; CHECK-F-NEXT:    vsrl.vi v16, v16, 23
; CHECK-F-NEXT:    li a1, 127
; CHECK-F-NEXT:    vsub.vx v16, v16, a1
; CHECK-F-NEXT:    vmseq.vi v0, v8, 0
; CHECK-F-NEXT:    li a1, 32
; CHECK-F-NEXT:    vmerge.vxm v8, v16, a1, v0
; CHECK-F-NEXT:    fsrm a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_nxv16i32:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-D-NEXT:    vrsub.vi v16, v8, 0
; CHECK-D-NEXT:    vand.vv v16, v8, v16
; CHECK-D-NEXT:    fsrmi a0, 1
; CHECK-D-NEXT:    vfcvt.f.xu.v v16, v16
; CHECK-D-NEXT:    vsrl.vi v16, v16, 23
; CHECK-D-NEXT:    li a1, 127
; CHECK-D-NEXT:    vsub.vx v16, v16, a1
; CHECK-D-NEXT:    vmseq.vi v0, v8, 0
; CHECK-D-NEXT:    li a1, 32
; CHECK-D-NEXT:    vmerge.vxm v8, v16, a1, v0
; CHECK-D-NEXT:    fsrm a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_nxv16i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 16 x i32> @llvm.cttz.nxv16i32(<vscale x 16 x i32> %va, i1 false)
  ret <vscale x 16 x i32> %a
}
declare <vscale x 16 x i32> @llvm.cttz.nxv16i32(<vscale x 16 x i32>, i1)

define <vscale x 1 x i64> @cttz_nxv1i64(<vscale x 1 x i64> %va) {
; RV32I-LABEL: cttz_nxv1i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    .cfi_def_cfa_offset 32
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    sw a0, 28(sp)
; RV32I-NEXT:    sw a0, 24(sp)
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    sw a0, 20(sp)
; RV32I-NEXT:    sw a0, 16(sp)
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    sw a0, 12(sp)
; RV32I-NEXT:    sw a0, 8(sp)
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    sw a0, 4(sp)
; RV32I-NEXT:    sw a0, 0(sp)
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV32I-NEXT:    vsub.vx v9, v8, a0
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vand.vv v8, v8, v9
; RV32I-NEXT:    addi a0, sp, 24
; RV32I-NEXT:    vlse64.v v9, (a0), zero
; RV32I-NEXT:    addi a0, sp, 16
; RV32I-NEXT:    vlse64.v v10, (a0), zero
; RV32I-NEXT:    vsrl.vi v11, v8, 1
; RV32I-NEXT:    vand.vv v9, v11, v9
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    vand.vv v9, v8, v10
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vv v8, v8, v10
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    addi a0, sp, 8
; RV32I-NEXT:    vlse64.v v9, (a0), zero
; RV32I-NEXT:    mv a0, sp
; RV32I-NEXT:    vlse64.v v10, (a0), zero
; RV32I-NEXT:    vsrl.vi v11, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v11
; RV32I-NEXT:    vand.vv v8, v8, v9
; RV32I-NEXT:    vmul.vv v8, v8, v10
; RV32I-NEXT:    li a0, 56
; RV32I-NEXT:    vsrl.vx v8, v8, a0
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cttz_nxv1i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV64I-NEXT:    vsub.vx v9, v8, a0
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vand.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 209715
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 61681
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    lui a0, 4112
; RV64I-NEXT:    addiw a0, a0, 257
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    li a0, 56
; RV64I-NEXT:    vsrl.vx v8, v8, a0
; RV64I-NEXT:    ret
;
; RV32F-LABEL: cttz_nxv1i64:
; RV32F:       # %bb.0:
; RV32F-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV32F-NEXT:    vrsub.vi v9, v8, 0
; RV32F-NEXT:    vand.vv v9, v8, v9
; RV32F-NEXT:    fsrmi a0, 1
; RV32F-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; RV32F-NEXT:    vfncvt.f.xu.w v10, v9
; RV32F-NEXT:    vsrl.vi v9, v10, 23
; RV32F-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; RV32F-NEXT:    vzext.vf2 v10, v9
; RV32F-NEXT:    li a1, 127
; RV32F-NEXT:    vsub.vx v9, v10, a1
; RV32F-NEXT:    vmseq.vx v0, v8, zero
; RV32F-NEXT:    li a1, 64
; RV32F-NEXT:    vmerge.vxm v8, v9, a1, v0
; RV32F-NEXT:    fsrm a0
; RV32F-NEXT:    ret
;
; RV64F-LABEL: cttz_nxv1i64:
; RV64F:       # %bb.0:
; RV64F-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV64F-NEXT:    vrsub.vi v9, v8, 0
; RV64F-NEXT:    vand.vv v9, v8, v9
; RV64F-NEXT:    fsrmi a0, 1
; RV64F-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; RV64F-NEXT:    vfncvt.f.xu.w v10, v9
; RV64F-NEXT:    vsrl.vi v9, v10, 23
; RV64F-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; RV64F-NEXT:    vzext.vf2 v10, v9
; RV64F-NEXT:    li a1, 127
; RV64F-NEXT:    vsub.vx v9, v10, a1
; RV64F-NEXT:    vmseq.vi v0, v8, 0
; RV64F-NEXT:    li a1, 64
; RV64F-NEXT:    vmerge.vxm v8, v9, a1, v0
; RV64F-NEXT:    fsrm a0
; RV64F-NEXT:    ret
;
; RV32D-LABEL: cttz_nxv1i64:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV32D-NEXT:    vrsub.vi v9, v8, 0
; RV32D-NEXT:    vand.vv v9, v8, v9
; RV32D-NEXT:    fsrmi a0, 1
; RV32D-NEXT:    vfcvt.f.xu.v v9, v9
; RV32D-NEXT:    li a1, 52
; RV32D-NEXT:    vsrl.vx v9, v9, a1
; RV32D-NEXT:    li a1, 1023
; RV32D-NEXT:    vsub.vx v9, v9, a1
; RV32D-NEXT:    vmseq.vx v0, v8, zero
; RV32D-NEXT:    li a1, 64
; RV32D-NEXT:    vmerge.vxm v8, v9, a1, v0
; RV32D-NEXT:    fsrm a0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: cttz_nxv1i64:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV64D-NEXT:    vrsub.vi v9, v8, 0
; RV64D-NEXT:    vand.vv v9, v8, v9
; RV64D-NEXT:    fsrmi a0, 1
; RV64D-NEXT:    vfcvt.f.xu.v v9, v9
; RV64D-NEXT:    li a1, 52
; RV64D-NEXT:    vsrl.vx v9, v9, a1
; RV64D-NEXT:    li a1, 1023
; RV64D-NEXT:    vsub.vx v9, v9, a1
; RV64D-NEXT:    vmseq.vi v0, v8, 0
; RV64D-NEXT:    li a1, 64
; RV64D-NEXT:    vmerge.vxm v8, v9, a1, v0
; RV64D-NEXT:    fsrm a0
; RV64D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_nxv1i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 1 x i64> @llvm.cttz.nxv1i64(<vscale x 1 x i64> %va, i1 false)
  ret <vscale x 1 x i64> %a
}
declare <vscale x 1 x i64> @llvm.cttz.nxv1i64(<vscale x 1 x i64>, i1)

define <vscale x 2 x i64> @cttz_nxv2i64(<vscale x 2 x i64> %va) {
; RV32I-LABEL: cttz_nxv2i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    .cfi_def_cfa_offset 32
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    sw a0, 28(sp)
; RV32I-NEXT:    sw a0, 24(sp)
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    sw a0, 20(sp)
; RV32I-NEXT:    sw a0, 16(sp)
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    sw a0, 12(sp)
; RV32I-NEXT:    sw a0, 8(sp)
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    sw a0, 4(sp)
; RV32I-NEXT:    sw a0, 0(sp)
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; RV32I-NEXT:    vsub.vx v10, v8, a0
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vand.vv v8, v8, v10
; RV32I-NEXT:    addi a0, sp, 24
; RV32I-NEXT:    vlse64.v v10, (a0), zero
; RV32I-NEXT:    addi a0, sp, 16
; RV32I-NEXT:    vlse64.v v12, (a0), zero
; RV32I-NEXT:    vsrl.vi v14, v8, 1
; RV32I-NEXT:    vand.vv v10, v14, v10
; RV32I-NEXT:    vsub.vv v8, v8, v10
; RV32I-NEXT:    vand.vv v10, v8, v12
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vv v8, v8, v12
; RV32I-NEXT:    vadd.vv v8, v10, v8
; RV32I-NEXT:    addi a0, sp, 8
; RV32I-NEXT:    vlse64.v v10, (a0), zero
; RV32I-NEXT:    mv a0, sp
; RV32I-NEXT:    vlse64.v v12, (a0), zero
; RV32I-NEXT:    vsrl.vi v14, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v14
; RV32I-NEXT:    vand.vv v8, v8, v10
; RV32I-NEXT:    vmul.vv v8, v8, v12
; RV32I-NEXT:    li a0, 56
; RV32I-NEXT:    vsrl.vx v8, v8, a0
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cttz_nxv2i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; RV64I-NEXT:    vsub.vx v10, v8, a0
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vand.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vand.vx v10, v10, a0
; RV64I-NEXT:    vsub.vv v8, v8, v10
; RV64I-NEXT:    lui a0, 209715
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vand.vx v10, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v10, v8
; RV64I-NEXT:    vsrl.vi v10, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v10
; RV64I-NEXT:    lui a0, 61681
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    lui a0, 4112
; RV64I-NEXT:    addiw a0, a0, 257
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    li a0, 56
; RV64I-NEXT:    vsrl.vx v8, v8, a0
; RV64I-NEXT:    ret
;
; RV32F-LABEL: cttz_nxv2i64:
; RV32F:       # %bb.0:
; RV32F-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV32F-NEXT:    vrsub.vi v10, v8, 0
; RV32F-NEXT:    vand.vv v10, v8, v10
; RV32F-NEXT:    fsrmi a0, 1
; RV32F-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; RV32F-NEXT:    vfncvt.f.xu.w v12, v10
; RV32F-NEXT:    vsrl.vi v10, v12, 23
; RV32F-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; RV32F-NEXT:    vzext.vf2 v12, v10
; RV32F-NEXT:    li a1, 127
; RV32F-NEXT:    vsub.vx v10, v12, a1
; RV32F-NEXT:    vmseq.vx v0, v8, zero
; RV32F-NEXT:    li a1, 64
; RV32F-NEXT:    vmerge.vxm v8, v10, a1, v0
; RV32F-NEXT:    fsrm a0
; RV32F-NEXT:    ret
;
; RV64F-LABEL: cttz_nxv2i64:
; RV64F:       # %bb.0:
; RV64F-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV64F-NEXT:    vrsub.vi v10, v8, 0
; RV64F-NEXT:    vand.vv v10, v8, v10
; RV64F-NEXT:    fsrmi a0, 1
; RV64F-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; RV64F-NEXT:    vfncvt.f.xu.w v12, v10
; RV64F-NEXT:    vsrl.vi v10, v12, 23
; RV64F-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; RV64F-NEXT:    vzext.vf2 v12, v10
; RV64F-NEXT:    li a1, 127
; RV64F-NEXT:    vsub.vx v10, v12, a1
; RV64F-NEXT:    vmseq.vi v0, v8, 0
; RV64F-NEXT:    li a1, 64
; RV64F-NEXT:    vmerge.vxm v8, v10, a1, v0
; RV64F-NEXT:    fsrm a0
; RV64F-NEXT:    ret
;
; RV32D-LABEL: cttz_nxv2i64:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV32D-NEXT:    vrsub.vi v10, v8, 0
; RV32D-NEXT:    vand.vv v10, v8, v10
; RV32D-NEXT:    fsrmi a0, 1
; RV32D-NEXT:    vfcvt.f.xu.v v10, v10
; RV32D-NEXT:    li a1, 52
; RV32D-NEXT:    vsrl.vx v10, v10, a1
; RV32D-NEXT:    li a1, 1023
; RV32D-NEXT:    vsub.vx v10, v10, a1
; RV32D-NEXT:    vmseq.vx v0, v8, zero
; RV32D-NEXT:    li a1, 64
; RV32D-NEXT:    vmerge.vxm v8, v10, a1, v0
; RV32D-NEXT:    fsrm a0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: cttz_nxv2i64:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV64D-NEXT:    vrsub.vi v10, v8, 0
; RV64D-NEXT:    vand.vv v10, v8, v10
; RV64D-NEXT:    fsrmi a0, 1
; RV64D-NEXT:    vfcvt.f.xu.v v10, v10
; RV64D-NEXT:    li a1, 52
; RV64D-NEXT:    vsrl.vx v10, v10, a1
; RV64D-NEXT:    li a1, 1023
; RV64D-NEXT:    vsub.vx v10, v10, a1
; RV64D-NEXT:    vmseq.vi v0, v8, 0
; RV64D-NEXT:    li a1, 64
; RV64D-NEXT:    vmerge.vxm v8, v10, a1, v0
; RV64D-NEXT:    fsrm a0
; RV64D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_nxv2i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 2 x i64> @llvm.cttz.nxv2i64(<vscale x 2 x i64> %va, i1 false)
  ret <vscale x 2 x i64> %a
}
declare <vscale x 2 x i64> @llvm.cttz.nxv2i64(<vscale x 2 x i64>, i1)

define <vscale x 4 x i64> @cttz_nxv4i64(<vscale x 4 x i64> %va) {
; RV32I-LABEL: cttz_nxv4i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    .cfi_def_cfa_offset 32
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    sw a0, 28(sp)
; RV32I-NEXT:    sw a0, 24(sp)
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    sw a0, 20(sp)
; RV32I-NEXT:    sw a0, 16(sp)
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    sw a0, 12(sp)
; RV32I-NEXT:    sw a0, 8(sp)
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    sw a0, 4(sp)
; RV32I-NEXT:    sw a0, 0(sp)
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; RV32I-NEXT:    vsub.vx v12, v8, a0
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vand.vv v8, v8, v12
; RV32I-NEXT:    addi a0, sp, 24
; RV32I-NEXT:    vlse64.v v12, (a0), zero
; RV32I-NEXT:    addi a0, sp, 16
; RV32I-NEXT:    vlse64.v v16, (a0), zero
; RV32I-NEXT:    vsrl.vi v20, v8, 1
; RV32I-NEXT:    vand.vv v12, v20, v12
; RV32I-NEXT:    vsub.vv v8, v8, v12
; RV32I-NEXT:    vand.vv v12, v8, v16
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vv v8, v8, v16
; RV32I-NEXT:    vadd.vv v8, v12, v8
; RV32I-NEXT:    addi a0, sp, 8
; RV32I-NEXT:    vlse64.v v12, (a0), zero
; RV32I-NEXT:    mv a0, sp
; RV32I-NEXT:    vlse64.v v16, (a0), zero
; RV32I-NEXT:    vsrl.vi v20, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v20
; RV32I-NEXT:    vand.vv v8, v8, v12
; RV32I-NEXT:    vmul.vv v8, v8, v16
; RV32I-NEXT:    li a0, 56
; RV32I-NEXT:    vsrl.vx v8, v8, a0
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cttz_nxv4i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; RV64I-NEXT:    vsub.vx v12, v8, a0
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vand.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vi v12, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vand.vx v12, v12, a0
; RV64I-NEXT:    vsub.vv v8, v8, v12
; RV64I-NEXT:    lui a0, 209715
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vand.vx v12, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v12, v8
; RV64I-NEXT:    vsrl.vi v12, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v12
; RV64I-NEXT:    lui a0, 61681
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    lui a0, 4112
; RV64I-NEXT:    addiw a0, a0, 257
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    li a0, 56
; RV64I-NEXT:    vsrl.vx v8, v8, a0
; RV64I-NEXT:    ret
;
; RV32F-LABEL: cttz_nxv4i64:
; RV32F:       # %bb.0:
; RV32F-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV32F-NEXT:    vrsub.vi v12, v8, 0
; RV32F-NEXT:    vand.vv v12, v8, v12
; RV32F-NEXT:    fsrmi a0, 1
; RV32F-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; RV32F-NEXT:    vfncvt.f.xu.w v16, v12
; RV32F-NEXT:    vsrl.vi v12, v16, 23
; RV32F-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; RV32F-NEXT:    vzext.vf2 v16, v12
; RV32F-NEXT:    li a1, 127
; RV32F-NEXT:    vsub.vx v12, v16, a1
; RV32F-NEXT:    vmseq.vx v0, v8, zero
; RV32F-NEXT:    li a1, 64
; RV32F-NEXT:    vmerge.vxm v8, v12, a1, v0
; RV32F-NEXT:    fsrm a0
; RV32F-NEXT:    ret
;
; RV64F-LABEL: cttz_nxv4i64:
; RV64F:       # %bb.0:
; RV64F-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV64F-NEXT:    vrsub.vi v12, v8, 0
; RV64F-NEXT:    vand.vv v12, v8, v12
; RV64F-NEXT:    fsrmi a0, 1
; RV64F-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; RV64F-NEXT:    vfncvt.f.xu.w v16, v12
; RV64F-NEXT:    vsrl.vi v12, v16, 23
; RV64F-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; RV64F-NEXT:    vzext.vf2 v16, v12
; RV64F-NEXT:    li a1, 127
; RV64F-NEXT:    vsub.vx v12, v16, a1
; RV64F-NEXT:    vmseq.vi v0, v8, 0
; RV64F-NEXT:    li a1, 64
; RV64F-NEXT:    vmerge.vxm v8, v12, a1, v0
; RV64F-NEXT:    fsrm a0
; RV64F-NEXT:    ret
;
; RV32D-LABEL: cttz_nxv4i64:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV32D-NEXT:    vrsub.vi v12, v8, 0
; RV32D-NEXT:    vand.vv v12, v8, v12
; RV32D-NEXT:    fsrmi a0, 1
; RV32D-NEXT:    vfcvt.f.xu.v v12, v12
; RV32D-NEXT:    li a1, 52
; RV32D-NEXT:    vsrl.vx v12, v12, a1
; RV32D-NEXT:    li a1, 1023
; RV32D-NEXT:    vsub.vx v12, v12, a1
; RV32D-NEXT:    vmseq.vx v0, v8, zero
; RV32D-NEXT:    li a1, 64
; RV32D-NEXT:    vmerge.vxm v8, v12, a1, v0
; RV32D-NEXT:    fsrm a0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: cttz_nxv4i64:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV64D-NEXT:    vrsub.vi v12, v8, 0
; RV64D-NEXT:    vand.vv v12, v8, v12
; RV64D-NEXT:    fsrmi a0, 1
; RV64D-NEXT:    vfcvt.f.xu.v v12, v12
; RV64D-NEXT:    li a1, 52
; RV64D-NEXT:    vsrl.vx v12, v12, a1
; RV64D-NEXT:    li a1, 1023
; RV64D-NEXT:    vsub.vx v12, v12, a1
; RV64D-NEXT:    vmseq.vi v0, v8, 0
; RV64D-NEXT:    li a1, 64
; RV64D-NEXT:    vmerge.vxm v8, v12, a1, v0
; RV64D-NEXT:    fsrm a0
; RV64D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_nxv4i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 4 x i64> @llvm.cttz.nxv4i64(<vscale x 4 x i64> %va, i1 false)
  ret <vscale x 4 x i64> %a
}
declare <vscale x 4 x i64> @llvm.cttz.nxv4i64(<vscale x 4 x i64>, i1)

define <vscale x 8 x i64> @cttz_nxv8i64(<vscale x 8 x i64> %va) {
; RV32I-LABEL: cttz_nxv8i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    .cfi_def_cfa_offset 32
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    sw a0, 28(sp)
; RV32I-NEXT:    sw a0, 24(sp)
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    sw a0, 20(sp)
; RV32I-NEXT:    sw a0, 16(sp)
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    sw a0, 12(sp)
; RV32I-NEXT:    sw a0, 8(sp)
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    sw a0, 4(sp)
; RV32I-NEXT:    sw a0, 0(sp)
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32I-NEXT:    vsub.vx v16, v8, a0
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vand.vv v8, v8, v16
; RV32I-NEXT:    addi a0, sp, 24
; RV32I-NEXT:    vlse64.v v16, (a0), zero
; RV32I-NEXT:    addi a0, sp, 16
; RV32I-NEXT:    vlse64.v v24, (a0), zero
; RV32I-NEXT:    vsrl.vi v0, v8, 1
; RV32I-NEXT:    vand.vv v16, v0, v16
; RV32I-NEXT:    vsub.vv v8, v8, v16
; RV32I-NEXT:    vand.vv v16, v8, v24
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vv v8, v8, v24
; RV32I-NEXT:    vadd.vv v8, v16, v8
; RV32I-NEXT:    addi a0, sp, 8
; RV32I-NEXT:    vlse64.v v16, (a0), zero
; RV32I-NEXT:    mv a0, sp
; RV32I-NEXT:    vlse64.v v24, (a0), zero
; RV32I-NEXT:    vsrl.vi v0, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v0
; RV32I-NEXT:    vand.vv v8, v8, v16
; RV32I-NEXT:    vmul.vv v8, v8, v24
; RV32I-NEXT:    li a0, 56
; RV32I-NEXT:    vsrl.vx v8, v8, a0
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cttz_nxv8i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV64I-NEXT:    vsub.vx v16, v8, a0
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vand.vv v8, v8, v16
; RV64I-NEXT:    vsrl.vi v16, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vand.vx v16, v16, a0
; RV64I-NEXT:    vsub.vv v8, v8, v16
; RV64I-NEXT:    lui a0, 209715
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vand.vx v16, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v16, v8
; RV64I-NEXT:    vsrl.vi v16, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v16
; RV64I-NEXT:    lui a0, 61681
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    lui a0, 4112
; RV64I-NEXT:    addiw a0, a0, 257
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    li a0, 56
; RV64I-NEXT:    vsrl.vx v8, v8, a0
; RV64I-NEXT:    ret
;
; RV32F-LABEL: cttz_nxv8i64:
; RV32F:       # %bb.0:
; RV32F-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; RV32F-NEXT:    vrsub.vi v16, v8, 0
; RV32F-NEXT:    vand.vv v16, v8, v16
; RV32F-NEXT:    fsrmi a0, 1
; RV32F-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; RV32F-NEXT:    vfncvt.f.xu.w v24, v16
; RV32F-NEXT:    vsrl.vi v16, v24, 23
; RV32F-NEXT:    vsetvli zero, zero, e64, m8, ta, ma
; RV32F-NEXT:    vzext.vf2 v24, v16
; RV32F-NEXT:    li a1, 127
; RV32F-NEXT:    vsub.vx v16, v24, a1
; RV32F-NEXT:    vmseq.vx v0, v8, zero
; RV32F-NEXT:    li a1, 64
; RV32F-NEXT:    vmerge.vxm v8, v16, a1, v0
; RV32F-NEXT:    fsrm a0
; RV32F-NEXT:    ret
;
; RV64F-LABEL: cttz_nxv8i64:
; RV64F:       # %bb.0:
; RV64F-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; RV64F-NEXT:    vrsub.vi v16, v8, 0
; RV64F-NEXT:    vand.vv v16, v8, v16
; RV64F-NEXT:    fsrmi a0, 1
; RV64F-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; RV64F-NEXT:    vfncvt.f.xu.w v24, v16
; RV64F-NEXT:    vsrl.vi v16, v24, 23
; RV64F-NEXT:    vsetvli zero, zero, e64, m8, ta, ma
; RV64F-NEXT:    vzext.vf2 v24, v16
; RV64F-NEXT:    li a1, 127
; RV64F-NEXT:    vsub.vx v16, v24, a1
; RV64F-NEXT:    vmseq.vi v0, v8, 0
; RV64F-NEXT:    li a1, 64
; RV64F-NEXT:    vmerge.vxm v8, v16, a1, v0
; RV64F-NEXT:    fsrm a0
; RV64F-NEXT:    ret
;
; RV32D-LABEL: cttz_nxv8i64:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; RV32D-NEXT:    vrsub.vi v16, v8, 0
; RV32D-NEXT:    vand.vv v16, v8, v16
; RV32D-NEXT:    fsrmi a0, 1
; RV32D-NEXT:    vfcvt.f.xu.v v16, v16
; RV32D-NEXT:    li a1, 52
; RV32D-NEXT:    vsrl.vx v16, v16, a1
; RV32D-NEXT:    li a1, 1023
; RV32D-NEXT:    vsub.vx v16, v16, a1
; RV32D-NEXT:    vmseq.vx v0, v8, zero
; RV32D-NEXT:    li a1, 64
; RV32D-NEXT:    vmerge.vxm v8, v16, a1, v0
; RV32D-NEXT:    fsrm a0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: cttz_nxv8i64:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; RV64D-NEXT:    vrsub.vi v16, v8, 0
; RV64D-NEXT:    vand.vv v16, v8, v16
; RV64D-NEXT:    fsrmi a0, 1
; RV64D-NEXT:    vfcvt.f.xu.v v16, v16
; RV64D-NEXT:    li a1, 52
; RV64D-NEXT:    vsrl.vx v16, v16, a1
; RV64D-NEXT:    li a1, 1023
; RV64D-NEXT:    vsub.vx v16, v16, a1
; RV64D-NEXT:    vmseq.vi v0, v8, 0
; RV64D-NEXT:    li a1, 64
; RV64D-NEXT:    vmerge.vxm v8, v16, a1, v0
; RV64D-NEXT:    fsrm a0
; RV64D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_nxv8i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 8 x i64> @llvm.cttz.nxv8i64(<vscale x 8 x i64> %va, i1 false)
  ret <vscale x 8 x i64> %a
}
declare <vscale x 8 x i64> @llvm.cttz.nxv8i64(<vscale x 8 x i64>, i1)

define <vscale x 1 x i8> @cttz_zero_undef_nxv1i8(<vscale x 1 x i8> %va) {
; CHECK-ZVE64X-LABEL: cttz_zero_undef_nxv1i8:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    li a0, 1
; CHECK-ZVE64X-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; CHECK-ZVE64X-NEXT:    vsub.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vand.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    li a0, 85
; CHECK-ZVE64X-NEXT:    vand.vx v9, v9, a0
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    li a0, 51
; CHECK-ZVE64X-NEXT:    vand.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v9, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vi v8, v8, 15
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: cttz_zero_undef_nxv1i8:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-F-NEXT:    vrsub.vi v9, v8, 0
; CHECK-F-NEXT:    vand.vv v8, v8, v9
; CHECK-F-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-F-NEXT:    vzext.vf2 v9, v8
; CHECK-F-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-F-NEXT:    vnsrl.wi v8, v8, 23
; CHECK-F-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-F-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-F-NEXT:    li a0, 127
; CHECK-F-NEXT:    vsub.vx v8, v8, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_zero_undef_nxv1i8:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-D-NEXT:    vrsub.vi v9, v8, 0
; CHECK-D-NEXT:    vand.vv v8, v8, v9
; CHECK-D-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-D-NEXT:    vzext.vf2 v9, v8
; CHECK-D-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-D-NEXT:    vnsrl.wi v8, v8, 23
; CHECK-D-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-D-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-D-NEXT:    li a0, 127
; CHECK-D-NEXT:    vsub.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_zero_undef_nxv1i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 1 x i8> @llvm.cttz.nxv1i8(<vscale x 1 x i8> %va, i1 true)
  ret <vscale x 1 x i8> %a
}

define <vscale x 2 x i8> @cttz_zero_undef_nxv2i8(<vscale x 2 x i8> %va) {
; CHECK-ZVE64X-LABEL: cttz_zero_undef_nxv2i8:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    li a0, 1
; CHECK-ZVE64X-NEXT:    vsetvli a1, zero, e8, mf4, ta, ma
; CHECK-ZVE64X-NEXT:    vsub.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vand.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    li a0, 85
; CHECK-ZVE64X-NEXT:    vand.vx v9, v9, a0
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    li a0, 51
; CHECK-ZVE64X-NEXT:    vand.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v9, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vi v8, v8, 15
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: cttz_zero_undef_nxv2i8:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-F-NEXT:    vrsub.vi v9, v8, 0
; CHECK-F-NEXT:    vand.vv v8, v8, v9
; CHECK-F-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-F-NEXT:    vzext.vf2 v9, v8
; CHECK-F-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-F-NEXT:    vnsrl.wi v8, v8, 23
; CHECK-F-NEXT:    vsetvli zero, zero, e8, mf4, ta, ma
; CHECK-F-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-F-NEXT:    li a0, 127
; CHECK-F-NEXT:    vsub.vx v8, v8, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_zero_undef_nxv2i8:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-D-NEXT:    vrsub.vi v9, v8, 0
; CHECK-D-NEXT:    vand.vv v8, v8, v9
; CHECK-D-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-D-NEXT:    vzext.vf2 v9, v8
; CHECK-D-NEXT:    vfwcvt.f.xu.v v8, v9
; CHECK-D-NEXT:    vnsrl.wi v8, v8, 23
; CHECK-D-NEXT:    vsetvli zero, zero, e8, mf4, ta, ma
; CHECK-D-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-D-NEXT:    li a0, 127
; CHECK-D-NEXT:    vsub.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_zero_undef_nxv2i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 2 x i8> @llvm.cttz.nxv2i8(<vscale x 2 x i8> %va, i1 true)
  ret <vscale x 2 x i8> %a
}

define <vscale x 4 x i8> @cttz_zero_undef_nxv4i8(<vscale x 4 x i8> %va) {
; CHECK-ZVE64X-LABEL: cttz_zero_undef_nxv4i8:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    li a0, 1
; CHECK-ZVE64X-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; CHECK-ZVE64X-NEXT:    vsub.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vand.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    li a0, 85
; CHECK-ZVE64X-NEXT:    vand.vx v9, v9, a0
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    li a0, 51
; CHECK-ZVE64X-NEXT:    vand.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v9, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vi v8, v8, 15
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: cttz_zero_undef_nxv4i8:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-F-NEXT:    vrsub.vi v9, v8, 0
; CHECK-F-NEXT:    vand.vv v8, v8, v9
; CHECK-F-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-F-NEXT:    vzext.vf2 v9, v8
; CHECK-F-NEXT:    vfwcvt.f.xu.v v10, v9
; CHECK-F-NEXT:    vnsrl.wi v8, v10, 23
; CHECK-F-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; CHECK-F-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-F-NEXT:    li a0, 127
; CHECK-F-NEXT:    vsub.vx v8, v8, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_zero_undef_nxv4i8:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-D-NEXT:    vrsub.vi v9, v8, 0
; CHECK-D-NEXT:    vand.vv v8, v8, v9
; CHECK-D-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-D-NEXT:    vzext.vf2 v9, v8
; CHECK-D-NEXT:    vfwcvt.f.xu.v v10, v9
; CHECK-D-NEXT:    vnsrl.wi v8, v10, 23
; CHECK-D-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; CHECK-D-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-D-NEXT:    li a0, 127
; CHECK-D-NEXT:    vsub.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_zero_undef_nxv4i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 4 x i8> @llvm.cttz.nxv4i8(<vscale x 4 x i8> %va, i1 true)
  ret <vscale x 4 x i8> %a
}

define <vscale x 8 x i8> @cttz_zero_undef_nxv8i8(<vscale x 8 x i8> %va) {
; CHECK-ZVE64X-LABEL: cttz_zero_undef_nxv8i8:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    li a0, 1
; CHECK-ZVE64X-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-ZVE64X-NEXT:    vsub.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vand.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 1
; CHECK-ZVE64X-NEXT:    li a0, 85
; CHECK-ZVE64X-NEXT:    vand.vx v9, v9, a0
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    li a0, 51
; CHECK-ZVE64X-NEXT:    vand.vx v9, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v9, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v9, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v9
; CHECK-ZVE64X-NEXT:    vand.vi v8, v8, 15
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: cttz_zero_undef_nxv8i8:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-F-NEXT:    vrsub.vi v9, v8, 0
; CHECK-F-NEXT:    vand.vv v8, v8, v9
; CHECK-F-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-F-NEXT:    vzext.vf2 v10, v8
; CHECK-F-NEXT:    vfwcvt.f.xu.v v12, v10
; CHECK-F-NEXT:    vnsrl.wi v8, v12, 23
; CHECK-F-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; CHECK-F-NEXT:    vnsrl.wi v10, v8, 0
; CHECK-F-NEXT:    li a0, 127
; CHECK-F-NEXT:    vsub.vx v8, v10, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_zero_undef_nxv8i8:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-D-NEXT:    vrsub.vi v9, v8, 0
; CHECK-D-NEXT:    vand.vv v8, v8, v9
; CHECK-D-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-D-NEXT:    vzext.vf2 v10, v8
; CHECK-D-NEXT:    vfwcvt.f.xu.v v12, v10
; CHECK-D-NEXT:    vnsrl.wi v8, v12, 23
; CHECK-D-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; CHECK-D-NEXT:    vnsrl.wi v10, v8, 0
; CHECK-D-NEXT:    li a0, 127
; CHECK-D-NEXT:    vsub.vx v8, v10, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_zero_undef_nxv8i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 8 x i8> @llvm.cttz.nxv8i8(<vscale x 8 x i8> %va, i1 true)
  ret <vscale x 8 x i8> %a
}

define <vscale x 16 x i8> @cttz_zero_undef_nxv16i8(<vscale x 16 x i8> %va) {
; CHECK-ZVE64X-LABEL: cttz_zero_undef_nxv16i8:
; CHECK-ZVE64X:       # %bb.0:
; CHECK-ZVE64X-NEXT:    li a0, 1
; CHECK-ZVE64X-NEXT:    vsetvli a1, zero, e8, m2, ta, ma
; CHECK-ZVE64X-NEXT:    vsub.vx v10, v8, a0
; CHECK-ZVE64X-NEXT:    vnot.v v8, v8
; CHECK-ZVE64X-NEXT:    vand.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 1
; CHECK-ZVE64X-NEXT:    li a0, 85
; CHECK-ZVE64X-NEXT:    vand.vx v10, v10, a0
; CHECK-ZVE64X-NEXT:    vsub.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    li a0, 51
; CHECK-ZVE64X-NEXT:    vand.vx v10, v8, a0
; CHECK-ZVE64X-NEXT:    vsrl.vi v8, v8, 2
; CHECK-ZVE64X-NEXT:    vand.vx v8, v8, a0
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v10, v8
; CHECK-ZVE64X-NEXT:    vsrl.vi v10, v8, 4
; CHECK-ZVE64X-NEXT:    vadd.vv v8, v8, v10
; CHECK-ZVE64X-NEXT:    vand.vi v8, v8, 15
; CHECK-ZVE64X-NEXT:    ret
;
; CHECK-F-LABEL: cttz_zero_undef_nxv16i8:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-F-NEXT:    vrsub.vi v10, v8, 0
; CHECK-F-NEXT:    vand.vv v8, v8, v10
; CHECK-F-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; CHECK-F-NEXT:    vzext.vf2 v12, v8
; CHECK-F-NEXT:    vfwcvt.f.xu.v v16, v12
; CHECK-F-NEXT:    vnsrl.wi v8, v16, 23
; CHECK-F-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; CHECK-F-NEXT:    vnsrl.wi v12, v8, 0
; CHECK-F-NEXT:    li a0, 127
; CHECK-F-NEXT:    vsub.vx v8, v12, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_zero_undef_nxv16i8:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-D-NEXT:    vrsub.vi v10, v8, 0
; CHECK-D-NEXT:    vand.vv v8, v8, v10
; CHECK-D-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; CHECK-D-NEXT:    vzext.vf2 v12, v8
; CHECK-D-NEXT:    vfwcvt.f.xu.v v16, v12
; CHECK-D-NEXT:    vnsrl.wi v8, v16, 23
; CHECK-D-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; CHECK-D-NEXT:    vnsrl.wi v12, v8, 0
; CHECK-D-NEXT:    li a0, 127
; CHECK-D-NEXT:    vsub.vx v8, v12, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_zero_undef_nxv16i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 16 x i8> @llvm.cttz.nxv16i8(<vscale x 16 x i8> %va, i1 true)
  ret <vscale x 16 x i8> %a
}

define <vscale x 32 x i8> @cttz_zero_undef_nxv32i8(<vscale x 32 x i8> %va) {
; CHECK-LABEL: cttz_zero_undef_nxv32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 1
; CHECK-NEXT:    vsetvli a1, zero, e8, m4, ta, ma
; CHECK-NEXT:    vsub.vx v12, v8, a0
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v8, v12
; CHECK-NEXT:    vsrl.vi v12, v8, 1
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v12, v12, a0
; CHECK-NEXT:    vsub.vv v8, v8, v12
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v12, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v12, v8
; CHECK-NEXT:    vsrl.vi v12, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v12
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_zero_undef_nxv32i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 32 x i8> @llvm.cttz.nxv32i8(<vscale x 32 x i8> %va, i1 true)
  ret <vscale x 32 x i8> %a
}

define <vscale x 64 x i8> @cttz_zero_undef_nxv64i8(<vscale x 64 x i8> %va) {
; CHECK-LABEL: cttz_zero_undef_nxv64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 1
; CHECK-NEXT:    vsetvli a1, zero, e8, m8, ta, ma
; CHECK-NEXT:    vsub.vx v16, v8, a0
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v8, v16
; CHECK-NEXT:    vsrl.vi v16, v8, 1
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v16, v16, a0
; CHECK-NEXT:    vsub.vv v8, v8, v16
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v16, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v16, v8
; CHECK-NEXT:    vsrl.vi v16, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v16
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_zero_undef_nxv64i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 64 x i8> @llvm.cttz.nxv64i8(<vscale x 64 x i8> %va, i1 true)
  ret <vscale x 64 x i8> %a
}

define <vscale x 1 x i16> @cttz_zero_undef_nxv1i16(<vscale x 1 x i16> %va) {
; RV32I-LABEL: cttz_zero_undef_nxv1i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; RV32I-NEXT:    vsub.vx v9, v8, a0
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vand.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    lui a0, 5
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v9, v9, a0
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 3
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v9, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 1
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    li a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 8
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cttz_zero_undef_nxv1i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; RV64I-NEXT:    vsub.vx v9, v8, a0
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vand.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    lui a0, 5
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 3
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 1
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    li a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 8
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: cttz_zero_undef_nxv1i16:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-F-NEXT:    vrsub.vi v9, v8, 0
; CHECK-F-NEXT:    vand.vv v8, v8, v9
; CHECK-F-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-F-NEXT:    vnsrl.wi v8, v9, 23
; CHECK-F-NEXT:    li a0, 127
; CHECK-F-NEXT:    vsub.vx v8, v8, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_zero_undef_nxv1i16:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-D-NEXT:    vrsub.vi v9, v8, 0
; CHECK-D-NEXT:    vand.vv v8, v8, v9
; CHECK-D-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-D-NEXT:    vnsrl.wi v8, v9, 23
; CHECK-D-NEXT:    li a0, 127
; CHECK-D-NEXT:    vsub.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_zero_undef_nxv1i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 1 x i16> @llvm.cttz.nxv1i16(<vscale x 1 x i16> %va, i1 true)
  ret <vscale x 1 x i16> %a
}

define <vscale x 2 x i16> @cttz_zero_undef_nxv2i16(<vscale x 2 x i16> %va) {
; RV32I-LABEL: cttz_zero_undef_nxv2i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; RV32I-NEXT:    vsub.vx v9, v8, a0
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vand.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    lui a0, 5
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v9, v9, a0
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 3
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v9, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 1
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    li a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 8
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cttz_zero_undef_nxv2i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; RV64I-NEXT:    vsub.vx v9, v8, a0
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vand.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    lui a0, 5
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 3
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 1
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    li a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 8
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: cttz_zero_undef_nxv2i16:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-F-NEXT:    vrsub.vi v9, v8, 0
; CHECK-F-NEXT:    vand.vv v8, v8, v9
; CHECK-F-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-F-NEXT:    vnsrl.wi v8, v9, 23
; CHECK-F-NEXT:    li a0, 127
; CHECK-F-NEXT:    vsub.vx v8, v8, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_zero_undef_nxv2i16:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-D-NEXT:    vrsub.vi v9, v8, 0
; CHECK-D-NEXT:    vand.vv v8, v8, v9
; CHECK-D-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-D-NEXT:    vnsrl.wi v8, v9, 23
; CHECK-D-NEXT:    li a0, 127
; CHECK-D-NEXT:    vsub.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_zero_undef_nxv2i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 2 x i16> @llvm.cttz.nxv2i16(<vscale x 2 x i16> %va, i1 true)
  ret <vscale x 2 x i16> %a
}

define <vscale x 4 x i16> @cttz_zero_undef_nxv4i16(<vscale x 4 x i16> %va) {
; RV32I-LABEL: cttz_zero_undef_nxv4i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; RV32I-NEXT:    vsub.vx v9, v8, a0
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vand.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    lui a0, 5
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v9, v9, a0
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 3
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v9, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 1
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    li a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 8
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cttz_zero_undef_nxv4i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; RV64I-NEXT:    vsub.vx v9, v8, a0
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vand.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    lui a0, 5
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 3
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 1
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    li a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 8
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: cttz_zero_undef_nxv4i16:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-F-NEXT:    vrsub.vi v9, v8, 0
; CHECK-F-NEXT:    vand.vv v8, v8, v9
; CHECK-F-NEXT:    vfwcvt.f.xu.v v10, v8
; CHECK-F-NEXT:    vnsrl.wi v8, v10, 23
; CHECK-F-NEXT:    li a0, 127
; CHECK-F-NEXT:    vsub.vx v8, v8, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_zero_undef_nxv4i16:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-D-NEXT:    vrsub.vi v9, v8, 0
; CHECK-D-NEXT:    vand.vv v8, v8, v9
; CHECK-D-NEXT:    vfwcvt.f.xu.v v10, v8
; CHECK-D-NEXT:    vnsrl.wi v8, v10, 23
; CHECK-D-NEXT:    li a0, 127
; CHECK-D-NEXT:    vsub.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_zero_undef_nxv4i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 4 x i16> @llvm.cttz.nxv4i16(<vscale x 4 x i16> %va, i1 true)
  ret <vscale x 4 x i16> %a
}

define <vscale x 8 x i16> @cttz_zero_undef_nxv8i16(<vscale x 8 x i16> %va) {
; RV32I-LABEL: cttz_zero_undef_nxv8i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; RV32I-NEXT:    vsub.vx v10, v8, a0
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vand.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 1
; RV32I-NEXT:    lui a0, 5
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v10, v10, a0
; RV32I-NEXT:    vsub.vv v8, v8, v10
; RV32I-NEXT:    lui a0, 3
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v10, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v10, v8
; RV32I-NEXT:    vsrl.vi v10, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v10
; RV32I-NEXT:    lui a0, 1
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    li a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 8
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cttz_zero_undef_nxv8i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; RV64I-NEXT:    vsub.vx v10, v8, a0
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vand.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 1
; RV64I-NEXT:    lui a0, 5
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v10, v10, a0
; RV64I-NEXT:    vsub.vv v8, v8, v10
; RV64I-NEXT:    lui a0, 3
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v10, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v10, v8
; RV64I-NEXT:    vsrl.vi v10, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v10
; RV64I-NEXT:    lui a0, 1
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    li a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 8
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: cttz_zero_undef_nxv8i16:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-F-NEXT:    vrsub.vi v10, v8, 0
; CHECK-F-NEXT:    vand.vv v8, v8, v10
; CHECK-F-NEXT:    vfwcvt.f.xu.v v12, v8
; CHECK-F-NEXT:    vnsrl.wi v8, v12, 23
; CHECK-F-NEXT:    li a0, 127
; CHECK-F-NEXT:    vsub.vx v8, v8, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_zero_undef_nxv8i16:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-D-NEXT:    vrsub.vi v10, v8, 0
; CHECK-D-NEXT:    vand.vv v8, v8, v10
; CHECK-D-NEXT:    vfwcvt.f.xu.v v12, v8
; CHECK-D-NEXT:    vnsrl.wi v8, v12, 23
; CHECK-D-NEXT:    li a0, 127
; CHECK-D-NEXT:    vsub.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_zero_undef_nxv8i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 8 x i16> @llvm.cttz.nxv8i16(<vscale x 8 x i16> %va, i1 true)
  ret <vscale x 8 x i16> %a
}

define <vscale x 16 x i16> @cttz_zero_undef_nxv16i16(<vscale x 16 x i16> %va) {
; RV32I-LABEL: cttz_zero_undef_nxv16i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    vsetvli a1, zero, e16, m4, ta, ma
; RV32I-NEXT:    vsub.vx v12, v8, a0
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vand.vv v8, v8, v12
; RV32I-NEXT:    vsrl.vi v12, v8, 1
; RV32I-NEXT:    lui a0, 5
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v12, v12, a0
; RV32I-NEXT:    vsub.vv v8, v8, v12
; RV32I-NEXT:    lui a0, 3
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v12, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v12, v8
; RV32I-NEXT:    vsrl.vi v12, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v12
; RV32I-NEXT:    lui a0, 1
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    li a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 8
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cttz_zero_undef_nxv16i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    vsetvli a1, zero, e16, m4, ta, ma
; RV64I-NEXT:    vsub.vx v12, v8, a0
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vand.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vi v12, v8, 1
; RV64I-NEXT:    lui a0, 5
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v12, v12, a0
; RV64I-NEXT:    vsub.vv v8, v8, v12
; RV64I-NEXT:    lui a0, 3
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v12, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v12, v8
; RV64I-NEXT:    vsrl.vi v12, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v12
; RV64I-NEXT:    lui a0, 1
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    li a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 8
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: cttz_zero_undef_nxv16i16:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-F-NEXT:    vrsub.vi v12, v8, 0
; CHECK-F-NEXT:    vand.vv v8, v8, v12
; CHECK-F-NEXT:    vfwcvt.f.xu.v v16, v8
; CHECK-F-NEXT:    vnsrl.wi v8, v16, 23
; CHECK-F-NEXT:    li a0, 127
; CHECK-F-NEXT:    vsub.vx v8, v8, a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_zero_undef_nxv16i16:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-D-NEXT:    vrsub.vi v12, v8, 0
; CHECK-D-NEXT:    vand.vv v8, v8, v12
; CHECK-D-NEXT:    vfwcvt.f.xu.v v16, v8
; CHECK-D-NEXT:    vnsrl.wi v8, v16, 23
; CHECK-D-NEXT:    li a0, 127
; CHECK-D-NEXT:    vsub.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_zero_undef_nxv16i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 16 x i16> @llvm.cttz.nxv16i16(<vscale x 16 x i16> %va, i1 true)
  ret <vscale x 16 x i16> %a
}

define <vscale x 32 x i16> @cttz_zero_undef_nxv32i16(<vscale x 32 x i16> %va) {
; RV32-LABEL: cttz_zero_undef_nxv32i16:
; RV32:       # %bb.0:
; RV32-NEXT:    li a0, 1
; RV32-NEXT:    vsetvli a1, zero, e16, m8, ta, ma
; RV32-NEXT:    vsub.vx v16, v8, a0
; RV32-NEXT:    vnot.v v8, v8
; RV32-NEXT:    vand.vv v8, v8, v16
; RV32-NEXT:    vsrl.vi v16, v8, 1
; RV32-NEXT:    lui a0, 5
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    vand.vx v16, v16, a0
; RV32-NEXT:    vsub.vv v8, v8, v16
; RV32-NEXT:    lui a0, 3
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    vand.vx v16, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    vadd.vv v8, v16, v8
; RV32-NEXT:    vsrl.vi v16, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v16
; RV32-NEXT:    lui a0, 1
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    li a0, 257
; RV32-NEXT:    vmul.vx v8, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 8
; RV32-NEXT:    ret
;
; RV64-LABEL: cttz_zero_undef_nxv32i16:
; RV64:       # %bb.0:
; RV64-NEXT:    li a0, 1
; RV64-NEXT:    vsetvli a1, zero, e16, m8, ta, ma
; RV64-NEXT:    vsub.vx v16, v8, a0
; RV64-NEXT:    vnot.v v8, v8
; RV64-NEXT:    vand.vv v8, v8, v16
; RV64-NEXT:    vsrl.vi v16, v8, 1
; RV64-NEXT:    lui a0, 5
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    vand.vx v16, v16, a0
; RV64-NEXT:    vsub.vv v8, v8, v16
; RV64-NEXT:    lui a0, 3
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    vand.vx v16, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vadd.vv v8, v16, v8
; RV64-NEXT:    vsrl.vi v16, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v16
; RV64-NEXT:    lui a0, 1
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    li a0, 257
; RV64-NEXT:    vmul.vx v8, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 8
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_zero_undef_nxv32i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 32 x i16> @llvm.cttz.nxv32i16(<vscale x 32 x i16> %va, i1 true)
  ret <vscale x 32 x i16> %a
}

define <vscale x 1 x i32> @cttz_zero_undef_nxv1i32(<vscale x 1 x i32> %va) {
; RV32I-LABEL: cttz_zero_undef_nxv1i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; RV32I-NEXT:    vsub.vx v9, v8, a0
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vand.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v9, v9, a0
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v9, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 24
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cttz_zero_undef_nxv1i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; RV64I-NEXT:    vsub.vx v9, v8, a0
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vand.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 209715
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 61681
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    lui a0, 4112
; RV64I-NEXT:    addiw a0, a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 24
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: cttz_zero_undef_nxv1i32:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-F-NEXT:    vrsub.vi v9, v8, 0
; CHECK-F-NEXT:    vand.vv v8, v8, v9
; CHECK-F-NEXT:    fsrmi a0, 1
; CHECK-F-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-F-NEXT:    vsrl.vi v8, v8, 23
; CHECK-F-NEXT:    li a1, 127
; CHECK-F-NEXT:    vsub.vx v8, v8, a1
; CHECK-F-NEXT:    fsrm a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_zero_undef_nxv1i32:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-D-NEXT:    vrsub.vi v9, v8, 0
; CHECK-D-NEXT:    vand.vv v8, v8, v9
; CHECK-D-NEXT:    vfwcvt.f.xu.v v9, v8
; CHECK-D-NEXT:    li a0, 52
; CHECK-D-NEXT:    vnsrl.wx v8, v9, a0
; CHECK-D-NEXT:    li a0, 1023
; CHECK-D-NEXT:    vsub.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_zero_undef_nxv1i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 1 x i32> @llvm.cttz.nxv1i32(<vscale x 1 x i32> %va, i1 true)
  ret <vscale x 1 x i32> %a
}

define <vscale x 2 x i32> @cttz_zero_undef_nxv2i32(<vscale x 2 x i32> %va) {
; RV32I-LABEL: cttz_zero_undef_nxv2i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; RV32I-NEXT:    vsub.vx v9, v8, a0
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vand.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v9, v9, a0
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v9, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 24
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cttz_zero_undef_nxv2i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; RV64I-NEXT:    vsub.vx v9, v8, a0
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vand.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 209715
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 61681
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    lui a0, 4112
; RV64I-NEXT:    addiw a0, a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 24
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: cttz_zero_undef_nxv2i32:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-F-NEXT:    vrsub.vi v9, v8, 0
; CHECK-F-NEXT:    vand.vv v8, v8, v9
; CHECK-F-NEXT:    fsrmi a0, 1
; CHECK-F-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-F-NEXT:    vsrl.vi v8, v8, 23
; CHECK-F-NEXT:    li a1, 127
; CHECK-F-NEXT:    vsub.vx v8, v8, a1
; CHECK-F-NEXT:    fsrm a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_zero_undef_nxv2i32:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-D-NEXT:    vrsub.vi v9, v8, 0
; CHECK-D-NEXT:    vand.vv v8, v8, v9
; CHECK-D-NEXT:    vfwcvt.f.xu.v v10, v8
; CHECK-D-NEXT:    li a0, 52
; CHECK-D-NEXT:    vnsrl.wx v8, v10, a0
; CHECK-D-NEXT:    li a0, 1023
; CHECK-D-NEXT:    vsub.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_zero_undef_nxv2i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 2 x i32> @llvm.cttz.nxv2i32(<vscale x 2 x i32> %va, i1 true)
  ret <vscale x 2 x i32> %a
}

define <vscale x 4 x i32> @cttz_zero_undef_nxv4i32(<vscale x 4 x i32> %va) {
; RV32I-LABEL: cttz_zero_undef_nxv4i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; RV32I-NEXT:    vsub.vx v10, v8, a0
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vand.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 1
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v10, v10, a0
; RV32I-NEXT:    vsub.vv v8, v8, v10
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v10, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v10, v8
; RV32I-NEXT:    vsrl.vi v10, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v10
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 24
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cttz_zero_undef_nxv4i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; RV64I-NEXT:    vsub.vx v10, v8, a0
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vand.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v10, v10, a0
; RV64I-NEXT:    vsub.vv v8, v8, v10
; RV64I-NEXT:    lui a0, 209715
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v10, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v10, v8
; RV64I-NEXT:    vsrl.vi v10, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v10
; RV64I-NEXT:    lui a0, 61681
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    lui a0, 4112
; RV64I-NEXT:    addiw a0, a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 24
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: cttz_zero_undef_nxv4i32:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-F-NEXT:    vrsub.vi v10, v8, 0
; CHECK-F-NEXT:    vand.vv v8, v8, v10
; CHECK-F-NEXT:    fsrmi a0, 1
; CHECK-F-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-F-NEXT:    vsrl.vi v8, v8, 23
; CHECK-F-NEXT:    li a1, 127
; CHECK-F-NEXT:    vsub.vx v8, v8, a1
; CHECK-F-NEXT:    fsrm a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_zero_undef_nxv4i32:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-D-NEXT:    vrsub.vi v10, v8, 0
; CHECK-D-NEXT:    vand.vv v8, v8, v10
; CHECK-D-NEXT:    vfwcvt.f.xu.v v12, v8
; CHECK-D-NEXT:    li a0, 52
; CHECK-D-NEXT:    vnsrl.wx v8, v12, a0
; CHECK-D-NEXT:    li a0, 1023
; CHECK-D-NEXT:    vsub.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_zero_undef_nxv4i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 4 x i32> @llvm.cttz.nxv4i32(<vscale x 4 x i32> %va, i1 true)
  ret <vscale x 4 x i32> %a
}

define <vscale x 8 x i32> @cttz_zero_undef_nxv8i32(<vscale x 8 x i32> %va) {
; RV32I-LABEL: cttz_zero_undef_nxv8i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; RV32I-NEXT:    vsub.vx v12, v8, a0
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vand.vv v8, v8, v12
; RV32I-NEXT:    vsrl.vi v12, v8, 1
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v12, v12, a0
; RV32I-NEXT:    vsub.vv v8, v8, v12
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v12, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v12, v8
; RV32I-NEXT:    vsrl.vi v12, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v12
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 24
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cttz_zero_undef_nxv8i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; RV64I-NEXT:    vsub.vx v12, v8, a0
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vand.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vi v12, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v12, v12, a0
; RV64I-NEXT:    vsub.vv v8, v8, v12
; RV64I-NEXT:    lui a0, 209715
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v12, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v12, v8
; RV64I-NEXT:    vsrl.vi v12, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v12
; RV64I-NEXT:    lui a0, 61681
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    lui a0, 4112
; RV64I-NEXT:    addiw a0, a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 24
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: cttz_zero_undef_nxv8i32:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-F-NEXT:    vrsub.vi v12, v8, 0
; CHECK-F-NEXT:    vand.vv v8, v8, v12
; CHECK-F-NEXT:    fsrmi a0, 1
; CHECK-F-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-F-NEXT:    vsrl.vi v8, v8, 23
; CHECK-F-NEXT:    li a1, 127
; CHECK-F-NEXT:    vsub.vx v8, v8, a1
; CHECK-F-NEXT:    fsrm a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_zero_undef_nxv8i32:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-D-NEXT:    vrsub.vi v12, v8, 0
; CHECK-D-NEXT:    vand.vv v8, v8, v12
; CHECK-D-NEXT:    vfwcvt.f.xu.v v16, v8
; CHECK-D-NEXT:    li a0, 52
; CHECK-D-NEXT:    vnsrl.wx v8, v16, a0
; CHECK-D-NEXT:    li a0, 1023
; CHECK-D-NEXT:    vsub.vx v8, v8, a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_zero_undef_nxv8i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 8 x i32> @llvm.cttz.nxv8i32(<vscale x 8 x i32> %va, i1 true)
  ret <vscale x 8 x i32> %a
}

define <vscale x 16 x i32> @cttz_zero_undef_nxv16i32(<vscale x 16 x i32> %va) {
; RV32I-LABEL: cttz_zero_undef_nxv16i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    vsetvli a1, zero, e32, m8, ta, ma
; RV32I-NEXT:    vsub.vx v16, v8, a0
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vand.vv v8, v8, v16
; RV32I-NEXT:    vsrl.vi v16, v8, 1
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v16, v16, a0
; RV32I-NEXT:    vsub.vv v8, v8, v16
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v16, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v16, v8
; RV32I-NEXT:    vsrl.vi v16, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v16
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 24
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cttz_zero_undef_nxv16i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    vsetvli a1, zero, e32, m8, ta, ma
; RV64I-NEXT:    vsub.vx v16, v8, a0
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vand.vv v8, v8, v16
; RV64I-NEXT:    vsrl.vi v16, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v16, v16, a0
; RV64I-NEXT:    vsub.vv v8, v8, v16
; RV64I-NEXT:    lui a0, 209715
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v16, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v16, v8
; RV64I-NEXT:    vsrl.vi v16, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v16
; RV64I-NEXT:    lui a0, 61681
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    lui a0, 4112
; RV64I-NEXT:    addiw a0, a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 24
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: cttz_zero_undef_nxv16i32:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-F-NEXT:    vrsub.vi v16, v8, 0
; CHECK-F-NEXT:    vand.vv v8, v8, v16
; CHECK-F-NEXT:    fsrmi a0, 1
; CHECK-F-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-F-NEXT:    vsrl.vi v8, v8, 23
; CHECK-F-NEXT:    li a1, 127
; CHECK-F-NEXT:    vsub.vx v8, v8, a1
; CHECK-F-NEXT:    fsrm a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_zero_undef_nxv16i32:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-D-NEXT:    vrsub.vi v16, v8, 0
; CHECK-D-NEXT:    vand.vv v8, v8, v16
; CHECK-D-NEXT:    fsrmi a0, 1
; CHECK-D-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-D-NEXT:    vsrl.vi v8, v8, 23
; CHECK-D-NEXT:    li a1, 127
; CHECK-D-NEXT:    vsub.vx v8, v8, a1
; CHECK-D-NEXT:    fsrm a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_zero_undef_nxv16i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 16 x i32> @llvm.cttz.nxv16i32(<vscale x 16 x i32> %va, i1 true)
  ret <vscale x 16 x i32> %a
}

define <vscale x 1 x i64> @cttz_zero_undef_nxv1i64(<vscale x 1 x i64> %va) {
; RV32I-LABEL: cttz_zero_undef_nxv1i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    .cfi_def_cfa_offset 32
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    sw a0, 28(sp)
; RV32I-NEXT:    sw a0, 24(sp)
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    sw a0, 20(sp)
; RV32I-NEXT:    sw a0, 16(sp)
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    sw a0, 12(sp)
; RV32I-NEXT:    sw a0, 8(sp)
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    sw a0, 4(sp)
; RV32I-NEXT:    sw a0, 0(sp)
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV32I-NEXT:    vsub.vx v9, v8, a0
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vand.vv v8, v8, v9
; RV32I-NEXT:    addi a0, sp, 24
; RV32I-NEXT:    vlse64.v v9, (a0), zero
; RV32I-NEXT:    addi a0, sp, 16
; RV32I-NEXT:    vlse64.v v10, (a0), zero
; RV32I-NEXT:    vsrl.vi v11, v8, 1
; RV32I-NEXT:    vand.vv v9, v11, v9
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    vand.vv v9, v8, v10
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vv v8, v8, v10
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    addi a0, sp, 8
; RV32I-NEXT:    vlse64.v v9, (a0), zero
; RV32I-NEXT:    mv a0, sp
; RV32I-NEXT:    vlse64.v v10, (a0), zero
; RV32I-NEXT:    vsrl.vi v11, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v11
; RV32I-NEXT:    vand.vv v8, v8, v9
; RV32I-NEXT:    vmul.vv v8, v8, v10
; RV32I-NEXT:    li a0, 56
; RV32I-NEXT:    vsrl.vx v8, v8, a0
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cttz_zero_undef_nxv1i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; RV64I-NEXT:    vsub.vx v9, v8, a0
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vand.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 209715
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 61681
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    lui a0, 4112
; RV64I-NEXT:    addiw a0, a0, 257
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    li a0, 56
; RV64I-NEXT:    vsrl.vx v8, v8, a0
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: cttz_zero_undef_nxv1i64:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-F-NEXT:    vrsub.vi v9, v8, 0
; CHECK-F-NEXT:    vand.vv v8, v8, v9
; CHECK-F-NEXT:    fsrmi a0, 1
; CHECK-F-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-F-NEXT:    vfncvt.f.xu.w v9, v8
; CHECK-F-NEXT:    vsrl.vi v8, v9, 23
; CHECK-F-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; CHECK-F-NEXT:    vzext.vf2 v9, v8
; CHECK-F-NEXT:    li a1, 127
; CHECK-F-NEXT:    vsub.vx v8, v9, a1
; CHECK-F-NEXT:    fsrm a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_zero_undef_nxv1i64:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-D-NEXT:    vrsub.vi v9, v8, 0
; CHECK-D-NEXT:    vand.vv v8, v8, v9
; CHECK-D-NEXT:    fsrmi a0, 1
; CHECK-D-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-D-NEXT:    li a1, 52
; CHECK-D-NEXT:    vsrl.vx v8, v8, a1
; CHECK-D-NEXT:    li a1, 1023
; CHECK-D-NEXT:    vsub.vx v8, v8, a1
; CHECK-D-NEXT:    fsrm a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_zero_undef_nxv1i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 1 x i64> @llvm.cttz.nxv1i64(<vscale x 1 x i64> %va, i1 true)
  ret <vscale x 1 x i64> %a
}

define <vscale x 2 x i64> @cttz_zero_undef_nxv2i64(<vscale x 2 x i64> %va) {
; RV32I-LABEL: cttz_zero_undef_nxv2i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    .cfi_def_cfa_offset 32
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    sw a0, 28(sp)
; RV32I-NEXT:    sw a0, 24(sp)
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    sw a0, 20(sp)
; RV32I-NEXT:    sw a0, 16(sp)
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    sw a0, 12(sp)
; RV32I-NEXT:    sw a0, 8(sp)
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    sw a0, 4(sp)
; RV32I-NEXT:    sw a0, 0(sp)
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; RV32I-NEXT:    vsub.vx v10, v8, a0
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vand.vv v8, v8, v10
; RV32I-NEXT:    addi a0, sp, 24
; RV32I-NEXT:    vlse64.v v10, (a0), zero
; RV32I-NEXT:    addi a0, sp, 16
; RV32I-NEXT:    vlse64.v v12, (a0), zero
; RV32I-NEXT:    vsrl.vi v14, v8, 1
; RV32I-NEXT:    vand.vv v10, v14, v10
; RV32I-NEXT:    vsub.vv v8, v8, v10
; RV32I-NEXT:    vand.vv v10, v8, v12
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vv v8, v8, v12
; RV32I-NEXT:    vadd.vv v8, v10, v8
; RV32I-NEXT:    addi a0, sp, 8
; RV32I-NEXT:    vlse64.v v10, (a0), zero
; RV32I-NEXT:    mv a0, sp
; RV32I-NEXT:    vlse64.v v12, (a0), zero
; RV32I-NEXT:    vsrl.vi v14, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v14
; RV32I-NEXT:    vand.vv v8, v8, v10
; RV32I-NEXT:    vmul.vv v8, v8, v12
; RV32I-NEXT:    li a0, 56
; RV32I-NEXT:    vsrl.vx v8, v8, a0
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cttz_zero_undef_nxv2i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; RV64I-NEXT:    vsub.vx v10, v8, a0
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vand.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vand.vx v10, v10, a0
; RV64I-NEXT:    vsub.vv v8, v8, v10
; RV64I-NEXT:    lui a0, 209715
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vand.vx v10, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v10, v8
; RV64I-NEXT:    vsrl.vi v10, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v10
; RV64I-NEXT:    lui a0, 61681
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    lui a0, 4112
; RV64I-NEXT:    addiw a0, a0, 257
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    li a0, 56
; RV64I-NEXT:    vsrl.vx v8, v8, a0
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: cttz_zero_undef_nxv2i64:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-F-NEXT:    vrsub.vi v10, v8, 0
; CHECK-F-NEXT:    vand.vv v8, v8, v10
; CHECK-F-NEXT:    fsrmi a0, 1
; CHECK-F-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-F-NEXT:    vfncvt.f.xu.w v10, v8
; CHECK-F-NEXT:    vsrl.vi v8, v10, 23
; CHECK-F-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-F-NEXT:    vzext.vf2 v10, v8
; CHECK-F-NEXT:    li a1, 127
; CHECK-F-NEXT:    vsub.vx v8, v10, a1
; CHECK-F-NEXT:    fsrm a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_zero_undef_nxv2i64:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-D-NEXT:    vrsub.vi v10, v8, 0
; CHECK-D-NEXT:    vand.vv v8, v8, v10
; CHECK-D-NEXT:    fsrmi a0, 1
; CHECK-D-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-D-NEXT:    li a1, 52
; CHECK-D-NEXT:    vsrl.vx v8, v8, a1
; CHECK-D-NEXT:    li a1, 1023
; CHECK-D-NEXT:    vsub.vx v8, v8, a1
; CHECK-D-NEXT:    fsrm a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_zero_undef_nxv2i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 2 x i64> @llvm.cttz.nxv2i64(<vscale x 2 x i64> %va, i1 true)
  ret <vscale x 2 x i64> %a
}

define <vscale x 4 x i64> @cttz_zero_undef_nxv4i64(<vscale x 4 x i64> %va) {
; RV32I-LABEL: cttz_zero_undef_nxv4i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    .cfi_def_cfa_offset 32
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    sw a0, 28(sp)
; RV32I-NEXT:    sw a0, 24(sp)
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    sw a0, 20(sp)
; RV32I-NEXT:    sw a0, 16(sp)
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    sw a0, 12(sp)
; RV32I-NEXT:    sw a0, 8(sp)
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    sw a0, 4(sp)
; RV32I-NEXT:    sw a0, 0(sp)
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; RV32I-NEXT:    vsub.vx v12, v8, a0
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vand.vv v8, v8, v12
; RV32I-NEXT:    addi a0, sp, 24
; RV32I-NEXT:    vlse64.v v12, (a0), zero
; RV32I-NEXT:    addi a0, sp, 16
; RV32I-NEXT:    vlse64.v v16, (a0), zero
; RV32I-NEXT:    vsrl.vi v20, v8, 1
; RV32I-NEXT:    vand.vv v12, v20, v12
; RV32I-NEXT:    vsub.vv v8, v8, v12
; RV32I-NEXT:    vand.vv v12, v8, v16
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vv v8, v8, v16
; RV32I-NEXT:    vadd.vv v8, v12, v8
; RV32I-NEXT:    addi a0, sp, 8
; RV32I-NEXT:    vlse64.v v12, (a0), zero
; RV32I-NEXT:    mv a0, sp
; RV32I-NEXT:    vlse64.v v16, (a0), zero
; RV32I-NEXT:    vsrl.vi v20, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v20
; RV32I-NEXT:    vand.vv v8, v8, v12
; RV32I-NEXT:    vmul.vv v8, v8, v16
; RV32I-NEXT:    li a0, 56
; RV32I-NEXT:    vsrl.vx v8, v8, a0
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cttz_zero_undef_nxv4i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; RV64I-NEXT:    vsub.vx v12, v8, a0
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vand.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vi v12, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vand.vx v12, v12, a0
; RV64I-NEXT:    vsub.vv v8, v8, v12
; RV64I-NEXT:    lui a0, 209715
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vand.vx v12, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v12, v8
; RV64I-NEXT:    vsrl.vi v12, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v12
; RV64I-NEXT:    lui a0, 61681
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    lui a0, 4112
; RV64I-NEXT:    addiw a0, a0, 257
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    li a0, 56
; RV64I-NEXT:    vsrl.vx v8, v8, a0
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: cttz_zero_undef_nxv4i64:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-F-NEXT:    vrsub.vi v12, v8, 0
; CHECK-F-NEXT:    vand.vv v8, v8, v12
; CHECK-F-NEXT:    fsrmi a0, 1
; CHECK-F-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-F-NEXT:    vfncvt.f.xu.w v12, v8
; CHECK-F-NEXT:    vsrl.vi v8, v12, 23
; CHECK-F-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; CHECK-F-NEXT:    vzext.vf2 v12, v8
; CHECK-F-NEXT:    li a1, 127
; CHECK-F-NEXT:    vsub.vx v8, v12, a1
; CHECK-F-NEXT:    fsrm a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_zero_undef_nxv4i64:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-D-NEXT:    vrsub.vi v12, v8, 0
; CHECK-D-NEXT:    vand.vv v8, v8, v12
; CHECK-D-NEXT:    fsrmi a0, 1
; CHECK-D-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-D-NEXT:    li a1, 52
; CHECK-D-NEXT:    vsrl.vx v8, v8, a1
; CHECK-D-NEXT:    li a1, 1023
; CHECK-D-NEXT:    vsub.vx v8, v8, a1
; CHECK-D-NEXT:    fsrm a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_zero_undef_nxv4i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 4 x i64> @llvm.cttz.nxv4i64(<vscale x 4 x i64> %va, i1 true)
  ret <vscale x 4 x i64> %a
}

define <vscale x 8 x i64> @cttz_zero_undef_nxv8i64(<vscale x 8 x i64> %va) {
; RV32I-LABEL: cttz_zero_undef_nxv8i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    .cfi_def_cfa_offset 32
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    sw a0, 28(sp)
; RV32I-NEXT:    sw a0, 24(sp)
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    sw a0, 20(sp)
; RV32I-NEXT:    sw a0, 16(sp)
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    sw a0, 12(sp)
; RV32I-NEXT:    sw a0, 8(sp)
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    sw a0, 4(sp)
; RV32I-NEXT:    sw a0, 0(sp)
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV32I-NEXT:    vsub.vx v16, v8, a0
; RV32I-NEXT:    vnot.v v8, v8
; RV32I-NEXT:    vand.vv v8, v8, v16
; RV32I-NEXT:    addi a0, sp, 24
; RV32I-NEXT:    vlse64.v v16, (a0), zero
; RV32I-NEXT:    addi a0, sp, 16
; RV32I-NEXT:    vlse64.v v24, (a0), zero
; RV32I-NEXT:    vsrl.vi v0, v8, 1
; RV32I-NEXT:    vand.vv v16, v0, v16
; RV32I-NEXT:    vsub.vv v8, v8, v16
; RV32I-NEXT:    vand.vv v16, v8, v24
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vv v8, v8, v24
; RV32I-NEXT:    vadd.vv v8, v16, v8
; RV32I-NEXT:    addi a0, sp, 8
; RV32I-NEXT:    vlse64.v v16, (a0), zero
; RV32I-NEXT:    mv a0, sp
; RV32I-NEXT:    vlse64.v v24, (a0), zero
; RV32I-NEXT:    vsrl.vi v0, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v0
; RV32I-NEXT:    vand.vv v8, v8, v16
; RV32I-NEXT:    vmul.vv v8, v8, v24
; RV32I-NEXT:    li a0, 56
; RV32I-NEXT:    vsrl.vx v8, v8, a0
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cttz_zero_undef_nxv8i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; RV64I-NEXT:    vsub.vx v16, v8, a0
; RV64I-NEXT:    vnot.v v8, v8
; RV64I-NEXT:    vand.vv v8, v8, v16
; RV64I-NEXT:    vsrl.vi v16, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vand.vx v16, v16, a0
; RV64I-NEXT:    vsub.vv v8, v8, v16
; RV64I-NEXT:    lui a0, 209715
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vand.vx v16, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v16, v8
; RV64I-NEXT:    vsrl.vi v16, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v16
; RV64I-NEXT:    lui a0, 61681
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    lui a0, 4112
; RV64I-NEXT:    addiw a0, a0, 257
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    li a0, 56
; RV64I-NEXT:    vsrl.vx v8, v8, a0
; RV64I-NEXT:    ret
;
; CHECK-F-LABEL: cttz_zero_undef_nxv8i64:
; CHECK-F:       # %bb.0:
; CHECK-F-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-F-NEXT:    vrsub.vi v16, v8, 0
; CHECK-F-NEXT:    vand.vv v8, v8, v16
; CHECK-F-NEXT:    fsrmi a0, 1
; CHECK-F-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-F-NEXT:    vfncvt.f.xu.w v16, v8
; CHECK-F-NEXT:    vsrl.vi v8, v16, 23
; CHECK-F-NEXT:    vsetvli zero, zero, e64, m8, ta, ma
; CHECK-F-NEXT:    vzext.vf2 v16, v8
; CHECK-F-NEXT:    li a1, 127
; CHECK-F-NEXT:    vsub.vx v8, v16, a1
; CHECK-F-NEXT:    fsrm a0
; CHECK-F-NEXT:    ret
;
; CHECK-D-LABEL: cttz_zero_undef_nxv8i64:
; CHECK-D:       # %bb.0:
; CHECK-D-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-D-NEXT:    vrsub.vi v16, v8, 0
; CHECK-D-NEXT:    vand.vv v8, v8, v16
; CHECK-D-NEXT:    fsrmi a0, 1
; CHECK-D-NEXT:    vfcvt.f.xu.v v8, v8
; CHECK-D-NEXT:    li a1, 52
; CHECK-D-NEXT:    vsrl.vx v8, v8, a1
; CHECK-D-NEXT:    li a1, 1023
; CHECK-D-NEXT:    vsub.vx v8, v8, a1
; CHECK-D-NEXT:    fsrm a0
; CHECK-D-NEXT:    ret
;
; CHECK-ZVBB-LABEL: cttz_zero_undef_nxv8i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-ZVBB-NEXT:    vctz.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 8 x i64> @llvm.cttz.nxv8i64(<vscale x 8 x i64> %va, i1 true)
  ret <vscale x 8 x i64> %a
}
