; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV32
; RUN: llc -mtriple=riscv64 -mattr=+v -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV64
; RUN: llc -mtriple=riscv32 -mattr=+v,+experimental-zvbb -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK-ZVBB
; RUN: llc -mtriple=riscv64 -mattr=+v,+experimental-zvbb -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK-ZVBB

define <vscale x 1 x i8> @ctpop_nxv1i8(<vscale x 1 x i8> %va) {
; CHECK-LABEL: ctpop_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vsrl.vi v9, v8, 1
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vsub.vv v8, v8, v9
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v9, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v9, v8
; CHECK-NEXT:    vsrl.vi v9, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v9
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctpop_nxv1i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-ZVBB-NEXT:    vcpop.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 1 x i8> @llvm.ctpop.nxv1i8(<vscale x 1 x i8> %va)
  ret <vscale x 1 x i8> %a
}
declare <vscale x 1 x i8> @llvm.ctpop.nxv1i8(<vscale x 1 x i8>)

define <vscale x 2 x i8> @ctpop_nxv2i8(<vscale x 2 x i8> %va) {
; CHECK-LABEL: ctpop_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vsrl.vi v9, v8, 1
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vsub.vv v8, v8, v9
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v9, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v9, v8
; CHECK-NEXT:    vsrl.vi v9, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v9
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctpop_nxv2i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; CHECK-ZVBB-NEXT:    vcpop.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 2 x i8> @llvm.ctpop.nxv2i8(<vscale x 2 x i8> %va)
  ret <vscale x 2 x i8> %a
}
declare <vscale x 2 x i8> @llvm.ctpop.nxv2i8(<vscale x 2 x i8>)

define <vscale x 4 x i8> @ctpop_nxv4i8(<vscale x 4 x i8> %va) {
; CHECK-LABEL: ctpop_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vsrl.vi v9, v8, 1
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vsub.vv v8, v8, v9
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v9, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v9, v8
; CHECK-NEXT:    vsrl.vi v9, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v9
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctpop_nxv4i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vcpop.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 4 x i8> @llvm.ctpop.nxv4i8(<vscale x 4 x i8> %va)
  ret <vscale x 4 x i8> %a
}
declare <vscale x 4 x i8> @llvm.ctpop.nxv4i8(<vscale x 4 x i8>)

define <vscale x 8 x i8> @ctpop_nxv8i8(<vscale x 8 x i8> %va) {
; CHECK-LABEL: ctpop_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vsrl.vi v9, v8, 1
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vsub.vv v8, v8, v9
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v9, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v9, v8
; CHECK-NEXT:    vsrl.vi v9, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v9
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctpop_nxv8i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-ZVBB-NEXT:    vcpop.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 8 x i8> @llvm.ctpop.nxv8i8(<vscale x 8 x i8> %va)
  ret <vscale x 8 x i8> %a
}
declare <vscale x 8 x i8> @llvm.ctpop.nxv8i8(<vscale x 8 x i8>)

define <vscale x 16 x i8> @ctpop_nxv16i8(<vscale x 16 x i8> %va) {
; CHECK-LABEL: ctpop_nxv16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vsrl.vi v10, v8, 1
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v10, v10, a0
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v10, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v10, v8
; CHECK-NEXT:    vsrl.vi v10, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v10
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctpop_nxv16i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-ZVBB-NEXT:    vcpop.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 16 x i8> @llvm.ctpop.nxv16i8(<vscale x 16 x i8> %va)
  ret <vscale x 16 x i8> %a
}
declare <vscale x 16 x i8> @llvm.ctpop.nxv16i8(<vscale x 16 x i8>)

define <vscale x 32 x i8> @ctpop_nxv32i8(<vscale x 32 x i8> %va) {
; CHECK-LABEL: ctpop_nxv32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-NEXT:    vsrl.vi v12, v8, 1
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v12, v12, a0
; CHECK-NEXT:    vsub.vv v8, v8, v12
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v12, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v12, v8
; CHECK-NEXT:    vsrl.vi v12, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v12
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctpop_nxv32i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; CHECK-ZVBB-NEXT:    vcpop.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 32 x i8> @llvm.ctpop.nxv32i8(<vscale x 32 x i8> %va)
  ret <vscale x 32 x i8> %a
}
declare <vscale x 32 x i8> @llvm.ctpop.nxv32i8(<vscale x 32 x i8>)

define <vscale x 64 x i8> @ctpop_nxv64i8(<vscale x 64 x i8> %va) {
; CHECK-LABEL: ctpop_nxv64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-NEXT:    vsrl.vi v16, v8, 1
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v16, v16, a0
; CHECK-NEXT:    vsub.vv v8, v8, v16
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v16, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v16, v8
; CHECK-NEXT:    vsrl.vi v16, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v16
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctpop_nxv64i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; CHECK-ZVBB-NEXT:    vcpop.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 64 x i8> @llvm.ctpop.nxv64i8(<vscale x 64 x i8> %va)
  ret <vscale x 64 x i8> %a
}
declare <vscale x 64 x i8> @llvm.ctpop.nxv64i8(<vscale x 64 x i8>)

define <vscale x 1 x i16> @ctpop_nxv1i16(<vscale x 1 x i16> %va) {
; RV32-LABEL: ctpop_nxv1i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; RV32-NEXT:    vsrl.vi v9, v8, 1
; RV32-NEXT:    lui a0, 5
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    vand.vx v9, v9, a0
; RV32-NEXT:    vsub.vv v8, v8, v9
; RV32-NEXT:    lui a0, 3
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    vand.vx v9, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    vadd.vv v8, v9, v8
; RV32-NEXT:    vsrl.vi v9, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v9
; RV32-NEXT:    lui a0, 1
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    li a0, 257
; RV32-NEXT:    vmul.vx v8, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 8
; RV32-NEXT:    ret
;
; RV64-LABEL: ctpop_nxv1i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; RV64-NEXT:    vsrl.vi v9, v8, 1
; RV64-NEXT:    lui a0, 5
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    vand.vx v9, v9, a0
; RV64-NEXT:    vsub.vv v8, v8, v9
; RV64-NEXT:    lui a0, 3
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    vand.vx v9, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vadd.vv v8, v9, v8
; RV64-NEXT:    vsrl.vi v9, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v9
; RV64-NEXT:    lui a0, 1
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    li a0, 257
; RV64-NEXT:    vmul.vx v8, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 8
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctpop_nxv1i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-ZVBB-NEXT:    vcpop.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 1 x i16> @llvm.ctpop.nxv1i16(<vscale x 1 x i16> %va)
  ret <vscale x 1 x i16> %a
}
declare <vscale x 1 x i16> @llvm.ctpop.nxv1i16(<vscale x 1 x i16>)

define <vscale x 2 x i16> @ctpop_nxv2i16(<vscale x 2 x i16> %va) {
; RV32-LABEL: ctpop_nxv2i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; RV32-NEXT:    vsrl.vi v9, v8, 1
; RV32-NEXT:    lui a0, 5
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    vand.vx v9, v9, a0
; RV32-NEXT:    vsub.vv v8, v8, v9
; RV32-NEXT:    lui a0, 3
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    vand.vx v9, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    vadd.vv v8, v9, v8
; RV32-NEXT:    vsrl.vi v9, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v9
; RV32-NEXT:    lui a0, 1
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    li a0, 257
; RV32-NEXT:    vmul.vx v8, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 8
; RV32-NEXT:    ret
;
; RV64-LABEL: ctpop_nxv2i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; RV64-NEXT:    vsrl.vi v9, v8, 1
; RV64-NEXT:    lui a0, 5
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    vand.vx v9, v9, a0
; RV64-NEXT:    vsub.vv v8, v8, v9
; RV64-NEXT:    lui a0, 3
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    vand.vx v9, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vadd.vv v8, v9, v8
; RV64-NEXT:    vsrl.vi v9, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v9
; RV64-NEXT:    lui a0, 1
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    li a0, 257
; RV64-NEXT:    vmul.vx v8, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 8
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctpop_nxv2i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vcpop.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 2 x i16> @llvm.ctpop.nxv2i16(<vscale x 2 x i16> %va)
  ret <vscale x 2 x i16> %a
}
declare <vscale x 2 x i16> @llvm.ctpop.nxv2i16(<vscale x 2 x i16>)

define <vscale x 4 x i16> @ctpop_nxv4i16(<vscale x 4 x i16> %va) {
; RV32-LABEL: ctpop_nxv4i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; RV32-NEXT:    vsrl.vi v9, v8, 1
; RV32-NEXT:    lui a0, 5
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    vand.vx v9, v9, a0
; RV32-NEXT:    vsub.vv v8, v8, v9
; RV32-NEXT:    lui a0, 3
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    vand.vx v9, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    vadd.vv v8, v9, v8
; RV32-NEXT:    vsrl.vi v9, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v9
; RV32-NEXT:    lui a0, 1
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    li a0, 257
; RV32-NEXT:    vmul.vx v8, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 8
; RV32-NEXT:    ret
;
; RV64-LABEL: ctpop_nxv4i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; RV64-NEXT:    vsrl.vi v9, v8, 1
; RV64-NEXT:    lui a0, 5
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    vand.vx v9, v9, a0
; RV64-NEXT:    vsub.vv v8, v8, v9
; RV64-NEXT:    lui a0, 3
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    vand.vx v9, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vadd.vv v8, v9, v8
; RV64-NEXT:    vsrl.vi v9, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v9
; RV64-NEXT:    lui a0, 1
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    li a0, 257
; RV64-NEXT:    vmul.vx v8, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 8
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctpop_nxv4i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vcpop.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 4 x i16> @llvm.ctpop.nxv4i16(<vscale x 4 x i16> %va)
  ret <vscale x 4 x i16> %a
}
declare <vscale x 4 x i16> @llvm.ctpop.nxv4i16(<vscale x 4 x i16>)

define <vscale x 8 x i16> @ctpop_nxv8i16(<vscale x 8 x i16> %va) {
; RV32-LABEL: ctpop_nxv8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; RV32-NEXT:    vsrl.vi v10, v8, 1
; RV32-NEXT:    lui a0, 5
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    vand.vx v10, v10, a0
; RV32-NEXT:    vsub.vv v8, v8, v10
; RV32-NEXT:    lui a0, 3
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    vand.vx v10, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    vadd.vv v8, v10, v8
; RV32-NEXT:    vsrl.vi v10, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v10
; RV32-NEXT:    lui a0, 1
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    li a0, 257
; RV32-NEXT:    vmul.vx v8, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 8
; RV32-NEXT:    ret
;
; RV64-LABEL: ctpop_nxv8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; RV64-NEXT:    vsrl.vi v10, v8, 1
; RV64-NEXT:    lui a0, 5
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    vand.vx v10, v10, a0
; RV64-NEXT:    vsub.vv v8, v8, v10
; RV64-NEXT:    lui a0, 3
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    vand.vx v10, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vadd.vv v8, v10, v8
; RV64-NEXT:    vsrl.vi v10, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v10
; RV64-NEXT:    lui a0, 1
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    li a0, 257
; RV64-NEXT:    vmul.vx v8, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 8
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctpop_nxv8i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-ZVBB-NEXT:    vcpop.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 8 x i16> @llvm.ctpop.nxv8i16(<vscale x 8 x i16> %va)
  ret <vscale x 8 x i16> %a
}
declare <vscale x 8 x i16> @llvm.ctpop.nxv8i16(<vscale x 8 x i16>)

define <vscale x 16 x i16> @ctpop_nxv16i16(<vscale x 16 x i16> %va) {
; RV32-LABEL: ctpop_nxv16i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; RV32-NEXT:    vsrl.vi v12, v8, 1
; RV32-NEXT:    lui a0, 5
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    vand.vx v12, v12, a0
; RV32-NEXT:    vsub.vv v8, v8, v12
; RV32-NEXT:    lui a0, 3
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    vand.vx v12, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    vadd.vv v8, v12, v8
; RV32-NEXT:    vsrl.vi v12, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v12
; RV32-NEXT:    lui a0, 1
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    li a0, 257
; RV32-NEXT:    vmul.vx v8, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 8
; RV32-NEXT:    ret
;
; RV64-LABEL: ctpop_nxv16i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; RV64-NEXT:    vsrl.vi v12, v8, 1
; RV64-NEXT:    lui a0, 5
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    vand.vx v12, v12, a0
; RV64-NEXT:    vsub.vv v8, v8, v12
; RV64-NEXT:    lui a0, 3
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    vand.vx v12, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vadd.vv v8, v12, v8
; RV64-NEXT:    vsrl.vi v12, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v12
; RV64-NEXT:    lui a0, 1
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    li a0, 257
; RV64-NEXT:    vmul.vx v8, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 8
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctpop_nxv16i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-ZVBB-NEXT:    vcpop.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 16 x i16> @llvm.ctpop.nxv16i16(<vscale x 16 x i16> %va)
  ret <vscale x 16 x i16> %a
}
declare <vscale x 16 x i16> @llvm.ctpop.nxv16i16(<vscale x 16 x i16>)

define <vscale x 32 x i16> @ctpop_nxv32i16(<vscale x 32 x i16> %va) {
; RV32-LABEL: ctpop_nxv32i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; RV32-NEXT:    vsrl.vi v16, v8, 1
; RV32-NEXT:    lui a0, 5
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    vand.vx v16, v16, a0
; RV32-NEXT:    vsub.vv v8, v8, v16
; RV32-NEXT:    lui a0, 3
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    vand.vx v16, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    vadd.vv v8, v16, v8
; RV32-NEXT:    vsrl.vi v16, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v16
; RV32-NEXT:    lui a0, 1
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    li a0, 257
; RV32-NEXT:    vmul.vx v8, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 8
; RV32-NEXT:    ret
;
; RV64-LABEL: ctpop_nxv32i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; RV64-NEXT:    vsrl.vi v16, v8, 1
; RV64-NEXT:    lui a0, 5
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    vand.vx v16, v16, a0
; RV64-NEXT:    vsub.vv v8, v8, v16
; RV64-NEXT:    lui a0, 3
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    vand.vx v16, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vadd.vv v8, v16, v8
; RV64-NEXT:    vsrl.vi v16, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v16
; RV64-NEXT:    lui a0, 1
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    li a0, 257
; RV64-NEXT:    vmul.vx v8, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 8
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctpop_nxv32i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-ZVBB-NEXT:    vcpop.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 32 x i16> @llvm.ctpop.nxv32i16(<vscale x 32 x i16> %va)
  ret <vscale x 32 x i16> %a
}
declare <vscale x 32 x i16> @llvm.ctpop.nxv32i16(<vscale x 32 x i16>)

define <vscale x 1 x i32> @ctpop_nxv1i32(<vscale x 1 x i32> %va) {
; RV32-LABEL: ctpop_nxv1i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; RV32-NEXT:    vsrl.vi v9, v8, 1
; RV32-NEXT:    lui a0, 349525
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    vand.vx v9, v9, a0
; RV32-NEXT:    vsub.vv v8, v8, v9
; RV32-NEXT:    lui a0, 209715
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    vand.vx v9, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    vadd.vv v8, v9, v8
; RV32-NEXT:    vsrl.vi v9, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v9
; RV32-NEXT:    lui a0, 61681
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    lui a0, 4112
; RV32-NEXT:    addi a0, a0, 257
; RV32-NEXT:    vmul.vx v8, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 24
; RV32-NEXT:    ret
;
; RV64-LABEL: ctpop_nxv1i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; RV64-NEXT:    vsrl.vi v9, v8, 1
; RV64-NEXT:    lui a0, 349525
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    vand.vx v9, v9, a0
; RV64-NEXT:    vsub.vv v8, v8, v9
; RV64-NEXT:    lui a0, 209715
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    vand.vx v9, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vadd.vv v8, v9, v8
; RV64-NEXT:    vsrl.vi v9, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v9
; RV64-NEXT:    lui a0, 61681
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    lui a0, 4112
; RV64-NEXT:    addiw a0, a0, 257
; RV64-NEXT:    vmul.vx v8, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 24
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctpop_nxv1i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vcpop.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 1 x i32> @llvm.ctpop.nxv1i32(<vscale x 1 x i32> %va)
  ret <vscale x 1 x i32> %a
}
declare <vscale x 1 x i32> @llvm.ctpop.nxv1i32(<vscale x 1 x i32>)

define <vscale x 2 x i32> @ctpop_nxv2i32(<vscale x 2 x i32> %va) {
; RV32-LABEL: ctpop_nxv2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; RV32-NEXT:    vsrl.vi v9, v8, 1
; RV32-NEXT:    lui a0, 349525
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    vand.vx v9, v9, a0
; RV32-NEXT:    vsub.vv v8, v8, v9
; RV32-NEXT:    lui a0, 209715
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    vand.vx v9, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    vadd.vv v8, v9, v8
; RV32-NEXT:    vsrl.vi v9, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v9
; RV32-NEXT:    lui a0, 61681
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    lui a0, 4112
; RV32-NEXT:    addi a0, a0, 257
; RV32-NEXT:    vmul.vx v8, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 24
; RV32-NEXT:    ret
;
; RV64-LABEL: ctpop_nxv2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; RV64-NEXT:    vsrl.vi v9, v8, 1
; RV64-NEXT:    lui a0, 349525
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    vand.vx v9, v9, a0
; RV64-NEXT:    vsub.vv v8, v8, v9
; RV64-NEXT:    lui a0, 209715
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    vand.vx v9, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vadd.vv v8, v9, v8
; RV64-NEXT:    vsrl.vi v9, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v9
; RV64-NEXT:    lui a0, 61681
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    lui a0, 4112
; RV64-NEXT:    addiw a0, a0, 257
; RV64-NEXT:    vmul.vx v8, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 24
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctpop_nxv2i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vcpop.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 2 x i32> @llvm.ctpop.nxv2i32(<vscale x 2 x i32> %va)
  ret <vscale x 2 x i32> %a
}
declare <vscale x 2 x i32> @llvm.ctpop.nxv2i32(<vscale x 2 x i32>)

define <vscale x 4 x i32> @ctpop_nxv4i32(<vscale x 4 x i32> %va) {
; RV32-LABEL: ctpop_nxv4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; RV32-NEXT:    vsrl.vi v10, v8, 1
; RV32-NEXT:    lui a0, 349525
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    vand.vx v10, v10, a0
; RV32-NEXT:    vsub.vv v8, v8, v10
; RV32-NEXT:    lui a0, 209715
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    vand.vx v10, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    vadd.vv v8, v10, v8
; RV32-NEXT:    vsrl.vi v10, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v10
; RV32-NEXT:    lui a0, 61681
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    lui a0, 4112
; RV32-NEXT:    addi a0, a0, 257
; RV32-NEXT:    vmul.vx v8, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 24
; RV32-NEXT:    ret
;
; RV64-LABEL: ctpop_nxv4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; RV64-NEXT:    vsrl.vi v10, v8, 1
; RV64-NEXT:    lui a0, 349525
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    vand.vx v10, v10, a0
; RV64-NEXT:    vsub.vv v8, v8, v10
; RV64-NEXT:    lui a0, 209715
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    vand.vx v10, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vadd.vv v8, v10, v8
; RV64-NEXT:    vsrl.vi v10, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v10
; RV64-NEXT:    lui a0, 61681
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    lui a0, 4112
; RV64-NEXT:    addiw a0, a0, 257
; RV64-NEXT:    vmul.vx v8, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 24
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctpop_nxv4i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-ZVBB-NEXT:    vcpop.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 4 x i32> @llvm.ctpop.nxv4i32(<vscale x 4 x i32> %va)
  ret <vscale x 4 x i32> %a
}
declare <vscale x 4 x i32> @llvm.ctpop.nxv4i32(<vscale x 4 x i32>)

define <vscale x 8 x i32> @ctpop_nxv8i32(<vscale x 8 x i32> %va) {
; RV32-LABEL: ctpop_nxv8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; RV32-NEXT:    vsrl.vi v12, v8, 1
; RV32-NEXT:    lui a0, 349525
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    vand.vx v12, v12, a0
; RV32-NEXT:    vsub.vv v8, v8, v12
; RV32-NEXT:    lui a0, 209715
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    vand.vx v12, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    vadd.vv v8, v12, v8
; RV32-NEXT:    vsrl.vi v12, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v12
; RV32-NEXT:    lui a0, 61681
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    lui a0, 4112
; RV32-NEXT:    addi a0, a0, 257
; RV32-NEXT:    vmul.vx v8, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 24
; RV32-NEXT:    ret
;
; RV64-LABEL: ctpop_nxv8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; RV64-NEXT:    vsrl.vi v12, v8, 1
; RV64-NEXT:    lui a0, 349525
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    vand.vx v12, v12, a0
; RV64-NEXT:    vsub.vv v8, v8, v12
; RV64-NEXT:    lui a0, 209715
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    vand.vx v12, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vadd.vv v8, v12, v8
; RV64-NEXT:    vsrl.vi v12, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v12
; RV64-NEXT:    lui a0, 61681
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    lui a0, 4112
; RV64-NEXT:    addiw a0, a0, 257
; RV64-NEXT:    vmul.vx v8, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 24
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctpop_nxv8i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-ZVBB-NEXT:    vcpop.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 8 x i32> @llvm.ctpop.nxv8i32(<vscale x 8 x i32> %va)
  ret <vscale x 8 x i32> %a
}
declare <vscale x 8 x i32> @llvm.ctpop.nxv8i32(<vscale x 8 x i32>)

define <vscale x 16 x i32> @ctpop_nxv16i32(<vscale x 16 x i32> %va) {
; RV32-LABEL: ctpop_nxv16i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; RV32-NEXT:    vsrl.vi v16, v8, 1
; RV32-NEXT:    lui a0, 349525
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    vand.vx v16, v16, a0
; RV32-NEXT:    vsub.vv v8, v8, v16
; RV32-NEXT:    lui a0, 209715
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    vand.vx v16, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    vadd.vv v8, v16, v8
; RV32-NEXT:    vsrl.vi v16, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v16
; RV32-NEXT:    lui a0, 61681
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    lui a0, 4112
; RV32-NEXT:    addi a0, a0, 257
; RV32-NEXT:    vmul.vx v8, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 24
; RV32-NEXT:    ret
;
; RV64-LABEL: ctpop_nxv16i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; RV64-NEXT:    vsrl.vi v16, v8, 1
; RV64-NEXT:    lui a0, 349525
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    vand.vx v16, v16, a0
; RV64-NEXT:    vsub.vv v8, v8, v16
; RV64-NEXT:    lui a0, 209715
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    vand.vx v16, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vadd.vv v8, v16, v8
; RV64-NEXT:    vsrl.vi v16, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v16
; RV64-NEXT:    lui a0, 61681
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    lui a0, 4112
; RV64-NEXT:    addiw a0, a0, 257
; RV64-NEXT:    vmul.vx v8, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 24
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctpop_nxv16i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-ZVBB-NEXT:    vcpop.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 16 x i32> @llvm.ctpop.nxv16i32(<vscale x 16 x i32> %va)
  ret <vscale x 16 x i32> %a
}
declare <vscale x 16 x i32> @llvm.ctpop.nxv16i32(<vscale x 16 x i32>)

define <vscale x 1 x i64> @ctpop_nxv1i64(<vscale x 1 x i64> %va) {
; RV32-LABEL: ctpop_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -32
; RV32-NEXT:    .cfi_def_cfa_offset 32
; RV32-NEXT:    lui a0, 349525
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    sw a0, 28(sp)
; RV32-NEXT:    sw a0, 24(sp)
; RV32-NEXT:    lui a0, 209715
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    sw a0, 20(sp)
; RV32-NEXT:    sw a0, 16(sp)
; RV32-NEXT:    lui a0, 61681
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    lui a0, 4112
; RV32-NEXT:    addi a0, a0, 257
; RV32-NEXT:    sw a0, 4(sp)
; RV32-NEXT:    sw a0, 0(sp)
; RV32-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV32-NEXT:    addi a0, sp, 24
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    addi a0, sp, 16
; RV32-NEXT:    vlse64.v v10, (a0), zero
; RV32-NEXT:    vsrl.vi v11, v8, 1
; RV32-NEXT:    vand.vv v9, v11, v9
; RV32-NEXT:    vsub.vv v8, v8, v9
; RV32-NEXT:    vand.vv v9, v8, v10
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vv v8, v8, v10
; RV32-NEXT:    vadd.vv v8, v9, v8
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    mv a0, sp
; RV32-NEXT:    vlse64.v v10, (a0), zero
; RV32-NEXT:    vsrl.vi v11, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v11
; RV32-NEXT:    vand.vv v8, v8, v9
; RV32-NEXT:    vmul.vv v8, v8, v10
; RV32-NEXT:    li a0, 56
; RV32-NEXT:    vsrl.vx v8, v8, a0
; RV32-NEXT:    addi sp, sp, 32
; RV32-NEXT:    ret
;
; RV64-LABEL: ctpop_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; RV64-NEXT:    vsrl.vi v9, v8, 1
; RV64-NEXT:    lui a0, 349525
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v9, v9, a0
; RV64-NEXT:    vsub.vv v8, v8, v9
; RV64-NEXT:    lui a0, 209715
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v9, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vadd.vv v8, v9, v8
; RV64-NEXT:    vsrl.vi v9, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v9
; RV64-NEXT:    lui a0, 61681
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    lui a0, 4112
; RV64-NEXT:    addiw a0, a0, 257
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vmul.vx v8, v8, a0
; RV64-NEXT:    li a0, 56
; RV64-NEXT:    vsrl.vx v8, v8, a0
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctpop_nxv1i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-ZVBB-NEXT:    vcpop.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 1 x i64> @llvm.ctpop.nxv1i64(<vscale x 1 x i64> %va)
  ret <vscale x 1 x i64> %a
}
declare <vscale x 1 x i64> @llvm.ctpop.nxv1i64(<vscale x 1 x i64>)

define <vscale x 2 x i64> @ctpop_nxv2i64(<vscale x 2 x i64> %va) {
; RV32-LABEL: ctpop_nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -32
; RV32-NEXT:    .cfi_def_cfa_offset 32
; RV32-NEXT:    lui a0, 349525
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    sw a0, 28(sp)
; RV32-NEXT:    sw a0, 24(sp)
; RV32-NEXT:    lui a0, 209715
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    sw a0, 20(sp)
; RV32-NEXT:    sw a0, 16(sp)
; RV32-NEXT:    lui a0, 61681
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    lui a0, 4112
; RV32-NEXT:    addi a0, a0, 257
; RV32-NEXT:    sw a0, 4(sp)
; RV32-NEXT:    sw a0, 0(sp)
; RV32-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV32-NEXT:    addi a0, sp, 24
; RV32-NEXT:    vlse64.v v10, (a0), zero
; RV32-NEXT:    addi a0, sp, 16
; RV32-NEXT:    vlse64.v v12, (a0), zero
; RV32-NEXT:    vsrl.vi v14, v8, 1
; RV32-NEXT:    vand.vv v10, v14, v10
; RV32-NEXT:    vsub.vv v8, v8, v10
; RV32-NEXT:    vand.vv v10, v8, v12
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vv v8, v8, v12
; RV32-NEXT:    vadd.vv v8, v10, v8
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v10, (a0), zero
; RV32-NEXT:    mv a0, sp
; RV32-NEXT:    vlse64.v v12, (a0), zero
; RV32-NEXT:    vsrl.vi v14, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v14
; RV32-NEXT:    vand.vv v8, v8, v10
; RV32-NEXT:    vmul.vv v8, v8, v12
; RV32-NEXT:    li a0, 56
; RV32-NEXT:    vsrl.vx v8, v8, a0
; RV32-NEXT:    addi sp, sp, 32
; RV32-NEXT:    ret
;
; RV64-LABEL: ctpop_nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; RV64-NEXT:    vsrl.vi v10, v8, 1
; RV64-NEXT:    lui a0, 349525
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v10, v10, a0
; RV64-NEXT:    vsub.vv v8, v8, v10
; RV64-NEXT:    lui a0, 209715
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v10, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vadd.vv v8, v10, v8
; RV64-NEXT:    vsrl.vi v10, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v10
; RV64-NEXT:    lui a0, 61681
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    lui a0, 4112
; RV64-NEXT:    addiw a0, a0, 257
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vmul.vx v8, v8, a0
; RV64-NEXT:    li a0, 56
; RV64-NEXT:    vsrl.vx v8, v8, a0
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctpop_nxv2i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-ZVBB-NEXT:    vcpop.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 2 x i64> @llvm.ctpop.nxv2i64(<vscale x 2 x i64> %va)
  ret <vscale x 2 x i64> %a
}
declare <vscale x 2 x i64> @llvm.ctpop.nxv2i64(<vscale x 2 x i64>)

define <vscale x 4 x i64> @ctpop_nxv4i64(<vscale x 4 x i64> %va) {
; RV32-LABEL: ctpop_nxv4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -32
; RV32-NEXT:    .cfi_def_cfa_offset 32
; RV32-NEXT:    lui a0, 349525
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    sw a0, 28(sp)
; RV32-NEXT:    sw a0, 24(sp)
; RV32-NEXT:    lui a0, 209715
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    sw a0, 20(sp)
; RV32-NEXT:    sw a0, 16(sp)
; RV32-NEXT:    lui a0, 61681
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    lui a0, 4112
; RV32-NEXT:    addi a0, a0, 257
; RV32-NEXT:    sw a0, 4(sp)
; RV32-NEXT:    sw a0, 0(sp)
; RV32-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV32-NEXT:    addi a0, sp, 24
; RV32-NEXT:    vlse64.v v12, (a0), zero
; RV32-NEXT:    addi a0, sp, 16
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vsrl.vi v20, v8, 1
; RV32-NEXT:    vand.vv v12, v20, v12
; RV32-NEXT:    vsub.vv v8, v8, v12
; RV32-NEXT:    vand.vv v12, v8, v16
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vv v8, v8, v16
; RV32-NEXT:    vadd.vv v8, v12, v8
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v12, (a0), zero
; RV32-NEXT:    mv a0, sp
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vsrl.vi v20, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v20
; RV32-NEXT:    vand.vv v8, v8, v12
; RV32-NEXT:    vmul.vv v8, v8, v16
; RV32-NEXT:    li a0, 56
; RV32-NEXT:    vsrl.vx v8, v8, a0
; RV32-NEXT:    addi sp, sp, 32
; RV32-NEXT:    ret
;
; RV64-LABEL: ctpop_nxv4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; RV64-NEXT:    vsrl.vi v12, v8, 1
; RV64-NEXT:    lui a0, 349525
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v12, v12, a0
; RV64-NEXT:    vsub.vv v8, v8, v12
; RV64-NEXT:    lui a0, 209715
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v12, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vadd.vv v8, v12, v8
; RV64-NEXT:    vsrl.vi v12, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v12
; RV64-NEXT:    lui a0, 61681
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    lui a0, 4112
; RV64-NEXT:    addiw a0, a0, 257
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vmul.vx v8, v8, a0
; RV64-NEXT:    li a0, 56
; RV64-NEXT:    vsrl.vx v8, v8, a0
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctpop_nxv4i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-ZVBB-NEXT:    vcpop.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 4 x i64> @llvm.ctpop.nxv4i64(<vscale x 4 x i64> %va)
  ret <vscale x 4 x i64> %a
}
declare <vscale x 4 x i64> @llvm.ctpop.nxv4i64(<vscale x 4 x i64>)

define <vscale x 8 x i64> @ctpop_nxv8i64(<vscale x 8 x i64> %va) {
; RV32-LABEL: ctpop_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -32
; RV32-NEXT:    .cfi_def_cfa_offset 32
; RV32-NEXT:    lui a0, 349525
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    sw a0, 28(sp)
; RV32-NEXT:    sw a0, 24(sp)
; RV32-NEXT:    lui a0, 209715
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    sw a0, 20(sp)
; RV32-NEXT:    sw a0, 16(sp)
; RV32-NEXT:    lui a0, 61681
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    lui a0, 4112
; RV32-NEXT:    addi a0, a0, 257
; RV32-NEXT:    sw a0, 4(sp)
; RV32-NEXT:    sw a0, 0(sp)
; RV32-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; RV32-NEXT:    addi a0, sp, 24
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    addi a0, sp, 16
; RV32-NEXT:    vlse64.v v24, (a0), zero
; RV32-NEXT:    vsrl.vi v0, v8, 1
; RV32-NEXT:    vand.vv v16, v0, v16
; RV32-NEXT:    vsub.vv v8, v8, v16
; RV32-NEXT:    vand.vv v16, v8, v24
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vv v8, v8, v24
; RV32-NEXT:    vadd.vv v8, v16, v8
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    mv a0, sp
; RV32-NEXT:    vlse64.v v24, (a0), zero
; RV32-NEXT:    vsrl.vi v0, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v0
; RV32-NEXT:    vand.vv v8, v8, v16
; RV32-NEXT:    vmul.vv v8, v8, v24
; RV32-NEXT:    li a0, 56
; RV32-NEXT:    vsrl.vx v8, v8, a0
; RV32-NEXT:    addi sp, sp, 32
; RV32-NEXT:    ret
;
; RV64-LABEL: ctpop_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; RV64-NEXT:    vsrl.vi v16, v8, 1
; RV64-NEXT:    lui a0, 349525
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v16, v16, a0
; RV64-NEXT:    vsub.vv v8, v8, v16
; RV64-NEXT:    lui a0, 209715
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v16, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vadd.vv v8, v16, v8
; RV64-NEXT:    vsrl.vi v16, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v16
; RV64-NEXT:    lui a0, 61681
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    lui a0, 4112
; RV64-NEXT:    addiw a0, a0, 257
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vmul.vx v8, v8, a0
; RV64-NEXT:    li a0, 56
; RV64-NEXT:    vsrl.vx v8, v8, a0
; RV64-NEXT:    ret
;
; CHECK-ZVBB-LABEL: ctpop_nxv8i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-ZVBB-NEXT:    vcpop.v v8, v8
; CHECK-ZVBB-NEXT:    ret
  %a = call <vscale x 8 x i64> @llvm.ctpop.nxv8i64(<vscale x 8 x i64> %va)
  ret <vscale x 8 x i64> %a
}
declare <vscale x 8 x i64> @llvm.ctpop.nxv8i64(<vscale x 8 x i64>)
