/*
Copyright 2024 Rancher Labs, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by main. DO NOT EDIT.

// +k8s:deepcopy-gen=package
// +groupName=management.cattle.io
package v3

import (
	management "github.com/rancher/rancher/pkg/apis/management.cattle.io"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/apimachinery/pkg/runtime/schema"
)

var (
	APIServiceResourceName                                = "apiservices"
	ActiveDirectoryProviderResourceName                   = "activedirectoryproviders"
	AuthConfigResourceName                                = "authconfigs"
	AuthProviderResourceName                              = "authproviders"
	AuthTokenResourceName                                 = "authtokens"
	AzureADProviderResourceName                           = "azureadproviders"
	CatalogResourceName                                   = "catalogs"
	CatalogTemplateResourceName                           = "catalogtemplates"
	CatalogTemplateVersionResourceName                    = "catalogtemplateversions"
	CloudCredentialResourceName                           = "cloudcredentials"
	ClusterResourceName                                   = "clusters"
	ClusterCatalogResourceName                            = "clustercatalogs"
	ClusterLoggingResourceName                            = "clusterloggings"
	ClusterRegistrationTokenResourceName                  = "clusterregistrationtokens"
	ClusterRoleTemplateBindingResourceName                = "clusterroletemplatebindings"
	ClusterTemplateResourceName                           = "clustertemplates"
	ClusterTemplateRevisionResourceName                   = "clustertemplaterevisions"
	ComposeConfigResourceName                             = "composeconfigs"
	DynamicSchemaResourceName                             = "dynamicschemas"
	EtcdBackupResourceName                                = "etcdbackups"
	FeatureResourceName                                   = "features"
	FleetWorkspaceResourceName                            = "fleetworkspaces"
	FreeIpaProviderResourceName                           = "freeipaproviders"
	GithubProviderResourceName                            = "githubproviders"
	GlobalDnsResourceName                                 = "globaldnses"
	GlobalDnsProviderResourceName                         = "globaldnsproviders"
	GlobalRoleResourceName                                = "globalroles"
	GlobalRoleBindingResourceName                         = "globalrolebindings"
	GoogleOAuthProviderResourceName                       = "googleoauthproviders"
	GroupResourceName                                     = "groups"
	GroupMemberResourceName                               = "groupmembers"
	KontainerDriverResourceName                           = "kontainerdrivers"
	LocalProviderResourceName                             = "localproviders"
	ManagedChartResourceName                              = "managedcharts"
	MultiClusterAppResourceName                           = "multiclusterapps"
	MultiClusterAppRevisionResourceName                   = "multiclusterapprevisions"
	NodeResourceName                                      = "nodes"
	NodeDriverResourceName                                = "nodedrivers"
	NodePoolResourceName                                  = "nodepools"
	NodeTemplateResourceName                              = "nodetemplates"
	OIDCProviderResourceName                              = "oidcproviders"
	OpenLdapProviderResourceName                          = "openldapproviders"
	PodSecurityAdmissionConfigurationTemplateResourceName = "podsecurityadmissionconfigurationtemplates"
	PodSecurityPolicyTemplateResourceName                 = "podsecuritypolicytemplates"
	PodSecurityPolicyTemplateProjectBindingResourceName   = "podsecuritypolicytemplateprojectbindings"
	PreferenceResourceName                                = "preferences"
	PrincipalResourceName                                 = "principals"
	ProjectResourceName                                   = "projects"
	ProjectCatalogResourceName                            = "projectcatalogs"
	ProjectLoggingResourceName                            = "projectloggings"
	ProjectNetworkPolicyResourceName                      = "projectnetworkpolicies"
	ProjectRoleTemplateBindingResourceName                = "projectroletemplatebindings"
	RancherUserNotificationResourceName                   = "rancherusernotifications"
	RkeAddonResourceName                                  = "rkeaddons"
	RkeK8sServiceOptionResourceName                       = "rkek8sserviceoptions"
	RkeK8sSystemImageResourceName                         = "rkek8ssystemimages"
	RoleTemplateResourceName                              = "roletemplates"
	SamlProviderResourceName                              = "samlproviders"
	SamlTokenResourceName                                 = "samltokens"
	SettingResourceName                                   = "settings"
	TemplateResourceName                                  = "templates"
	TemplateContentResourceName                           = "templatecontents"
	TemplateVersionResourceName                           = "templateversions"
	TokenResourceName                                     = "tokens"
	UserResourceName                                      = "users"
	UserAttributeResourceName                             = "userattributes"
)

// SchemeGroupVersion is group version used to register these objects
var SchemeGroupVersion = schema.GroupVersion{Group: management.GroupName, Version: "v3"}

// Kind takes an unqualified kind and returns back a Group qualified GroupKind
func Kind(kind string) schema.GroupKind {
	return SchemeGroupVersion.WithKind(kind).GroupKind()
}

// Resource takes an unqualified resource and returns a Group qualified GroupResource
func Resource(resource string) schema.GroupResource {
	return SchemeGroupVersion.WithResource(resource).GroupResource()
}

var (
	SchemeBuilder = runtime.NewSchemeBuilder(addKnownTypes)
	AddToScheme   = SchemeBuilder.AddToScheme
)

// Adds the list of known types to Scheme.
func addKnownTypes(scheme *runtime.Scheme) error {
	scheme.AddKnownTypes(SchemeGroupVersion,
		&APIService{},
		&APIServiceList{},
		&ActiveDirectoryProvider{},
		&ActiveDirectoryProviderList{},
		&AuthConfig{},
		&AuthConfigList{},
		&AuthProvider{},
		&AuthProviderList{},
		&AuthToken{},
		&AuthTokenList{},
		&AzureADProvider{},
		&AzureADProviderList{},
		&Catalog{},
		&CatalogList{},
		&CatalogTemplate{},
		&CatalogTemplateList{},
		&CatalogTemplateVersion{},
		&CatalogTemplateVersionList{},
		&CloudCredential{},
		&CloudCredentialList{},
		&Cluster{},
		&ClusterList{},
		&ClusterCatalog{},
		&ClusterCatalogList{},
		&ClusterLogging{},
		&ClusterLoggingList{},
		&ClusterRegistrationToken{},
		&ClusterRegistrationTokenList{},
		&ClusterRoleTemplateBinding{},
		&ClusterRoleTemplateBindingList{},
		&ClusterTemplate{},
		&ClusterTemplateList{},
		&ClusterTemplateRevision{},
		&ClusterTemplateRevisionList{},
		&ComposeConfig{},
		&ComposeConfigList{},
		&DynamicSchema{},
		&DynamicSchemaList{},
		&EtcdBackup{},
		&EtcdBackupList{},
		&Feature{},
		&FeatureList{},
		&FleetWorkspace{},
		&FleetWorkspaceList{},
		&FreeIpaProvider{},
		&FreeIpaProviderList{},
		&GithubProvider{},
		&GithubProviderList{},
		&GlobalDns{},
		&GlobalDnsList{},
		&GlobalDnsProvider{},
		&GlobalDnsProviderList{},
		&GlobalRole{},
		&GlobalRoleList{},
		&GlobalRoleBinding{},
		&GlobalRoleBindingList{},
		&GoogleOAuthProvider{},
		&GoogleOAuthProviderList{},
		&Group{},
		&GroupList{},
		&GroupMember{},
		&GroupMemberList{},
		&KontainerDriver{},
		&KontainerDriverList{},
		&LocalProvider{},
		&LocalProviderList{},
		&ManagedChart{},
		&ManagedChartList{},
		&MultiClusterApp{},
		&MultiClusterAppList{},
		&MultiClusterAppRevision{},
		&MultiClusterAppRevisionList{},
		&Node{},
		&NodeList{},
		&NodeDriver{},
		&NodeDriverList{},
		&NodePool{},
		&NodePoolList{},
		&NodeTemplate{},
		&NodeTemplateList{},
		&OIDCProvider{},
		&OIDCProviderList{},
		&OpenLdapProvider{},
		&OpenLdapProviderList{},
		&PodSecurityAdmissionConfigurationTemplate{},
		&PodSecurityAdmissionConfigurationTemplateList{},
		&PodSecurityPolicyTemplate{},
		&PodSecurityPolicyTemplateList{},
		&PodSecurityPolicyTemplateProjectBinding{},
		&PodSecurityPolicyTemplateProjectBindingList{},
		&Preference{},
		&PreferenceList{},
		&Principal{},
		&PrincipalList{},
		&Project{},
		&ProjectList{},
		&ProjectCatalog{},
		&ProjectCatalogList{},
		&ProjectLogging{},
		&ProjectLoggingList{},
		&ProjectNetworkPolicy{},
		&ProjectNetworkPolicyList{},
		&ProjectRoleTemplateBinding{},
		&ProjectRoleTemplateBindingList{},
		&RancherUserNotification{},
		&RancherUserNotificationList{},
		&RkeAddon{},
		&RkeAddonList{},
		&RkeK8sServiceOption{},
		&RkeK8sServiceOptionList{},
		&RkeK8sSystemImage{},
		&RkeK8sSystemImageList{},
		&RoleTemplate{},
		&RoleTemplateList{},
		&SamlProvider{},
		&SamlProviderList{},
		&SamlToken{},
		&SamlTokenList{},
		&Setting{},
		&SettingList{},
		&Template{},
		&TemplateList{},
		&TemplateContent{},
		&TemplateContentList{},
		&TemplateVersion{},
		&TemplateVersionList{},
		&Token{},
		&TokenList{},
		&User{},
		&UserList{},
		&UserAttribute{},
		&UserAttributeList{},
	)
	metav1.AddToGroupVersion(scheme, SchemeGroupVersion)
	return nil
}
