/*
Copyright 2018 The CDI Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	"context"
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1beta1 "kubevirt.io/containerized-data-importer-api/pkg/apis/forklift/v1beta1"
	scheme "kubevirt.io/containerized-data-importer/pkg/client/clientset/versioned/scheme"
)

// OpenstackVolumePopulatorsGetter has a method to return a OpenstackVolumePopulatorInterface.
// A group's client should implement this interface.
type OpenstackVolumePopulatorsGetter interface {
	OpenstackVolumePopulators(namespace string) OpenstackVolumePopulatorInterface
}

// OpenstackVolumePopulatorInterface has methods to work with OpenstackVolumePopulator resources.
type OpenstackVolumePopulatorInterface interface {
	Create(ctx context.Context, openstackVolumePopulator *v1beta1.OpenstackVolumePopulator, opts v1.CreateOptions) (*v1beta1.OpenstackVolumePopulator, error)
	Update(ctx context.Context, openstackVolumePopulator *v1beta1.OpenstackVolumePopulator, opts v1.UpdateOptions) (*v1beta1.OpenstackVolumePopulator, error)
	UpdateStatus(ctx context.Context, openstackVolumePopulator *v1beta1.OpenstackVolumePopulator, opts v1.UpdateOptions) (*v1beta1.OpenstackVolumePopulator, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta1.OpenstackVolumePopulator, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1beta1.OpenstackVolumePopulatorList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.OpenstackVolumePopulator, err error)
	OpenstackVolumePopulatorExpansion
}

// openstackVolumePopulators implements OpenstackVolumePopulatorInterface
type openstackVolumePopulators struct {
	client rest.Interface
	ns     string
}

// newOpenstackVolumePopulators returns a OpenstackVolumePopulators
func newOpenstackVolumePopulators(c *ForkliftV1beta1Client, namespace string) *openstackVolumePopulators {
	return &openstackVolumePopulators{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the openstackVolumePopulator, and returns the corresponding openstackVolumePopulator object, and an error if there is any.
func (c *openstackVolumePopulators) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.OpenstackVolumePopulator, err error) {
	result = &v1beta1.OpenstackVolumePopulator{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("openstackvolumepopulators").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of OpenstackVolumePopulators that match those selectors.
func (c *openstackVolumePopulators) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.OpenstackVolumePopulatorList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1beta1.OpenstackVolumePopulatorList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("openstackvolumepopulators").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested openstackVolumePopulators.
func (c *openstackVolumePopulators) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("openstackvolumepopulators").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a openstackVolumePopulator and creates it.  Returns the server's representation of the openstackVolumePopulator, and an error, if there is any.
func (c *openstackVolumePopulators) Create(ctx context.Context, openstackVolumePopulator *v1beta1.OpenstackVolumePopulator, opts v1.CreateOptions) (result *v1beta1.OpenstackVolumePopulator, err error) {
	result = &v1beta1.OpenstackVolumePopulator{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("openstackvolumepopulators").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(openstackVolumePopulator).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a openstackVolumePopulator and updates it. Returns the server's representation of the openstackVolumePopulator, and an error, if there is any.
func (c *openstackVolumePopulators) Update(ctx context.Context, openstackVolumePopulator *v1beta1.OpenstackVolumePopulator, opts v1.UpdateOptions) (result *v1beta1.OpenstackVolumePopulator, err error) {
	result = &v1beta1.OpenstackVolumePopulator{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("openstackvolumepopulators").
		Name(openstackVolumePopulator.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(openstackVolumePopulator).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *openstackVolumePopulators) UpdateStatus(ctx context.Context, openstackVolumePopulator *v1beta1.OpenstackVolumePopulator, opts v1.UpdateOptions) (result *v1beta1.OpenstackVolumePopulator, err error) {
	result = &v1beta1.OpenstackVolumePopulator{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("openstackvolumepopulators").
		Name(openstackVolumePopulator.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(openstackVolumePopulator).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the openstackVolumePopulator and deletes it. Returns an error if one occurs.
func (c *openstackVolumePopulators) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("openstackvolumepopulators").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *openstackVolumePopulators) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("openstackvolumepopulators").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched openstackVolumePopulator.
func (c *openstackVolumePopulators) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.OpenstackVolumePopulator, err error) {
	result = &v1beta1.OpenstackVolumePopulator{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("openstackvolumepopulators").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
