/*
Copyright 2018 The CDI Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1beta1 "kubevirt.io/containerized-data-importer-api/pkg/apis/core/v1beta1"
)

// FakeDataImportCrons implements DataImportCronInterface
type FakeDataImportCrons struct {
	Fake *FakeCdiV1beta1
	ns   string
}

var dataimportcronsResource = v1beta1.SchemeGroupVersion.WithResource("dataimportcrons")

var dataimportcronsKind = v1beta1.SchemeGroupVersion.WithKind("DataImportCron")

// Get takes name of the dataImportCron, and returns the corresponding dataImportCron object, and an error if there is any.
func (c *FakeDataImportCrons) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.DataImportCron, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(dataimportcronsResource, c.ns, name), &v1beta1.DataImportCron{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.DataImportCron), err
}

// List takes label and field selectors, and returns the list of DataImportCrons that match those selectors.
func (c *FakeDataImportCrons) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.DataImportCronList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(dataimportcronsResource, dataimportcronsKind, c.ns, opts), &v1beta1.DataImportCronList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1beta1.DataImportCronList{ListMeta: obj.(*v1beta1.DataImportCronList).ListMeta}
	for _, item := range obj.(*v1beta1.DataImportCronList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested dataImportCrons.
func (c *FakeDataImportCrons) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(dataimportcronsResource, c.ns, opts))

}

// Create takes the representation of a dataImportCron and creates it.  Returns the server's representation of the dataImportCron, and an error, if there is any.
func (c *FakeDataImportCrons) Create(ctx context.Context, dataImportCron *v1beta1.DataImportCron, opts v1.CreateOptions) (result *v1beta1.DataImportCron, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(dataimportcronsResource, c.ns, dataImportCron), &v1beta1.DataImportCron{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.DataImportCron), err
}

// Update takes the representation of a dataImportCron and updates it. Returns the server's representation of the dataImportCron, and an error, if there is any.
func (c *FakeDataImportCrons) Update(ctx context.Context, dataImportCron *v1beta1.DataImportCron, opts v1.UpdateOptions) (result *v1beta1.DataImportCron, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(dataimportcronsResource, c.ns, dataImportCron), &v1beta1.DataImportCron{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.DataImportCron), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeDataImportCrons) UpdateStatus(ctx context.Context, dataImportCron *v1beta1.DataImportCron, opts v1.UpdateOptions) (*v1beta1.DataImportCron, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(dataimportcronsResource, "status", c.ns, dataImportCron), &v1beta1.DataImportCron{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.DataImportCron), err
}

// Delete takes name of the dataImportCron and deletes it. Returns an error if one occurs.
func (c *FakeDataImportCrons) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(dataimportcronsResource, c.ns, name, opts), &v1beta1.DataImportCron{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeDataImportCrons) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(dataimportcronsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1beta1.DataImportCronList{})
	return err
}

// Patch applies the patch and returns the patched dataImportCron.
func (c *FakeDataImportCrons) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.DataImportCron, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(dataimportcronsResource, c.ns, name, pt, data, subresources...), &v1beta1.DataImportCron{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.DataImportCron), err
}
