/*
Copyright 2018 The CDI Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1beta1 "kubevirt.io/containerized-data-importer-api/pkg/apis/forklift/v1beta1"
)

// FakeOvirtVolumePopulators implements OvirtVolumePopulatorInterface
type FakeOvirtVolumePopulators struct {
	Fake *FakeForkliftV1beta1
	ns   string
}

var ovirtvolumepopulatorsResource = v1beta1.SchemeGroupVersion.WithResource("ovirtvolumepopulators")

var ovirtvolumepopulatorsKind = v1beta1.SchemeGroupVersion.WithKind("OvirtVolumePopulator")

// Get takes name of the ovirtVolumePopulator, and returns the corresponding ovirtVolumePopulator object, and an error if there is any.
func (c *FakeOvirtVolumePopulators) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.OvirtVolumePopulator, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(ovirtvolumepopulatorsResource, c.ns, name), &v1beta1.OvirtVolumePopulator{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.OvirtVolumePopulator), err
}

// List takes label and field selectors, and returns the list of OvirtVolumePopulators that match those selectors.
func (c *FakeOvirtVolumePopulators) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.OvirtVolumePopulatorList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(ovirtvolumepopulatorsResource, ovirtvolumepopulatorsKind, c.ns, opts), &v1beta1.OvirtVolumePopulatorList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1beta1.OvirtVolumePopulatorList{ListMeta: obj.(*v1beta1.OvirtVolumePopulatorList).ListMeta}
	for _, item := range obj.(*v1beta1.OvirtVolumePopulatorList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested ovirtVolumePopulators.
func (c *FakeOvirtVolumePopulators) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(ovirtvolumepopulatorsResource, c.ns, opts))

}

// Create takes the representation of a ovirtVolumePopulator and creates it.  Returns the server's representation of the ovirtVolumePopulator, and an error, if there is any.
func (c *FakeOvirtVolumePopulators) Create(ctx context.Context, ovirtVolumePopulator *v1beta1.OvirtVolumePopulator, opts v1.CreateOptions) (result *v1beta1.OvirtVolumePopulator, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(ovirtvolumepopulatorsResource, c.ns, ovirtVolumePopulator), &v1beta1.OvirtVolumePopulator{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.OvirtVolumePopulator), err
}

// Update takes the representation of a ovirtVolumePopulator and updates it. Returns the server's representation of the ovirtVolumePopulator, and an error, if there is any.
func (c *FakeOvirtVolumePopulators) Update(ctx context.Context, ovirtVolumePopulator *v1beta1.OvirtVolumePopulator, opts v1.UpdateOptions) (result *v1beta1.OvirtVolumePopulator, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(ovirtvolumepopulatorsResource, c.ns, ovirtVolumePopulator), &v1beta1.OvirtVolumePopulator{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.OvirtVolumePopulator), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeOvirtVolumePopulators) UpdateStatus(ctx context.Context, ovirtVolumePopulator *v1beta1.OvirtVolumePopulator, opts v1.UpdateOptions) (*v1beta1.OvirtVolumePopulator, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(ovirtvolumepopulatorsResource, "status", c.ns, ovirtVolumePopulator), &v1beta1.OvirtVolumePopulator{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.OvirtVolumePopulator), err
}

// Delete takes name of the ovirtVolumePopulator and deletes it. Returns an error if one occurs.
func (c *FakeOvirtVolumePopulators) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(ovirtvolumepopulatorsResource, c.ns, name, opts), &v1beta1.OvirtVolumePopulator{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeOvirtVolumePopulators) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(ovirtvolumepopulatorsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1beta1.OvirtVolumePopulatorList{})
	return err
}

// Patch applies the patch and returns the patched ovirtVolumePopulator.
func (c *FakeOvirtVolumePopulators) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.OvirtVolumePopulator, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(ovirtvolumepopulatorsResource, c.ns, name, pt, data, subresources...), &v1beta1.OvirtVolumePopulator{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.OvirtVolumePopulator), err
}
