; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=slp-vectorizer -S -mcpu=corei7-avx | FileCheck %s

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

define void @test1(x86_mmx %a, x86_mmx %b, ptr %ptr) {
; Ensure we can handle x86_mmx values which are primitive and can be bitcast
; with integer types but can't be put into a vector.
;
; CHECK-LABEL: @test1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_CAST:%.*]] = bitcast x86_mmx [[A:%.*]] to i64
; CHECK-NEXT:    [[B_CAST:%.*]] = bitcast x86_mmx [[B:%.*]] to i64
; CHECK-NEXT:    [[A_AND:%.*]] = and i64 [[A_CAST]], 42
; CHECK-NEXT:    [[B_AND:%.*]] = and i64 [[B_CAST]], 42
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr i64, ptr [[PTR:%.*]], i32 1
; CHECK-NEXT:    store i64 [[A_AND]], ptr [[PTR]], align 8
; CHECK-NEXT:    store i64 [[B_AND]], ptr [[GEP]], align 8
; CHECK-NEXT:    ret void
;
entry:
  %a.cast = bitcast x86_mmx %a to i64
  %b.cast = bitcast x86_mmx %b to i64
  %a.and = and i64 %a.cast, 42
  %b.and = and i64 %b.cast, 42
  %gep = getelementptr i64, ptr %ptr, i32 1
  store i64 %a.and, ptr %ptr
  store i64 %b.and, ptr %gep
  ret void
}

define void @test2(x86_mmx %a, x86_mmx %b) {
; Same as @test1 but using phi-input vectorization instead of store
; vectorization.
;
; CHECK-LABEL: @test2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 undef, label [[IF_THEN:%.*]], label [[EXIT:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[A_CAST:%.*]] = bitcast x86_mmx [[A:%.*]] to i64
; CHECK-NEXT:    [[B_CAST:%.*]] = bitcast x86_mmx [[B:%.*]] to i64
; CHECK-NEXT:    [[A_AND:%.*]] = and i64 [[A_CAST]], 42
; CHECK-NEXT:    [[B_AND:%.*]] = and i64 [[B_CAST]], 42
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[A_PHI:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[A_AND]], [[IF_THEN]] ]
; CHECK-NEXT:    [[B_PHI:%.*]] = phi i64 [ 0, [[ENTRY]] ], [ [[B_AND]], [[IF_THEN]] ]
; CHECK-NEXT:    tail call void @f(i64 [[A_PHI]], i64 [[B_PHI]])
; CHECK-NEXT:    ret void
;
entry:
  br i1 undef, label %if.then, label %exit

if.then:
  %a.cast = bitcast x86_mmx %a to i64
  %b.cast = bitcast x86_mmx %b to i64
  %a.and = and i64 %a.cast, 42
  %b.and = and i64 %b.cast, 42
  br label %exit

exit:
  %a.phi = phi i64 [ 0, %entry ], [ %a.and, %if.then ]
  %b.phi = phi i64 [ 0, %entry ], [ %b.and, %if.then ]
  tail call void @f(i64 %a.phi, i64 %b.phi)
  ret void
}

define i8 @test3(ptr %addr) {
; Check that we do not vectorize types that are padded to a bigger ones.
;
; CHECK-LABEL: @test3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A1:%.*]] = getelementptr inbounds i2, ptr [[ADDR:%.*]], i64 1
; CHECK-NEXT:    [[A2:%.*]] = getelementptr inbounds i2, ptr [[ADDR]], i64 2
; CHECK-NEXT:    [[A3:%.*]] = getelementptr inbounds i2, ptr [[ADDR]], i64 3
; CHECK-NEXT:    [[L0:%.*]] = load i2, ptr [[ADDR]], align 1
; CHECK-NEXT:    [[L1:%.*]] = load i2, ptr [[A1]], align 1
; CHECK-NEXT:    [[L2:%.*]] = load i2, ptr [[A2]], align 1
; CHECK-NEXT:    [[L3:%.*]] = load i2, ptr [[A3]], align 1
; CHECK-NEXT:    br label [[BB1:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[P0:%.*]] = phi i2 [ [[L0]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[P1:%.*]] = phi i2 [ [[L1]], [[ENTRY]] ]
; CHECK-NEXT:    [[P2:%.*]] = phi i2 [ [[L2]], [[ENTRY]] ]
; CHECK-NEXT:    [[P3:%.*]] = phi i2 [ [[L3]], [[ENTRY]] ]
; CHECK-NEXT:    [[R:%.*]] = zext i2 [[P2]] to i8
; CHECK-NEXT:    ret i8 [[R]]
;
entry:
  %a1 = getelementptr inbounds i2, ptr %addr, i64 1
  %a2 = getelementptr inbounds i2, ptr %addr, i64 2
  %a3 = getelementptr inbounds i2, ptr %addr, i64 3
  %l0 = load i2, ptr %addr, align 1
  %l1 = load i2, ptr %a1, align 1
  %l2 = load i2, ptr %a2, align 1
  %l3 = load i2, ptr %a3, align 1
  br label %bb1
bb1:                                              ; preds = %entry
  %p0 = phi i2 [ %l0, %entry ]
  %p1 = phi i2 [ %l1, %entry ]
  %p2 = phi i2 [ %l2, %entry ]
  %p3 = phi i2 [ %l3, %entry ]
  %r  = zext i2 %p2 to i8
  ret i8 %r
}

declare void @f(i64, i64)

define void @test4(i32 %a, ptr %ptr) {
; Check that we do not vectorize types that are padded to a bigger ones.
;
; CHECK-LABEL: @test4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TRUNC:%.*]] = trunc i32 [[A:%.*]] to i28
; CHECK-NEXT:    [[GEP1:%.*]] = getelementptr i28, ptr [[PTR:%.*]], i32 1
; CHECK-NEXT:    [[GEP2:%.*]] = getelementptr i28, ptr [[PTR]], i32 2
; CHECK-NEXT:    [[GEP3:%.*]] = getelementptr i28, ptr [[PTR]], i32 3
; CHECK-NEXT:    store i28 [[TRUNC]], ptr [[PTR]], align 4
; CHECK-NEXT:    store i28 [[TRUNC]], ptr [[GEP1]], align 4
; CHECK-NEXT:    store i28 [[TRUNC]], ptr [[GEP2]], align 4
; CHECK-NEXT:    store i28 [[TRUNC]], ptr [[GEP3]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %trunc = trunc i32 %a to i28
  %gep1 = getelementptr i28, ptr %ptr, i32 1
  %gep2 = getelementptr i28, ptr %ptr, i32 2
  %gep3 = getelementptr i28, ptr %ptr, i32 3
  store i28 %trunc, ptr %ptr
  store i28 %trunc, ptr %gep1
  store i28 %trunc, ptr %gep2
  store i28 %trunc, ptr %gep3
  ret void
}
