; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64 %s -o - | FileCheck %s

define i16 @test_signed_load(ptr nocapture readonly %ptr) {
; CHECK-LABEL: test_signed_load:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldrsh w8, [x0]
; CHECK-NEXT:    tst w8, #0xffff0000
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %load = load i16, ptr %ptr, align 2
  %conv0 = zext i16 %load to i32
  %conv1 = sext i16 %load to i32
  %cmp = icmp eq i32 %conv0, %conv1
  %conv2 = zext i1 %cmp to i16
  ret i16 %conv2
}

define i16 @test_ashr(i16 zeroext %arg) local_unnamed_addr #1 {
; CHECK-LABEL: test_ashr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp w0, #2
; CHECK-NEXT:    cset w0, lo
; CHECK-NEXT:    ret
  %cmp = icmp ult i16 %arg, 2
  %conv = zext i1 %cmp to i16
  ret i16 %conv
}

define i16 @test_sdiv(i16 zeroext %arg) local_unnamed_addr #1 {
; CHECK-LABEL: test_sdiv:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add w8, w0, #1
; CHECK-NEXT:    and w8, w8, #0xffff
; CHECK-NEXT:    cmp w8, #2
; CHECK-NEXT:    cset w0, hi
; CHECK-NEXT:    ret
  %arg.off = add i16 %arg, 1
  %1 = icmp ugt i16 %arg.off, 2
  %conv = zext i1 %1 to i16
  ret i16 %conv
}

define i16 @test_srem(i16 zeroext %arg) local_unnamed_addr #1 {
; CHECK-LABEL: test_srem:
; CHECK:       // %bb.0:
; CHECK-NEXT:    tst w0, #0x3
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
  %1 = and i16 %arg, 3
  %cmp = icmp ne i16 %1, 0
  %conv = zext i1 %cmp to i16
  ret i16 %conv
}

define i32 @test_signext_b(ptr nocapture readonly %ptr, i8 signext %arg) {
; CHECK-LABEL: test_signext_b:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldrb w9, [x0]
; CHECK-NEXT:    mov w8, #20894
; CHECK-NEXT:    add w9, w9, w1
; CHECK-NEXT:    sxtb w9, w9
; CHECK-NEXT:    cmp w9, #0
; CHECK-NEXT:    mov w9, #42
; CHECK-NEXT:    csel w0, w9, w8, ge
; CHECK-NEXT:    ret
entry:
  %0 = load i8, ptr %ptr, align 1
  %1 = add nuw nsw i8 %0, %arg
  %cmp = icmp sgt i8 %1, -1
  %res = select i1 %cmp, i32 42, i32 20894
  ret i32 %res
}

define i32 @test_signext_b_ult_slt(ptr nocapture readonly %ptr, i8 signext %arg) {
; CHECK-LABEL: test_signext_b_ult_slt:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldrb w8, [x0]
; CHECK-NEXT:    add w9, w8, w1, uxtb
; CHECK-NEXT:    cmp w9, #127
; CHECK-NEXT:    mov w9, #42
; CHECK-NEXT:    ccmp w8, #0, #0, ne
; CHECK-NEXT:    mov w8, #57
; CHECK-NEXT:    csel w0, w9, w8, eq
; CHECK-NEXT:    ret
entry:
  %0 = load i8, ptr %ptr, align 1
  %1 = add nuw nsw i8 %0, %arg
  %cmp = icmp ne i8 %1, 127
  %cmp.1 = icmp eq i8 %0, 0
  %or = and i1 %cmp.1, %cmp
  %res = select i1 %or, i32 42, i32 57
  ret i32 %res
}

define i32 @test_signext_h(ptr nocapture readonly %ptr, i16 signext %arg) {
; CHECK-LABEL: test_signext_h:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldrh w9, [x0]
; CHECK-NEXT:    mov w8, #20894
; CHECK-NEXT:    add w9, w9, w1
; CHECK-NEXT:    sxth w9, w9
; CHECK-NEXT:    cmp w9, #0
; CHECK-NEXT:    mov w9, #42
; CHECK-NEXT:    csel w0, w9, w8, ge
; CHECK-NEXT:    ret
entry:
  %0 = load i16, ptr %ptr, align 1
  %1 = add nuw nsw i16 %0, %arg
  %cmp = icmp sgt i16 %1, -1
  %res = select i1 %cmp, i32 42, i32 20894
  ret i32 %res
}
