#
# spec file for package python-mcp-server-mlm
#
# Copyright (c) 2025 SUSE LLC
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#


%{?sle15_python_module_pythons}
%if 0%{?suse_version} > 1500
%bcond_without libalternatives
%else
%bcond_with libalternatives
%endif
%global p_version 0.5.2
%global git_revision %(tar xfO %{SOURCE0} mcp-server-uyuni-%{p_version}/last-commit)

Name:           python-mcp-server-mlm
Version:        %{p_version}+git%{git_revision}
Release:        0
Summary:        Model Context Protocol Server for Uyuni Server API
License:        Apache-2.0
URL:            https://github.com/uyuni-project/mcp-server-uyuni
Source:         mcp-server-uyuni-%{p_version}.tar.gz

BuildRequires:  %{python_module pip}
BuildRequires:  %{python_module setuptools}
BuildRequires:  %{python_module wheel}
BuildRequires:  %{python_module hatchling}
BuildRequires:  fdupes
BuildRequires:  python-rpm-macros
Requires:       python-fastmcp >= 2.6.0
# List of python dependencies from pyproject.toml generated by pydeps.py
Requires:       %{python_module annotated-types = 0.7.0}
Requires:       %{python_module anyio = 4.11.0}
Requires:       %{python_module attrs = 25.4.0}
Requires:       %{python_module Authlib = 1.6.6}
Requires:       %{python_module certifi = 2025.1.31}
Requires:       %{python_module cffi = 1.17.1}
Requires:       %{python_module click = 8.3.1}
Requires:       %{python_module cryptography = 44.0.3}
Requires:       %{python_module exceptiongroup = 1.2.2}
Requires:       %{python_module fastmcp = 2.12.4}
Requires:       %{python_module h11 = 0.16.0}
Requires:       %{python_module httpcore = 1.0.9}
Requires:       %{python_module httpx = 0.28.1}
Requires:       %{python_module httpx-sse = 0.4.0}
Requires:       %{python_module idna = 3.10}
Requires:       %{python_module jsonschema = 4.26.0}
Requires:       %{python_module jsonschema-specifications = 2024.10.1}
Requires:       %{python_module lazy-object-proxy = 1.10.0}
Requires:       %{python_module markdown-it-py = 3.0.0}
Requires:       %{python_module MarkupSafe = 3.0.2}
Requires:       %{python_module mcp = 1.15.0}
Requires:       %{python_module mdurl = 0.1.2}
Requires:       %{python_module more-itertools = 10.8.0}
Requires:       %{python_module openapi-core = 0.19.5}
Requires:       %{python_module openapi-pydantic = 0.5.1}
Requires:       %{python_module openapi-schema-validator = 0.6.3}
Requires:       %{python_module openapi-spec-validator = 0.7.2}
Requires:       %{python_module pathable = 0.4.4}
Requires:       %{python_module pycparser = 2.23}
Requires:       %{python_module pydantic = 2.11.9}
Requires:       %{python_module pydantic-core = 2.33.2}
Requires:       %{python_module pydantic-settings = 2.10.1}
Requires:       %{python_module pygments = 2.19.2}
Requires:       %{python_module pyperclip = 1.11.0}
Requires:       %{pythons}-python-dotenv = 1.1.0
Requires:       %{pythons}-python-multipart = 0.0.20
Requires:       %{python_module PyYAML = 6.0.3}
Requires:       %{python_module referencing = 0.36.2}
Requires:       %{python_module requests = 2.32.4}
Requires:       %{python_module rfc3339-validator = 0.1.4}
Requires:       %{python_module rich = 14.2.0}
Requires:       %{python_module rich-rst = 1.3.1}
Requires:       %{python_module rpds-py = 0.27.1}
Requires:       %{python_module shellingham = 1.5.4}
Requires:       %{python_module six = 1.17.0}
Requires:       %{python_module sniffio = 1.3.1}
Requires:       %{python_module sse-starlette = 2.3.6}
Requires:       %{python_module starlette = 0.49.1}
Requires:       %{python_module typer = 0.21.1}
Requires:       %{python_module typing-extensions = 4.15.0}
Requires:       %{python_module typing-inspection = 0.4.2}
Requires:       %{python_module urllib3 = 2.5.0}
Requires:       %{python_module uvicorn = 0.34.2}
Requires:       %{python_module websockets = 14.2}
Requires:       %{python_module Werkzeug = 3.1.1}
# End
Provides:       %{name} = %{p_version}  

BuildArch:      noarch

%if %{with libalternatives}
BuildRequires:  alts
Requires:       alts
%else
Requires(post): update-alternatives
Requires(postun): update-alternatives
%endif
%python_subpackages

%description
Model Context Protocol Server for Uyuni/MLM Server API.

%prep
%autosetup -p1 -n mcp-server-uyuni-%{p_version}

%build
%pyproject_wheel

%install
%pyproject_install
%python_expand %fdupes %{buildroot}%{$python_sitelib}
%python_clone -a %{buildroot}%{_bindir}/mcp-server-uyuni

%post
%python_install_alternative mcp-server-uyuni

%postun
%python_uninstall_alternative mcp-server-uyuni

%files %{python_files}
%license LICENSE
%python_alternative %{_bindir}/mcp-server-uyuni
%{python_sitelib}/mcp_server_uyuni*

%changelog
