#!/usr/bin/python3.11

import os
import tomllib

print(f"# List of python dependencies from pyprojec.toml generated by {os.path.basename(__file__)}")
pyproject_toml = os.path.dirname(os.path.realpath(__file__)) + "/../pyproject.toml"
pyprefix = "python311"
with open(pyproject_toml, "rb") as f:
    data = tomllib.load(f)
    for i in data['project']['dependencies']:
        dep = i.replace("==", " = ")
        # the package is python-Authlib while the module is authlib
        dep = dep.replace("authlib", "Authlib")
        dep = dep.replace("markupsafe", "MarkupSafe")
        dep = dep.replace("pyyaml", "PyYAML")
        dep = dep.replace("werkzeug", "Werkzeug")
        print(f"Requires:       {pyprefix}-{dep}")
print("# End")
