#ifndef DILITHIUM_REJECTION_VECTORS_H
#define DILITHIUM_REJECTION_VECTORS_H
#include "dilithium_type.h"
#include "lc_sha256.h"
struct dilithium_rejection_testvector {
	uint8_t seed[LC_DILITHIUM_SEEDBYTES];
	uint8_t pk[LC_DILITHIUM_PUBLICKEYBYTES];
	uint8_t sk[LC_DILITHIUM_SECRETKEYBYTES];
	uint8_t key_hash[LC_SHA256_SIZE_DIGEST];
	uint8_t msg[64];
	uint8_t sig_hash[LC_SHA256_SIZE_DIGEST];
	uint8_t sig[LC_DILITHIUM_CRYPTO_BYTES];
};

static const struct
dilithium_rejection_testvector dilithium_rejection_testvectors[] =
{
	{
		.seed = {
			0x51, 0x83, 0x8e, 0x29, 0xe8, 0xfe, 0x1f, 0x35, 
			0x7a, 0x65, 0x6a, 0xc1, 0x06, 0x25, 0x48, 0x56, 
			0xd8, 0xf0, 0xde, 0x83, 0xd3, 0x9d, 0xd9, 0xc4, 
			0x31, 0x33, 0x4c, 0xfa, 0x6a, 0xc0, 0x40, 0xb0, 
			},
		.pk = {
			0x8f, 0x61, 0x67, 0xa9, 0x7c, 0x61, 0xc2, 0xf2, 
			0x87, 0xe2, 0x28, 0xf8, 0x44, 0x80, 0x6f, 0xb0, 
			0x10, 0xc1, 0x14, 0xf6, 0x88, 0x42, 0x76, 0xbe, 
			0x05, 0xd2, 0x56, 0xa0, 0xb7, 0x46, 0xcf, 0xc5, 
			0x76, 0x0a, 0x52, 0xfe, 0xa3, 0x3c, 0x05, 0x6e, 
			0xd5, 0xd3, 0xbd, 0x80, 0x03, 0x29, 0x25, 0x96, 
			0xdf, 0xa9, 0x5b, 0x12, 0x42, 0x89, 0x6e, 0x03, 
			0x2c, 0x42, 0x64, 0xee, 0xc7, 0xf7, 0x55, 0xfe, 
			0xfd, 0x15, 0x74, 0xee, 0x2d, 0xb3, 0xbf, 0xf2, 
			0x24, 0xe7, 0x35, 0x45, 0x77, 0x67, 0x44, 0xd2, 
			0x0c, 0x43, 0xfc, 0x7b, 0x47, 0x56, 0xad, 0xc5, 
			0xe7, 0x37, 0x49, 0x21, 0x12, 0x57, 0x7f, 0xca, 
			0x7f, 0x5d, 0xac, 0x62, 0x5b, 0x8d, 0xbf, 0xdb, 
			0x64, 0xac, 0x12, 0x1d, 0x7f, 0x7a, 0x2f, 0xa0, 
			0x2c, 0xfe, 0x95, 0x4b, 0x78, 0xdb, 0xf0, 0x98, 
			0x97, 0x70, 0x62, 0xfc, 0x64, 0x4a, 0x1b, 0xbc, 
			0x30, 0x1b, 0x51, 0x13, 0x47, 0x6e, 0x83, 0xd2, 
			0xa2, 0xcf, 0x39, 0xba, 0xd3, 0x00, 0x62, 0x7c, 
			0x5b, 0xe6, 0x14, 0x55, 0xd5, 0xfc, 0xbf, 0x15, 
			0x65, 0xd7, 0x1f, 0xbb, 0xf6, 0x2b, 0x46, 0x38, 
			0x1e, 0xf3, 0x8f, 0x0d, 0x57, 0x8a, 0x41, 0xfb, 
			0x47, 0x19, 0xe1, 0x79, 0xca, 0x98, 0x1a, 0x73, 
			0x4d, 0x8a, 0xc0, 0xa1, 0xa7, 0x4a, 0x28, 0x4a, 
			0x92, 0x6c, 0x77, 0x4f, 0x18, 0xe1, 0xce, 0x11, 
			0x14, 0xd5, 0xf6, 0xc0, 0xa8, 0x1e, 0x26, 0x25, 
			0xe4, 0x30, 0xb2, 0x6f, 0x89, 0x6e, 0xc6, 0x44, 
			0x1a, 0xd3, 0xca, 0xe1, 0x05, 0x0d, 0x61, 0x80, 
			0xd7, 0xbc, 0x56, 0x0a, 0x57, 0x9f, 0x16, 0x40, 
			0x84, 0x1e, 0xc0, 0x5e, 0xcd, 0xb6, 0xc8, 0x5d, 
			0x87, 0xd6, 0xee, 0xcb, 0x21, 0x2f, 0x22, 0x9a, 
			0x7e, 0xea, 0x2e, 0xf5, 0x87, 0xf0, 0x44, 0x10, 
			0x3d, 0x42, 0x6d, 0x3f, 0x4f, 0xa0, 0x21, 0x8e, 
			0x40, 0x75, 0x3b, 0xaa, 0xd4, 0xd9, 0x37, 0x0a, 
			0x35, 0x5b, 0xba, 0xbd, 0x11, 0x17, 0x7b, 0x7e, 
			0xfc, 0xb1, 0x1c, 0x5c, 0x71, 0xce, 0xde, 0xa5, 
			0xec, 0xd6, 0x8b, 0x50, 0x64, 0x02, 0xca, 0x84, 
			0x26, 0xfe, 0x03, 0x9e, 0xaf, 0x13, 0x05, 0x1c, 
			0x85, 0x32, 0x92, 0x85, 0x84, 0x83, 0xb6, 0x76, 
			0x27, 0xa7, 0xd8, 0x0c, 0xa4, 0xb5, 0x65, 0x7a, 
			0xbf, 0x2e, 0x64, 0xce, 0x82, 0x0d, 0x27, 0xd3, 
			0x2c, 0x9d, 0xb5, 0xa5, 0x51, 0xe3, 0xab, 0xbd, 
			0xe2, 0xe0, 0x64, 0x71, 0x0f, 0x99, 0x09, 0x6a, 
			0x40, 0x9d, 0x8c, 0x6d, 0x63, 0x70, 0x42, 0xe2, 
			0xa8, 0x5c, 0x71, 0xd2, 0x88, 0x10, 0xbc, 0x3b, 
			0x9d, 0xc8, 0x3a, 0x8a, 0xf3, 0x81, 0x0a, 0x0e, 
			0xd8, 0xf6, 0x13, 0x90, 0xc2, 0xda, 0x4c, 0x4f, 
			0x6f, 0x1f, 0x61, 0x0d, 0x46, 0xac, 0x5c, 0x4a, 
			0xcc, 0x23, 0xfb, 0xf2, 0xf8, 0x9f, 0x48, 0x1f, 
			0xaf, 0x24, 0xb4, 0xc7, 0xcb, 0x6f, 0x80, 0x74, 
			0xa3, 0xdb, 0xa8, 0x61, 0x12, 0x60, 0x08, 0x56, 
			0x85, 0x47, 0x05, 0x32, 0x93, 0x43, 0x9b, 0xa6, 
			0xf6, 0x56, 0x3b, 0xab, 0x93, 0x28, 0x19, 0xda, 
			0xad, 0xb5, 0xaa, 0x2e, 0x83, 0x3d, 0x37, 0x0e, 
			0x83, 0xf2, 0xfe, 0xdd, 0xe8, 0xd9, 0x53, 0x36, 
			0x3b, 0x5d, 0x8e, 0x24, 0xa9, 0x3a, 0x8f, 0x85, 
			0x4b, 0x50, 0xf7, 0x61, 0x0f, 0x20, 0x92, 0x09, 
			0x1f, 0xe4, 0x24, 0x98, 0x9f, 0xa4, 0x52, 0x12, 
			0x2a, 0xae, 0x6f, 0xd6, 0x0d, 0xb5, 0x22, 0x72, 
			0x83, 0xfb, 0x4f, 0xef, 0xa6, 0x55, 0x9a, 0x14, 
			0xab, 0x82, 0x89, 0x1f, 0xf2, 0x0b, 0x14, 0x76, 
			0xb7, 0xf7, 0x14, 0xdd, 0xd6, 0xc1, 0xe8, 0xb2, 
			0x99, 0x23, 0x28, 0xe8, 0xa4, 0x69, 0x18, 0xf6, 
			0x3e, 0xb1, 0xff, 0xde, 0xf2, 0x2c, 0x7c, 0x73, 
			0x93, 0x32, 0x52, 0x06, 0xeb, 0x59, 0xb2, 0x8f, 
			0x2f, 0x1d, 0x6a, 0x85, 0x74, 0xd3, 0xe5, 0xa1, 
			0x95, 0xe4, 0x96, 0x1e, 0x75, 0x16, 0xe4, 0x5c, 
			0x40, 0xf0, 0x20, 0xb1, 0x10, 0xe7, 0x2a, 0x70, 
			0x41, 0xac, 0x49, 0x40, 0x55, 0xef, 0xd1, 0x58, 
			0x24, 0x6a, 0xa6, 0x20, 0xdc, 0x23, 0xdc, 0x66, 
			0x45, 0x4f, 0x6a, 0x52, 0x3c, 0x61, 0xc8, 0xfb, 
			0x28, 0x1e, 0x8c, 0x3f, 0xfc, 0xc7, 0x73, 0x2f, 
			0xf1, 0xe2, 0x31, 0xee, 0xa0, 0x5f, 0x12, 0x3f, 
			0x94, 0xe5, 0x26, 0xc0, 0x62, 0xcc, 0x67, 0x8f, 
			0x5d, 0xfd, 0x3d, 0x8f, 0x16, 0xae, 0x4e, 0x04, 
			0x54, 0x5b, 0x02, 0x66, 0x00, 0x70, 0xe5, 0xcc, 
			0xb9, 0x51, 0x8c, 0x1a, 0x5d, 0xf0, 0xfe, 0x7d, 
			0x1b, 0x2f, 0x0a, 0x48, 0x94, 0xda, 0x4b, 0xb3, 
			0x05, 0x75, 0x3b, 0x25, 0xda, 0xf2, 0x12, 0x47, 
			0xe2, 0xd7, 0xbb, 0xe7, 0x05, 0xa2, 0x4e, 0xaf, 
			0x2f, 0x29, 0x6c, 0xbd, 0x80, 0x82, 0xdf, 0xbb, 
			0x4b, 0x9d, 0x29, 0x9b, 0xef, 0xff, 0x17, 0x2a, 
			0xa7, 0x2f, 0x4a, 0x2e, 0xbf, 0x29, 0x38, 0xcb, 
			0x94, 0x9c, 0x10, 0x87, 0x69, 0x57, 0x7d, 0xd7, 
			0xcf, 0xc1, 0x57, 0x0f, 0xc2, 0x9c, 0x3b, 0x1e, 
			0xbc, 0x55, 0x08, 0xb1, 0x50, 0xb0, 0x28, 0x79, 
			0x1d, 0xd9, 0x2f, 0xa5, 0x12, 0xcc, 0xa7, 0x5b, 
			0xcb, 0x67, 0x57, 0x13, 0x4a, 0xb3, 0xd5, 0x34, 
			0xea, 0xd9, 0x6b, 0x15, 0x17, 0x1f, 0xe7, 0x52, 
			0x2a, 0x11, 0xdf, 0xab, 0x3a, 0x8d, 0x1b, 0xaa, 
			0xfa, 0x54, 0xf0, 0x20, 0x94, 0x40, 0x2d, 0x3e, 
			0xf2, 0xa2, 0x8b, 0xbb, 0x86, 0xce, 0x29, 0x87, 
			0xb1, 0xfa, 0x27, 0xf2, 0x5a, 0x79, 0xc2, 0xf8, 
			0xe9, 0xf2, 0x7c, 0x5a, 0xcd, 0x45, 0x8e, 0x8b, 
			0xba, 0xad, 0x13, 0x52, 0x79, 0xd5, 0x0f, 0x59, 
			0xfb, 0x07, 0x15, 0x1f, 0xb3, 0xe6, 0xc8, 0x66, 
			0xf7, 0x37, 0x19, 0xd8, 0x33, 0xdd, 0xc1, 0xb3, 
			0x96, 0x4b, 0x28, 0x43, 0xf8, 0x5e, 0xc7, 0xe8, 
			0x81, 0x6e, 0xd0, 0xb2, 0x5a, 0x3d, 0xf1, 0x68, 
			0x8f, 0xf0, 0xf5, 0x1a, 0x6d, 0xc3, 0xaa, 0x5b, 
			0x72, 0x27, 0xbd, 0xd6, 0x7c, 0x9b, 0xbf, 0x89, 
			0x6a, 0x09, 0xf0, 0x48, 0xf0, 0x8c, 0x27, 0x69, 
			0x28, 0xf3, 0x5f, 0x53, 0xe3, 0x4d, 0x60, 0x4a, 
			0xb8, 0xc5, 0xf9, 0x85, 0x07, 0x3e, 0xfb, 0xd7, 
			0x21, 0x69, 0xd5, 0xec, 0x18, 0x68, 0xb6, 0x55, 
			0x15, 0xac, 0x2e, 0x0f, 0x5c, 0x2e, 0x9e, 0x12, 
			0x10, 0x5e, 0xc6, 0xb3, 0xcd, 0xe6, 0x3a, 0x2f, 
			0x43, 0xf6, 0x75, 0x31, 0x3c, 0x90, 0x34, 0x1c, 
			0x3d, 0x45, 0xaa, 0x8e, 0x08, 0xcf, 0x58, 0x67, 
			0x34, 0xd4, 0x24, 0xb8, 0x20, 0x69, 0xfe, 0xf0, 
			0x33, 0xe9, 0x3e, 0xbd, 0xe5, 0x18, 0x9f, 0x66, 
			0xc9, 0x0d, 0x6f, 0x47, 0x99, 0xf7, 0x0c, 0xdd, 
			0xad, 0x8c, 0x6b, 0x80, 0xed, 0x19, 0x61, 0x8a, 
			0xba, 0x62, 0x2f, 0xcc, 0x0e, 0x47, 0xe0, 0xc6, 
			0x1f, 0x2f, 0x44, 0x40, 0x17, 0xb6, 0x89, 0xc6, 
			0xf5, 0xc2, 0x97, 0x89, 0x38, 0x6c, 0x8e, 0x2c, 
			0x46, 0x0b, 0x6e, 0x01, 0x47, 0xd3, 0x2f, 0x58, 
			0xf8, 0xc7, 0x3b, 0x49, 0xb2, 0x35, 0x9f, 0x67, 
			0xc9, 0x6c, 0xde, 0x30, 0x3b, 0x50, 0x19, 0x65, 
			0xbb, 0x73, 0xa1, 0x47, 0x01, 0x6a, 0x3d, 0xe3, 
			0x85, 0x4d, 0xd0, 0x72, 0x0d, 0xbc, 0x81, 0x52, 
			0xe8, 0x1a, 0x8b, 0x85, 0x4c, 0x6f, 0x0e, 0xfc, 
			0x59, 0x84, 0x7a, 0xf2, 0x28, 0x3e, 0x02, 0xcb, 
			0xe2, 0x4a, 0xbf, 0xac, 0x22, 0x34, 0x86, 0xe4, 
			0x7d, 0x6b, 0xa3, 0x52, 0xac, 0xff, 0xe5, 0xbe, 
			0x0c, 0x8d, 0xf5, 0xd8, 0xfd, 0x5a, 0x3d, 0xad, 
			0x0d, 0xc0, 0x02, 0xd0, 0x58, 0x8e, 0x7c, 0x50, 
			0x7c, 0x09, 0xc0, 0xdb, 0xd7, 0xdf, 0xe0, 0xb2, 
			0x6f, 0xb2, 0x79, 0x0d, 0xc1, 0xa0, 0xb1, 0x7e, 
			0xe3, 0x0d, 0xfc, 0x93, 0x43, 0x8c, 0x86, 0x68, 
			0xa6, 0x51, 0x93, 0x42, 0xb7, 0xcd, 0x13, 0x56, 
			0x6e, 0xdc, 0x63, 0x51, 0x23, 0xcf, 0x29, 0xc5, 
			0x5a, 0x66, 0x43, 0x80, 0xfe, 0x28, 0x15, 0x71, 
			0x52, 0x87, 0xe2, 0x18, 0x10, 0xad, 0x94, 0x47, 
			0x2f, 0xe3, 0x5d, 0x7a, 0x02, 0x6d, 0x31, 0x58, 
			0xae, 0x2f, 0x96, 0x53, 0x1b, 0x6c, 0x0e, 0x25, 
			0xea, 0x41, 0xd3, 0x29, 0x27, 0x22, 0x24, 0x8d, 
			0x1d, 0x8e, 0xd1, 0x33, 0x76, 0x67, 0x7d, 0x9d, 
			0xd9, 0xa7, 0x3e, 0x61, 0xd0, 0xad, 0x93, 0xb9, 
			0xdf, 0x87, 0x3a, 0x7b, 0x89, 0xc7, 0x1d, 0x91, 
			0xec, 0x43, 0xa4, 0xdc, 0x02, 0x88, 0x2e, 0xaa, 
			0xb2, 0x58, 0xa5, 0xd3, 0x68, 0x9c, 0x9f, 0x60, 
			0x12, 0xc8, 0x7e, 0x7d, 0x40, 0x80, 0xfd, 0xb4, 
			0xbf, 0x56, 0xf4, 0x01, 0x39, 0x3d, 0xa0, 0x34, 
			0x48, 0x79, 0x75, 0xe2, 0x0f, 0x60, 0x09, 0x42, 
			0x11, 0x6f, 0xa5, 0x31, 0x46, 0xb7, 0x03, 0xc8, 
			0x61, 0x53, 0x39, 0x1e, 0xf4, 0x99, 0x36, 0x7d, 
			0xc0, 0x87, 0xda, 0x63, 0x71, 0x9b, 0x29, 0x7b, 
			0x4e, 0x6f, 0x09, 0xa2, 0x2c, 0xa5, 0xc2, 0xb9, 
			0xe7, 0xe0, 0x56, 0x8b, 0x1d, 0xbb, 0xcc, 0x34, 
			0x8c, 0xbc, 0xb6, 0x0a, 0xc9, 0xfa, 0x4a, 0x31, 
			0x63, 0x0d, 0x30, 0xff, 0x59, 0x3d, 0x8c, 0x4d, 
			0x74, 0x28, 0xf4, 0xe9, 0x97, 0x43, 0x05, 0x3a, 
			0x33, 0x51, 0x51, 0xe4, 0x0e, 0x33, 0xae, 0x2c, 
			0xda, 0x28, 0x83, 0x93, 0x4e, 0xfe, 0x37, 0x1d, 
			0x6c, 0x25, 0x1e, 0x24, 0xbc, 0x3a, 0x5c, 0x68, 
			0xac, 0x54, 0x3a, 0x47, 0x74, 0x35, 0xff, 0x37, 
			0x80, 0x12, 0x30, 0xd7, 0x31, 0x2a, 0x49, 0x51, 
			0x2d, 0x4f, 0xd2, 0x9c, 0xca, 0x55, 0x87, 0xd0, 
			0x41, 0x86, 0xc7, 0xf2, 0xda, 0xf8, 0x4b, 0x08, 
			0x23, 0xb3, 0x00, 0xb7, 0xb6, 0x4f, 0x2e, 0xaf, 
			0xb8, 0x8e, 0xb1, 0x44, 0xe1, 0xed, 0x67, 0xf8, 
			0x80, 0xa7, 0x04, 0xa0, 0x66, 0xe6, 0xb5, 0x69, 
			0xca, 0x95, 0x71, 0xc8, 0x0d, 0x3d, 0xf6, 0x77, 
			0xfd, 0x2c, 0x95, 0xed, 0xe5, 0x22, 0x43, 0xd9, 
			},
		.sk = {
			0x8f, 0x61, 0x67, 0xa9, 0x7c, 0x61, 0xc2, 0xf2, 
			0x87, 0xe2, 0x28, 0xf8, 0x44, 0x80, 0x6f, 0xb0, 
			0x10, 0xc1, 0x14, 0xf6, 0x88, 0x42, 0x76, 0xbe, 
			0x05, 0xd2, 0x56, 0xa0, 0xb7, 0x46, 0xcf, 0xc5, 
			0x88, 0x93, 0x36, 0x71, 0x6e, 0xaa, 0x48, 0x61, 
			0xb8, 0x9b, 0x3a, 0x69, 0x82, 0x29, 0x0b, 0xf5, 
			0x0f, 0xf4, 0x81, 0x87, 0x57, 0x07, 0xec, 0x70, 
			0xbc, 0xee, 0x4d, 0xb6, 0xfc, 0x98, 0x40, 0x35, 
			0xbd, 0x45, 0x19, 0xd9, 0xc5, 0x66, 0xd4, 0xfb, 
			0xf4, 0x93, 0xae, 0xbd, 0x32, 0x1f, 0xd4, 0xa2, 
			0x9a, 0xdc, 0x33, 0xb0, 0xfd, 0xff, 0x92, 0xe2, 
			0x67, 0x16, 0x15, 0xe8, 0xc6, 0xca, 0x3d, 0xbf, 
			0x25, 0x84, 0x0a, 0xc6, 0x0c, 0x1e, 0x64, 0x63, 
			0xd5, 0x99, 0xc7, 0x61, 0x36, 0xf6, 0xaa, 0x2a, 
			0x6b, 0x0c, 0x1c, 0xad, 0x3a, 0x57, 0xae, 0x6a, 
			0x65, 0xf0, 0x9e, 0x70, 0xba, 0x60, 0x37, 0x3c, 
			0x5a, 0x26, 0x29, 0xe2, 0x82, 0x71, 0x60, 0x82, 
			0x28, 0x08, 0xb9, 0x6c, 0x82, 0x46, 0x31, 0xc9, 
			0xa2, 0x48, 0x18, 0x04, 0x49, 0x23, 0x14, 0x61, 
			0x10, 0x82, 0x65, 0x20, 0x10, 0x60, 0xd9, 0xc2, 
			0x88, 0x94, 0x00, 0x0a, 0x40, 0x22, 0x32, 0xd4, 
			0x18, 0x86, 0x20, 0x48, 0x2e, 0x4b, 0x28, 0x12, 
			0xd1, 0x24, 0x4d, 0x41, 0x02, 0x29, 0x94, 0x04, 
			0x4e, 0x89, 0x06, 0x04, 0xd9, 0x28, 0x4d, 0x9b, 
			0x80, 0x01, 0x14, 0x39, 0x6d, 0x0b, 0x41, 0x86, 
			0xc2, 0x34, 0x04, 0xc9, 0x20, 0x60, 0x49, 0x34, 
			0x4a, 0x60, 0x44, 0x20, 0x01, 0x29, 0x92, 0xda, 
			0x16, 0x31, 0x13, 0xb2, 0x21, 0x5b, 0x48, 0x82, 
			0x20, 0x33, 0x31, 0x60, 0x48, 0x42, 0x98, 0x28, 
			0x06, 0x20, 0x44, 0x46, 0xa4, 0x08, 0x71, 0x8a, 
			0xb2, 0x90, 0xa2, 0x18, 0x22, 0x10, 0x36, 0x6e, 
			0xa3, 0x36, 0x2c, 0x1b, 0x23, 0x04, 0xe1, 0x44, 
			0x2c, 0xc2, 0x02, 0x90, 0x40, 0xa0, 0x89, 0x21, 
			0xc7, 0x8c, 0x08, 0x29, 0x05, 0x54, 0x82, 0x00, 
			0x8a, 0xb8, 0x91, 0x40, 0x10, 0x05, 0x20, 0x99, 
			0x31, 0xc2, 0x02, 0x31, 0x14, 0x04, 0x70, 0x63, 
			0x02, 0x6e, 0xc1, 0x48, 0x02, 0x11, 0xc4, 0x4d, 
			0xd3, 0x48, 0x21, 0x00, 0x06, 0x65, 0x0b, 0x87, 
			0x81, 0xd3, 0x36, 0x10, 0x02, 0x12, 0x40, 0x18, 
			0x06, 0x48, 0x9b, 0xb2, 0x68, 0x8b, 0xa0, 0x8d, 
			0x80, 0x38, 0x06, 0x13, 0xa0, 0x71, 0x11, 0x90, 
			0x49, 0x62, 0x20, 0x50, 0xd1, 0x32, 0x91, 0x89, 
			0xb0, 0x68, 0xd4, 0xa4, 0x4c, 0x00, 0x29, 0x2e, 
			0xe4, 0xb8, 0x90, 0x82, 0x84, 0x29, 0x14, 0x07, 
			0x45, 0x09, 0xc3, 0x85, 0xa2, 0x28, 0x4e, 0x42, 
			0x48, 0x70, 0x41, 0xa8, 0x50, 0x5b, 0x04, 0x06, 
			0x64, 0x28, 0x11, 0xa1, 0x24, 0x44, 0x93, 0x82, 
			0x65, 0xa2, 0x88, 0x40, 0x1a, 0x09, 0x4e, 0xc2, 
			0xc2, 0x80, 0x90, 0x44, 0x6d, 0x41, 0x30, 0x0a, 
			0x12, 0x91, 0x24, 0x22, 0x10, 0x22, 0x00, 0x96, 
			0x01, 0x41, 0x90, 0x89, 0xd0, 0x88, 0x6d, 0x42, 
			0xa8, 0x89, 0xd1, 0xa4, 0x11, 0x91, 0x04, 0x28, 
			0x10, 0x11, 0x65, 0x51, 0x16, 0x2a, 0x20, 0x03, 
			0x2c, 0x14, 0x42, 0x09, 0x14, 0xb4, 0x28, 0x1b, 
			0xa7, 0x25, 0x80, 0x18, 0x90, 0x5a, 0xa2, 0x69, 
			0x91, 0x86, 0x88, 0x12, 0xa8, 0x88, 0x0c, 0xb1, 
			0x6c, 0x8a, 0xa8, 0x0c, 0x60, 0x16, 0x0d, 0x0c, 
			0x98, 0x28, 0x09, 0x17, 0x80, 0x1b, 0x85, 0x29, 
			0x18, 0x96, 0x28, 0x40, 0x44, 0x21, 0xd4, 0xb2, 
			0x44, 0x5c, 0x90, 0x0c, 0xda, 0x14, 0x8a, 0x04, 
			0x04, 0x2c, 0xc4, 0x36, 0x90, 0x59, 0x30, 0x80, 
			0x90, 0x48, 0x28, 0x4b, 0xb4, 0x24, 0x11, 0x32, 
			0x8e, 0x82, 0x16, 0x64, 0x14, 0x47, 0x24, 0x14, 
			0x04, 0x05, 0x01, 0xa4, 0x10, 0x18, 0x49, 0x24, 
			0x4b, 0x42, 0x30, 0x14, 0x48, 0x2a, 0x4c, 0x02, 
			0x8d, 0xc9, 0x24, 0x2c, 0x03, 0x36, 0x8c, 0x19, 
			0x26, 0x84, 0xa0, 0x38, 0x11, 0xc2, 0x02, 0x72, 
			0xd4, 0x16, 0x82, 0x01, 0xb1, 0x61, 0x9b, 0x36, 
			0x8e, 0x52, 0x48, 0x90, 0x22, 0xc6, 0x20, 0x94, 
			0x38, 0x0e, 0xc9, 0x02, 0x86, 0x5c, 0x48, 0x89, 
			0xd2, 0x12, 0x42, 0x80, 0x26, 0x41, 0x94, 0xb6, 
			0x49, 0x60, 0xa4, 0x85, 0x4b, 0x20, 0x62, 0x02, 
			0x15, 0x68, 0x04, 0x93, 0x40, 0x19, 0xb2, 0x31, 
			0xc8, 0xc0, 0x69, 0x4c, 0x16, 0x02, 0x9a, 0x12, 
			0x64, 0x63, 0x06, 0x32, 0x04, 0x27, 0x20, 0xc8, 
			0x20, 0x4c, 0xa3, 0x46, 0x8e, 0xdc, 0x04, 0x6a, 
			0x11, 0x88, 0x68, 0x99, 0xc2, 0x11, 0x93, 0xa8, 
			0x45, 0xc9, 0xb2, 0x64, 0x58, 0x20, 0x42, 0x08, 
			0x95, 0x2d, 0x18, 0x11, 0x06, 0x0b, 0xc3, 0x89, 
			0x92, 0x12, 0x42, 0xc2, 0x28, 0x26, 0x01, 0x03, 
			0x92, 0x03, 0x34, 0x42, 0x49, 0x88, 0x90, 0x5c, 
			0x86, 0x09, 0x82, 0xa8, 0x50, 0xe2, 0xb2, 0x30, 
			0x11, 0x29, 0x04, 0xca, 0x42, 0x89, 0x60, 0x86, 
			0x61, 0x02, 0x12, 0x41, 0xc1, 0x34, 0x88, 0x11, 
			0xa9, 0x24, 0x5a, 0xc6, 0x88, 0x0a, 0x08, 0x8e, 
			0x63, 0x36, 0x4c, 0xa3, 0x18, 0x29, 0x61, 0x46, 
			0x49, 0xe0, 0x24, 0x01, 0x8a, 0xc8, 0x4c, 0xc3, 
			0x40, 0x61, 0x5c, 0xc6, 0x51, 0xa4, 0x46, 0x4e, 
			0x08, 0xa6, 0x21, 0x21, 0x93, 0x31, 0x1b, 0x88, 
			0x2d, 0x42, 0xb4, 0x91, 0x1c, 0x98, 0x05, 0x19, 
			0x88, 0x50, 0xca, 0x40, 0x2d, 0x01, 0xb2, 0x2d, 
			0x0a, 0xa1, 0x41, 0x1a, 0x18, 0x82, 0x99, 0x40, 
			0x08, 0xdc, 0xb0, 0x41, 0x4a, 0xc0, 0x10, 0x99, 
			0xb6, 0x51, 0x4b, 0x92, 0x91, 0x00, 0xc0, 0x49, 
			0xa0, 0x14, 0x11, 0x0a, 0x11, 0x24, 0x0b, 0x25, 
			0x92, 0x22, 0x99, 0x30, 0xe1, 0x26, 0x2e, 0xe3, 
			0xc6, 0x61, 0x9b, 0x06, 0x25, 0x03, 0x27, 0x6e, 
			0x22, 0x91, 0x45, 0x41, 0x48, 0x86, 0x9b, 0x16, 
			0x01, 0x23, 0x86, 0x31, 0x13, 0x00, 0x65, 0x08, 
			0xa5, 0x88, 0x08, 0x11, 0x70, 0x9c, 0x28, 0x24, 
			0x04, 0x18, 0x04, 0x23, 0x42, 0x51, 0xa3, 0x16, 
			0x6c, 0xc2, 0x46, 0x0a, 0x21, 0x98, 0x0d, 0x8c, 
			0x96, 0x05, 0x5b, 0x16, 0x46, 0xda, 0x80, 0x80, 
			0x4b, 0x30, 0x25, 0x18, 0x94, 0x31, 0xd9, 0x40, 
			0x05, 0x22, 0x90, 0x85, 0x10, 0x12, 0x8c, 0xdb, 
			0x42, 0x41, 0xa3, 0x02, 0x66, 0x11, 0x04, 0x82, 
			0x4b, 0x14, 0x68, 0xd9, 0x86, 0x31, 0x8b, 0x44, 
			0x48, 0x20, 0x06, 0x09, 0x1a, 0xc1, 0x70, 0x12, 
			0xa6, 0x0c, 0x24, 0xb3, 0x20, 0x23, 0x05, 0x52, 
			0x19, 0x94, 0x11, 0x90, 0xa6, 0x88, 0xc3, 0x04, 
			0x31, 0x19, 0x10, 0x0a, 0x0a, 0x09, 0x22, 0x19, 
			0xb7, 0x90, 0x8b, 0x16, 0x30, 0x0b, 0x05, 0x90, 
			0x66, 0x26, 0xba, 0x8a, 0xe4, 0x4c, 0xea, 0xda, 
			0x2c, 0x40, 0xe1, 0x1f, 0xdd, 0x79, 0xe4, 0x1f, 
			0xd7, 0x3c, 0xb7, 0xfc, 0xb4, 0xc5, 0x59, 0x1e, 
			0xf9, 0x1c, 0x18, 0x3a, 0xff, 0x19, 0x82, 0x4f, 
			0xcc, 0x1c, 0xca, 0xd7, 0x06, 0xf1, 0x7c, 0x57, 
			0xa3, 0x33, 0xd9, 0x9a, 0xd4, 0x4a, 0x22, 0x89, 
			0x52, 0x15, 0x7d, 0x20, 0x5e, 0x42, 0x77, 0x32, 
			0xe4, 0xcb, 0xb0, 0x6a, 0x84, 0x92, 0x97, 0x11, 
			0xfe, 0x59, 0x91, 0x89, 0x84, 0xb9, 0x23, 0x14, 
			0x81, 0xb5, 0x30, 0x7a, 0x12, 0x9a, 0x20, 0xce, 
			0xfe, 0xba, 0xbe, 0x92, 0xb0, 0x15, 0x26, 0xd2, 
			0x15, 0x67, 0x4a, 0x71, 0xb0, 0x10, 0x94, 0xbb, 
			0xb6, 0xeb, 0xdf, 0xa8, 0x91, 0xa5, 0xa4, 0x25, 
			0x8f, 0xdb, 0x19, 0x16, 0x81, 0x3e, 0x4e, 0xac, 
			0x05, 0x7b, 0xd6, 0xeb, 0x4a, 0xed, 0x14, 0x17, 
			0xad, 0xff, 0x77, 0x29, 0x91, 0x82, 0xa4, 0x00, 
			0xb5, 0x1d, 0x4f, 0x4d, 0x81, 0x43, 0xee, 0xa1, 
			0xa3, 0xba, 0x0c, 0x72, 0x7c, 0x25, 0x02, 0x34, 
			0x05, 0xce, 0x62, 0x4a, 0x22, 0xc4, 0xd0, 0x80, 
			0x3c, 0xec, 0x6e, 0xfb, 0x5b, 0x3c, 0xb1, 0xbd, 
			0xa4, 0x60, 0xb9, 0xc3, 0xed, 0x23, 0x00, 0x5a, 
			0x34, 0x75, 0xe0, 0x6d, 0xeb, 0x40, 0xf4, 0x43, 
			0x70, 0x88, 0x28, 0x42, 0x6b, 0x50, 0x88, 0x8e, 
			0xb6, 0x50, 0xd4, 0x68, 0x7c, 0xf1, 0x3a, 0x1a, 
			0xff, 0x9e, 0x83, 0xf7, 0x7f, 0x4c, 0xe2, 0xfb, 
			0xb9, 0xd4, 0x23, 0xd1, 0x9b, 0x3a, 0x5b, 0x26, 
			0x1a, 0x20, 0xa2, 0x64, 0x83, 0xad, 0xac, 0x8e, 
			0x2b, 0x61, 0xd9, 0xa8, 0x80, 0xbf, 0xf7, 0x0c, 
			0x34, 0xb2, 0x24, 0x2c, 0x3f, 0x93, 0xd2, 0x42, 
			0x3b, 0xfa, 0x87, 0xe1, 0xdb, 0xcc, 0x68, 0x50, 
			0x96, 0x2a, 0xe1, 0x8a, 0x20, 0xf6, 0x74, 0xad, 
			0x14, 0xcd, 0xb2, 0xcb, 0x5a, 0x0b, 0xe7, 0xd8, 
			0x2f, 0x09, 0xcd, 0x77, 0x63, 0xe7, 0x8a, 0x24, 
			0x5d, 0xc3, 0xff, 0x28, 0xc6, 0xfa, 0xad, 0x00, 
			0x53, 0xba, 0x64, 0x93, 0x8d, 0xa5, 0x74, 0x5a, 
			0x96, 0x41, 0x54, 0x14, 0x95, 0x09, 0x58, 0x06, 
			0x85, 0x55, 0xae, 0x09, 0xea, 0xe9, 0xd3, 0x29, 
			0x96, 0x66, 0x6c, 0xfe, 0xbd, 0x6e, 0x76, 0x5f, 
			0x0f, 0x1f, 0xe8, 0x27, 0x15, 0x97, 0xe8, 0xde, 
			0x3e, 0xc4, 0xec, 0xcc, 0x25, 0xa6, 0x97, 0x5e, 
			0xfc, 0x22, 0x81, 0x31, 0xc0, 0x19, 0xac, 0x87, 
			0x97, 0x52, 0x55, 0x06, 0xc7, 0x87, 0x5e, 0x48, 
			0x49, 0x82, 0x4d, 0xc6, 0xee, 0xe3, 0x65, 0xa7, 
			0xb1, 0xdf, 0x1d, 0x69, 0x0a, 0x0d, 0x96, 0x35, 
			0x56, 0x7e, 0x86, 0xba, 0x1e, 0xc0, 0xd4, 0x09, 
			0x53, 0xfb, 0xda, 0x37, 0xe5, 0x61, 0x25, 0x80, 
			0x83, 0x27, 0xd8, 0xff, 0xd4, 0xb3, 0x73, 0xbf, 
			0xbe, 0x58, 0x5c, 0xd4, 0xd0, 0x07, 0x3b, 0xce, 
			0x51, 0x72, 0x79, 0xb9, 0x83, 0x40, 0x75, 0x90, 
			0x4e, 0xce, 0x7c, 0xa6, 0x71, 0x23, 0x24, 0x9f, 
			0xe1, 0xc6, 0xfb, 0x84, 0x20, 0x9a, 0x43, 0x6a, 
			0xfa, 0x13, 0x33, 0xf2, 0x8a, 0xa8, 0x78, 0xdb, 
			0x00, 0x44, 0xbc, 0xa8, 0x5f, 0x90, 0x76, 0xc1, 
			0x5b, 0x40, 0xf3, 0xf4, 0x57, 0x49, 0x55, 0x3f, 
			0xfd, 0xba, 0xc5, 0xe6, 0xfa, 0xe1, 0x40, 0xfc, 
			0x18, 0xff, 0xcb, 0x7c, 0x12, 0x52, 0x90, 0x8f, 
			0x8f, 0xa2, 0xeb, 0xf6, 0xdc, 0x27, 0x8d, 0x53, 
			0x2a, 0x1c, 0xaf, 0xf6, 0x1c, 0x34, 0x36, 0xf7, 
			0xee, 0x19, 0x93, 0xf9, 0x33, 0x7c, 0x70, 0x20, 
			0xe4, 0x65, 0xdd, 0x0c, 0x44, 0xf9, 0xf1, 0x67, 
			0xe1, 0xb5, 0xb7, 0xca, 0xd4, 0x18, 0x87, 0x5f, 
			0x4c, 0x2e, 0x42, 0x38, 0x8e, 0x18, 0xa5, 0x49, 
			0xb2, 0x29, 0x62, 0x7d, 0xe6, 0x43, 0x57, 0xd5, 
			0x33, 0xd6, 0xa0, 0x77, 0x6c, 0x66, 0xea, 0x94, 
			0xe3, 0x37, 0xa6, 0x76, 0x25, 0xbe, 0x0e, 0x0c, 
			0x05, 0x93, 0x98, 0x18, 0xb0, 0xc7, 0x61, 0xd5, 
			0x10, 0x13, 0xcb, 0x89, 0x80, 0xef, 0xca, 0xa6, 
			0xe8, 0x48, 0xb4, 0xfd, 0xd3, 0xc8, 0x68, 0xbe, 
			0xdf, 0x12, 0x94, 0x44, 0x65, 0x68, 0x38, 0x5d, 
			0x0e, 0xd1, 0x2b, 0x0a, 0xd2, 0x2b, 0x4c, 0x1e, 
			0xc6, 0x97, 0xd2, 0x28, 0xe0, 0x6d, 0xdd, 0x1c, 
			0x77, 0x31, 0xaa, 0x0b, 0x2b, 0x23, 0x6d, 0xcd, 
			0x1f, 0x2f, 0x10, 0xe8, 0xba, 0x6d, 0x34, 0xd1, 
			0xf7, 0xe9, 0x26, 0x42, 0xb2, 0x76, 0x00, 0x62, 
			0x62, 0xc3, 0xe1, 0xfd, 0x0e, 0x83, 0x8f, 0xd3, 
			0xc0, 0x08, 0x6b, 0xb6, 0x26, 0x49, 0x30, 0xe9, 
			0x9e, 0x13, 0xa5, 0x6c, 0x1c, 0xff, 0x66, 0x9e, 
			0xba, 0xdd, 0xef, 0xde, 0xa0, 0x33, 0xaa, 0x82, 
			0x96, 0x45, 0xfe, 0xf7, 0x67, 0xda, 0x6d, 0x02, 
			0xbf, 0xbe, 0xb1, 0x84, 0xbe, 0x40, 0xe7, 0xdb, 
			0xc6, 0x8f, 0xd8, 0x95, 0x3a, 0xf0, 0x9e, 0xc6, 
			0xe9, 0xcc, 0x03, 0x2d, 0x2a, 0x1f, 0x7f, 0x1f, 
			0xd1, 0x4a, 0x2f, 0xc7, 0x29, 0xe9, 0xad, 0x69, 
			0x70, 0x6a, 0xe9, 0x52, 0x97, 0xa2, 0x1c, 0x21, 
			0xfc, 0xc8, 0x9e, 0x67, 0xce, 0x69, 0x9b, 0x07, 
			0x7c, 0x74, 0x80, 0x1e, 0xb4, 0xc2, 0x00, 0x0d, 
			0x2d, 0xb8, 0x03, 0xd1, 0x39, 0x02, 0x5f, 0x5a, 
			0x89, 0x8a, 0x77, 0xad, 0x3a, 0x2d, 0x47, 0x6c, 
			0x1d, 0xf5, 0x6c, 0x3b, 0x81, 0x92, 0x54, 0xd4, 
			0xcf, 0x22, 0xcd, 0xa3, 0x58, 0xe4, 0x60, 0x71, 
			0x4f, 0xb4, 0x05, 0x80, 0xd0, 0x43, 0x66, 0xfb, 
			0xde, 0x3f, 0x8e, 0x14, 0x2d, 0xad, 0x7b, 0xfe, 
			0x09, 0x81, 0xc4, 0xeb, 0x11, 0x48, 0x31, 0x6c, 
			0xdc, 0x8a, 0x53, 0xd4, 0x6b, 0x81, 0x17, 0xd5, 
			0x77, 0x6f, 0x50, 0xa9, 0x68, 0xac, 0x30, 0x38, 
			0x4f, 0x6f, 0xe8, 0xd2, 0x00, 0x6d, 0xf9, 0x5e, 
			0x3b, 0xf2, 0x5f, 0x7a, 0x5f, 0x9d, 0xce, 0x3d, 
			0xc4, 0xa1, 0xd5, 0x1b, 0xa4, 0xef, 0x5a, 0xa5, 
			0x2a, 0x75, 0x65, 0x55, 0x24, 0x62, 0x88, 0x67, 
			0x87, 0xad, 0xde, 0x85, 0xf0, 0x05, 0x94, 0x6a, 
			0x10, 0xb7, 0x0f, 0x2f, 0xef, 0xea, 0xf2, 0xd1, 
			0xaa, 0xba, 0xce, 0xef, 0x70, 0x0d, 0x74, 0xbd, 
			0x3c, 0xd1, 0xfa, 0x1d, 0xa2, 0x83, 0xc8, 0x80, 
			0x8a, 0x3f, 0x6d, 0x64, 0x96, 0x88, 0xd7, 0x68, 
			0x88, 0x9a, 0x58, 0x96, 0x01, 0x78, 0x3f, 0x34, 
			0xc9, 0xab, 0xa2, 0xf7, 0x3c, 0xe5, 0xd9, 0x23, 
			0x66, 0x8e, 0x9b, 0xca, 0x76, 0xf9, 0x5c, 0xea, 
			0x09, 0x44, 0xf0, 0x3b, 0x84, 0xe7, 0x78, 0xfa, 
			0xfc, 0x33, 0xe3, 0x2c, 0xd2, 0x93, 0xc2, 0xdb, 
			0x17, 0x10, 0x38, 0x5b, 0xe9, 0x2d, 0xf0, 0xf3, 
			0xd4, 0x3c, 0x89, 0x25, 0x1c, 0xec, 0xc3, 0xbc, 
			0xc3, 0x02, 0x95, 0xb2, 0x6c, 0x92, 0xfc, 0x16, 
			0x1f, 0xee, 0x54, 0xf9, 0x08, 0xd4, 0x08, 0x24, 
			0xa6, 0x1b, 0x38, 0x7c, 0x0a, 0xec, 0xf9, 0xcc, 
			0x31, 0x5d, 0x9d, 0xc1, 0xc5, 0xb0, 0x21, 0xd8, 
			0x45, 0x26, 0x2e, 0x7d, 0x85, 0xc8, 0x82, 0x6c, 
			0x74, 0xe8, 0x70, 0xaa, 0x5d, 0x62, 0xba, 0xd8, 
			0xad, 0x69, 0xbd, 0xed, 0x9f, 0x12, 0x71, 0xa6, 
			0xbb, 0x58, 0xa9, 0x44, 0x6c, 0x16, 0x43, 0x86, 
			0xf1, 0xd6, 0x08, 0x70, 0x7a, 0x8e, 0xc3, 0x36, 
			0x9a, 0xe7, 0xe8, 0x03, 0x92, 0x7e, 0xa1, 0xfd, 
			0x7a, 0x01, 0x35, 0x4f, 0x43, 0x59, 0x87, 0x00, 
			0x23, 0x5b, 0xa8, 0x39, 0xa6, 0x8a, 0x07, 0x9f, 
			0x4d, 0x5a, 0xcb, 0x42, 0x9e, 0x45, 0x1c, 0x0a, 
			0x70, 0xb4, 0x01, 0xef, 0x92, 0x98, 0x2b, 0x90, 
			0xec, 0x78, 0xd6, 0x80, 0x93, 0x33, 0xa3, 0xe5, 
			0xe9, 0x42, 0x97, 0x7e, 0x51, 0x0e, 0x5e, 0xe4, 
			0x22, 0x0f, 0xfe, 0x1b, 0x2f, 0xac, 0xdd, 0x18, 
			0x0c, 0x95, 0x9b, 0xcf, 0x2d, 0xbc, 0x6f, 0xc9, 
			0xa9, 0x65, 0x54, 0x7e, 0x22, 0xa9, 0xe2, 0x4b, 
			0xe2, 0x58, 0x7b, 0xf9, 0x0f, 0xfd, 0x07, 0xd8, 
			0xdd, 0x14, 0xe3, 0xa2, 0xe5, 0xdf, 0x98, 0xc0, 
			0x2f, 0x46, 0x27, 0x01, 0xef, 0xbc, 0x71, 0x26, 
			0x41, 0x4e, 0xd0, 0x52, 0xbc, 0x82, 0x1d, 0x5c, 
			0x82, 0xee, 0x50, 0xb6, 0x6f, 0x19, 0xec, 0xc8, 
			0xf8, 0x2d, 0xd3, 0x3c, 0x17, 0x4d, 0x39, 0xcd, 
			0xec, 0xdc, 0x71, 0x01, 0x86, 0x50, 0x53, 0xa4, 
			0x94, 0xf8, 0xfb, 0x66, 0x9c, 0x9b, 0x43, 0xab, 
			0x87, 0xd6, 0x64, 0x94, 0xd7, 0x8b, 0xde, 0x09, 
			0xc9, 0xf7, 0x82, 0xa1, 0x95, 0x85, 0x7e, 0x7a, 
			0x88, 0xa5, 0xc1, 0x14, 0xb9, 0xc0, 0x07, 0x4a, 
			0x16, 0x37, 0x99, 0x41, 0x35, 0x2b, 0xc3, 0x44, 
			0xd3, 0x73, 0xb0, 0x1e, 0x6d, 0x6e, 0xfb, 0xb8, 
			0x09, 0xfd, 0x98, 0x17, 0xe0, 0xb0, 0xa4, 0x21, 
			0x2b, 0x44, 0x9c, 0xc9, 0xea, 0x56, 0xa6, 0xb6, 
			0x78, 0xb9, 0x30, 0xf9, 0x5c, 0x6a, 0xe7, 0x9d, 
			0x4b, 0x75, 0x82, 0xb9, 0x8c, 0x2e, 0xd8, 0x3d, 
			0xf2, 0xde, 0x42, 0x01, 0x15, 0xe6, 0xc7, 0xdf, 
			0x06, 0x31, 0xc1, 0x32, 0x29, 0xa7, 0x20, 0xda, 
			0xd9, 0x6a, 0x83, 0xb4, 0xb1, 0x44, 0x99, 0x20, 
			0xf9, 0x61, 0x49, 0xe9, 0x46, 0x53, 0xec, 0xc5, 
			0xf8, 0xdb, 0xd6, 0x24, 0x37, 0x52, 0xf8, 0xe6, 
			0xcd, 0x28, 0x10, 0x7d, 0x19, 0xd4, 0xb2, 0x7a, 
			0x7c, 0x48, 0x09, 0xae, 0xc6, 0x83, 0x7f, 0x4f, 
			0x6b, 0xaf, 0xe9, 0xe3, 0x68, 0x8e, 0xa3, 0x33, 
			0x45, 0x13, 0xf2, 0x57, 0xc4, 0xb4, 0x62, 0xdb, 
			0xc2, 0xb9, 0xde, 0xbf, 0x62, 0x99, 0x8a, 0xe4, 
			0x40, 0xbf, 0xfc, 0x07, 0xb7, 0xaa, 0x49, 0x68, 
			0x8b, 0x82, 0xc5, 0x95, 0xd4, 0xb3, 0x16, 0x78, 
			0x3b, 0x83, 0xfe, 0xdc, 0x52, 0x00, 0xaa, 0x31, 
			0x58, 0x5a, 0xec, 0xf5, 0x5c, 0x6e, 0xc6, 0x16, 
			0x6b, 0x22, 0xf8, 0xac, 0x59, 0x38, 0xfb, 0x75, 
			0x73, 0xe2, 0x72, 0x5c, 0x0a, 0xa0, 0x35, 0x26, 
			0x0f, 0x37, 0x72, 0xa9, 0xe3, 0x27, 0x34, 0x3a, 
			0x14, 0xcd, 0xfc, 0x57, 0xf4, 0x27, 0xe3, 0x33, 
			0xf1, 0xca, 0x95, 0x08, 0xd3, 0x72, 0x96, 0x82, 
			0x19, 0xe5, 0x4b, 0xc0, 0xc6, 0x14, 0x04, 0x7a, 
			0x63, 0x57, 0xe2, 0x67, 0xd6, 0xab, 0x4d, 0x59, 
			0xde, 0xf2, 0xae, 0xb6, 0x6f, 0x80, 0x44, 0xb0, 
			0xd7, 0xa2, 0x6e, 0xb3, 0x15, 0xe8, 0xca, 0xb5, 
			0x62, 0x22, 0x1c, 0x55, 0x67, 0x8e, 0xe7, 0x36, 
			0x1e, 0x7c, 0x18, 0x22, 0x22, 0x75, 0x62, 0xf3, 
			0x1c, 0xe7, 0xdc, 0xed, 0x2d, 0x9f, 0x43, 0x7c, 
			0x8d, 0x0b, 0x93, 0x2b, 0xa9, 0x49, 0x59, 0x6c, 
			0x04, 0x47, 0xb6, 0x4f, 0xfd, 0xb4, 0x25, 0xf8, 
			0xec, 0x4e, 0xbe, 0xb0, 0x1e, 0x32, 0xf7, 0x14, 
			0x1b, 0xfb, 0x80, 0x6f, 0x31, 0x29, 0xae, 0x9a, 
			0x6a, 0xb5, 0x24, 0x1e, 0xe7, 0x62, 0x36, 0xb5, 
			0x51, 0x5c, 0xe0, 0x90, 0x6f, 0x38, 0x2b, 0x3a, 
			0x21, 0x06, 0x8c, 0x8f, 0x2f, 0x02, 0x2c, 0xfe, 
			0x95, 0x49, 0x4a, 0xd9, 0x44, 0xb5, 0xbb, 0x53, 
			0x8f, 0xd2, 0x09, 0x4b, 0x5a, 0x08, 0xd4, 0x56, 
			0x93, 0xec, 0xc3, 0xd9, 0xd0, 0x3b, 0x48, 0x70, 
			0xcc, 0x0b, 0x51, 0xcc, 0xe2, 0x87, 0xf4, 0xaa, 
			0x12, 0xe7, 0x79, 0x76, 0xa4, 0xea, 0x57, 0xf0, 
			0x03, 0x4f, 0xa0, 0x4e, 0x35, 0x13, 0x44, 0x09, 
			0x10, 0x45, 0x07, 0x12, 0x76, 0xf4, 0x89, 0xa9, 
			0xf9, 0x9b, 0xde, 0xaf, 0x8d, 0x2f, 0xef, 0xa8, 
			0x2f, 0x2e, 0x3f, 0xf8, 0xb0, 0xb9, 0xf0, 0xf0, 
			0x43, 0x0f, 0x4f, 0x51, 0xd4, 0x36, 0x88, 0x9c, 
			0x3b, 0x8a, 0x20, 0x06, 0x39, 0xf2, 0xfa, 0x41, 
			0x26, 0x72, 0xc4, 0x3e, 0x11, 0x30, 0x7a, 0xb6, 
			0x34, 0x39, 0x0a, 0x38, 0xbd, 0xa1, 0x8d, 0x67, 
			0x33, 0x82, 0xf4, 0x96, 0xd8, 0x1f, 0xba, 0x52, 
			0xbf, 0xf4, 0xfa, 0x28, 0x91, 0x45, 0xab, 0x2c, 
			0x6e, 0xf1, 0x89, 0x6d, 0xaf, 0x09, 0x30, 0xe5, 
			0xfd, 0x8d, 0xf3, 0x93, 0xc2, 0x6b, 0x7e, 0x95, 
			0x7d, 0xef, 0x34, 0x10, 0xe2, 0x30, 0xde, 0x7e, 
			0xbb, 0x79, 0x63, 0x96, 0x1b, 0xc9, 0x0a, 0x24, 
			0xd7, 0xc0, 0xad, 0x17, 0x99, 0x68, 0x6b, 0x06, 
			0x7c, 0x25, 0xa9, 0x7f, 0x2c, 0xbf, 0xcc, 0xd7, 
			0x8f, 0x43, 0x6e, 0x68, 0x61, 0xf2, 0x70, 0x63, 
			0x5a, 0x01, 0x77, 0xb3, 0x92, 0x8e, 0xb0, 0x97, 
			0xb4, 0x63, 0x43, 0x2e, 0x7b, 0x02, 0x50, 0x5a, 
			0x58, 0x95, 0x49, 0xb6, 0x04, 0xb1, 0x53, 0xda, 
			0xef, 0xc2, 0x78, 0xbe, 0x24, 0x7c, 0xb0, 0xfd, 
			0xc5, 0xc2, 0x02, 0x66, 0x8e, 0x38, 0x88, 0x11, 
			0xba, 0xc1, 0x8c, 0x54, 0x41, 0xa9, 0x09, 0xee, 
			},
		.msg = {
			0x6d, 0xb3, 0x8e, 0x80, 0xaf, 0x5f, 0x19, 0xd9, 
			0xb0, 0xcf, 0xad, 0x58, 0xc7, 0x27, 0xae, 0x12, 
			0x4e, 0x7d, 0xa3, 0x1a, 0xe3, 0x85, 0xc6, 0xaa, 
			0xf6, 0xa1, 0x9a, 0xb1, 0xe9, 0xe0, 0xfe, 0x89, 
			0x1e, 0xc5, 0x6f, 0x10, 0x18, 0x24, 0xab, 0xa8, 
			0x6d, 0x03, 0xd0, 0x3d, 0xc3, 0xff, 0x67, 0xe7, 
			0x3a, 0x95, 0x94, 0xc8, 0x49, 0x51, 0x8f, 0xa0, 
			0x65, 0xcb, 0x20, 0x29, 0x2a, 0x6d, 0xf7, 0xf2, 
			},
		.sig = {
			0x5e, 0x05, 0x37, 0xe2, 0xc1, 0x20, 0xce, 0x7b, 
			0x8a, 0xdf, 0xf2, 0x22, 0x61, 0x17, 0x58, 0xaa, 
			0x3c, 0xe4, 0x82, 0x9c, 0x0e, 0xb6, 0x1f, 0xb4, 
			0x98, 0x0f, 0xba, 0x8e, 0x51, 0x15, 0x67, 0x76, 
			0x0b, 0x98, 0x63, 0xda, 0x17, 0xd3, 0xbb, 0xbe, 
			0x16, 0x29, 0x71, 0xab, 0xba, 0x99, 0xed, 0x3f, 
			0xd4, 0xc2, 0x16, 0x71, 0xb6, 0x21, 0x87, 0x48, 
			0xaa, 0xb5, 0x39, 0x5e, 0xfb, 0x5d, 0x68, 0x3b, 
			0xd3, 0x60, 0xf4, 0x5b, 0x85, 0x2a, 0x5b, 0xb5, 
			0xce, 0x6e, 0xf3, 0x39, 0xc3, 0xbe, 0x96, 0xa7, 
			0x61, 0xc9, 0xbf, 0xdf, 0x33, 0x1d, 0xec, 0xb9, 
			0x2b, 0x7a, 0x05, 0xce, 0x1e, 0xd9, 0x46, 0x70, 
			0xca, 0x54, 0xbf, 0xdc, 0x46, 0x9e, 0x2f, 0x29, 
			0x18, 0x57, 0x96, 0x84, 0xac, 0xe9, 0xd7, 0x74, 
			0xeb, 0x8e, 0x6b, 0xec, 0x46, 0x9a, 0x2a, 0xfa, 
			0xde, 0x80, 0x09, 0x53, 0xd9, 0xeb, 0x9d, 0xf7, 
			0xaa, 0xe2, 0xe5, 0xdc, 0xc3, 0xd9, 0x70, 0xe5, 
			0x8b, 0xa8, 0xba, 0x2b, 0x41, 0x72, 0x92, 0x25, 
			0xaf, 0xd9, 0xb4, 0x5a, 0x53, 0xb7, 0xcc, 0x1d, 
			0x69, 0xf1, 0x53, 0x5b, 0x52, 0x38, 0xbc, 0x47, 
			0x24, 0x8c, 0x1d, 0x28, 0x5d, 0x5c, 0x1c, 0xc9, 
			0x9d, 0xea, 0x1c, 0xb1, 0xb3, 0x49, 0x68, 0xd5, 
			0xad, 0xdc, 0x47, 0x58, 0x6d, 0x38, 0x33, 0xe7, 
			0x9b, 0xaa, 0x89, 0xb1, 0x96, 0x0b, 0xcb, 0xc4, 
			0x24, 0x73, 0xf2, 0xe7, 0xb6, 0xca, 0x74, 0x55, 
			0x1b, 0xb5, 0xb7, 0x9e, 0x2e, 0xe3, 0x3a, 0x32, 
			0x5d, 0x1d, 0x6e, 0x15, 0xe6, 0xb8, 0xfb, 0xce, 
			0x57, 0x81, 0x15, 0xb5, 0xcf, 0x67, 0x2b, 0x55, 
			0x4c, 0x85, 0x6f, 0x28, 0xa6, 0xbb, 0xb4, 0x28, 
			0x76, 0x91, 0xa4, 0x29, 0xa1, 0x50, 0x7c, 0xed, 
			0x9a, 0xfc, 0xe4, 0xbc, 0xd7, 0x28, 0x62, 0x28, 
			0x61, 0x4d, 0x8d, 0x8c, 0x5a, 0x5e, 0x4d, 0x1d, 
			0x5e, 0x73, 0xcc, 0x0b, 0x9d, 0x56, 0x73, 0xc7, 
			0xf2, 0x26, 0xf7, 0x7e, 0x61, 0xa4, 0x86, 0xf5, 
			0x1c, 0xd1, 0x00, 0xd0, 0x31, 0xc5, 0x03, 0x17, 
			0x1c, 0xec, 0x04, 0xe5, 0xc7, 0x13, 0xb6, 0x81, 
			0x78, 0x3d, 0x27, 0x87, 0x36, 0xf3, 0x2a, 0x59, 
			0x96, 0xeb, 0x44, 0xfd, 0xb9, 0x95, 0xb7, 0x76, 
			0xb1, 0x08, 0xc4, 0x98, 0xb1, 0x08, 0x36, 0x2a, 
			0x63, 0x72, 0x4f, 0xef, 0x47, 0xfc, 0x84, 0x09, 
			0x18, 0x60, 0xb7, 0x8a, 0xff, 0xae, 0x32, 0x3c, 
			0x79, 0xdf, 0xd6, 0x24, 0xbe, 0x9c, 0x38, 0x68, 
			0x92, 0xde, 0x81, 0x80, 0x22, 0x06, 0xf2, 0xe4, 
			0xde, 0x75, 0x4e, 0xd6, 0x36, 0x93, 0x44, 0xd1, 
			0xa4, 0x2e, 0x2e, 0x05, 0x87, 0xbd, 0xf7, 0xc5, 
			0xc8, 0x1c, 0x7b, 0x00, 0xe8, 0x11, 0x7f, 0xc2, 
			0x39, 0x4b, 0x7b, 0x97, 0x11, 0x92, 0x6c, 0xff, 
			0x89, 0x7f, 0x26, 0x89, 0x4f, 0x38, 0xfd, 0xdd, 
			0x08, 0xa7, 0xce, 0x6f, 0xe8, 0x57, 0x9b, 0x46, 
			0xe5, 0xdb, 0x72, 0x03, 0x1e, 0x7d, 0xb0, 0x77, 
			0xb9, 0xcc, 0xdb, 0x6c, 0xa7, 0xd8, 0x30, 0x34, 
			0xad, 0xa7, 0xe4, 0x63, 0xf0, 0x19, 0x0e, 0x5d, 
			0x3b, 0xe0, 0xff, 0x40, 0x1c, 0xa5, 0xb3, 0xb9, 
			0x87, 0x6e, 0x2c, 0xf3, 0x5f, 0xcd, 0x54, 0x2a, 
			0xc0, 0x6e, 0x2b, 0xd9, 0x2d, 0xcc, 0xd5, 0x68, 
			0x95, 0x4a, 0x4a, 0x84, 0x60, 0x54, 0xee, 0xa0, 
			0x21, 0x9e, 0x8d, 0x20, 0xcb, 0xe8, 0xc5, 0x5a, 
			0xba, 0xe2, 0xaa, 0x6e, 0x1c, 0xb1, 0xdf, 0x18, 
			0x9f, 0x94, 0xc7, 0x77, 0x5a, 0x2c, 0x0e, 0x05, 
			0xaa, 0x2a, 0x54, 0x58, 0x6c, 0xb3, 0x2e, 0x2f, 
			0xa4, 0x6e, 0x98, 0xbb, 0x6f, 0x41, 0x6d, 0xbd, 
			0x71, 0x95, 0xe4, 0xbc, 0x13, 0x37, 0x99, 0x0d, 
			0xac, 0x27, 0x69, 0xb9, 0x0b, 0x14, 0x5f, 0x6e, 
			0xd2, 0x2b, 0xe2, 0x0c, 0xc6, 0xbc, 0x10, 0x11, 
			0x47, 0xb7, 0x37, 0x2c, 0x0e, 0x88, 0xcd, 0xbb, 
			0xf7, 0x28, 0xd6, 0x4a, 0x9d, 0xff, 0x3c, 0x2f, 
			0x7d, 0x2b, 0xe8, 0xe8, 0x9e, 0xae, 0x7b, 0xe6, 
			0x2a, 0xb3, 0x4e, 0x20, 0xcc, 0xf1, 0x81, 0x8e, 
			0xed, 0x6d, 0xe2, 0x99, 0xf5, 0xb5, 0x1a, 0x30, 
			0x95, 0x52, 0x34, 0xf5, 0x3f, 0xc3, 0x31, 0xd6, 
			0xbe, 0xa2, 0xc8, 0xdc, 0xe4, 0x1c, 0xf6, 0x0f, 
			0x4d, 0x0b, 0x89, 0x8e, 0x66, 0x93, 0x88, 0xb8, 
			0xad, 0xbc, 0xdc, 0x96, 0x01, 0x9f, 0x16, 0x70, 
			0xf5, 0x4f, 0xa4, 0x0e, 0x0f, 0xc3, 0xf6, 0x9c, 
			0xe1, 0xa1, 0xe3, 0xec, 0x9d, 0x09, 0xcd, 0x90, 
			0x52, 0x26, 0x09, 0xd9, 0x9c, 0xde, 0xbd, 0xdf, 
			0xbb, 0xf4, 0x50, 0xd1, 0x89, 0x68, 0xf6, 0x86, 
			0x53, 0x33, 0x5a, 0xf6, 0x54, 0xb5, 0x7c, 0xe1, 
			0xd7, 0x8d, 0xb8, 0x58, 0xf5, 0xda, 0x14, 0xc8, 
			0x35, 0x1c, 0xcf, 0x44, 0x62, 0xbc, 0xd7, 0xe3, 
			0xd8, 0x32, 0xcf, 0x16, 0xf5, 0x2f, 0x55, 0x23, 
			0xc0, 0x1b, 0xc4, 0xe3, 0x28, 0xc8, 0xc8, 0x97, 
			0x70, 0x8b, 0x06, 0x98, 0xfb, 0xf6, 0x33, 0x6b, 
			0x86, 0x1c, 0xdb, 0x2a, 0x3c, 0x08, 0x08, 0x57, 
			0xd3, 0x4a, 0xf8, 0x22, 0x26, 0x78, 0x65, 0x5f, 
			0xa6, 0xf8, 0x9f, 0x22, 0x76, 0x62, 0xb0, 0x08, 
			0x68, 0x70, 0xea, 0x72, 0x57, 0x6b, 0xe7, 0xf7, 
			0xc6, 0x12, 0x9a, 0x49, 0x50, 0xa9, 0xa5, 0x6c, 
			0xe7, 0xda, 0xb4, 0xbf, 0xb6, 0xbf, 0x4f, 0xdf, 
			0x9e, 0x9b, 0xb4, 0xb3, 0x8d, 0x1a, 0x12, 0x16, 
			0x68, 0xd2, 0x63, 0xae, 0x92, 0x77, 0x1f, 0x03, 
			0xa5, 0xed, 0x58, 0x3b, 0xe9, 0x0b, 0xfe, 0xfc, 
			0xae, 0x53, 0x0b, 0x5f, 0x13, 0xf2, 0xd2, 0xe2, 
			0x0b, 0xec, 0x75, 0x85, 0x68, 0x0c, 0x57, 0xde, 
			0x1b, 0x6d, 0x78, 0x0b, 0x19, 0x66, 0xa8, 0xf5, 
			0x45, 0x72, 0x2b, 0x01, 0x06, 0xf6, 0xd1, 0x47, 
			0x21, 0x24, 0x07, 0xf7, 0x71, 0x03, 0xbc, 0xb0, 
			0x7c, 0x5b, 0x5c, 0x24, 0xff, 0x74, 0x47, 0x62, 
			0x81, 0xc3, 0x0b, 0x31, 0x76, 0x90, 0x5b, 0xef, 
			0x95, 0xa8, 0xa7, 0x02, 0xa1, 0xbf, 0xe1, 0xf4, 
			0x16, 0x06, 0x8a, 0x97, 0x39, 0x35, 0xcf, 0xf3, 
			0xa7, 0x4a, 0x43, 0xba, 0x05, 0x95, 0x7d, 0x73, 
			0x76, 0x7a, 0x53, 0xef, 0xf8, 0x4e, 0xcb, 0x04, 
			0x70, 0x4c, 0xee, 0xff, 0x82, 0xbd, 0xcd, 0xc1, 
			0xbe, 0x3d, 0x83, 0x71, 0x03, 0xf0, 0xc0, 0x2b, 
			0x98, 0xf9, 0x60, 0x54, 0x02, 0x7d, 0xa6, 0x41, 
			0xcc, 0xa3, 0xd7, 0x8d, 0xfd, 0xce, 0x28, 0xae, 
			0x0f, 0x48, 0x17, 0x2a, 0xaf, 0xe9, 0xb9, 0x4a, 
			0x8a, 0x22, 0xd2, 0x4d, 0xd3, 0x1b, 0xa3, 0x39, 
			0x88, 0x8a, 0x8f, 0x5b, 0x44, 0x97, 0xb9, 0x04, 
			0x1b, 0x58, 0x67, 0x74, 0x2f, 0x07, 0x7a, 0x52, 
			0xa9, 0x9d, 0xa4, 0x41, 0x28, 0xf2, 0x35, 0xca, 
			0x68, 0x4e, 0x4a, 0x3a, 0x66, 0xb9, 0x88, 0x2e, 
			0x65, 0x1d, 0x47, 0x04, 0xed, 0xdb, 0xe1, 0x40, 
			0x12, 0x06, 0x13, 0x62, 0x28, 0x3d, 0x0b, 0x35, 
			0x06, 0xc6, 0x2b, 0xb3, 0x71, 0x3c, 0xfa, 0x77, 
			0xec, 0x47, 0x93, 0x78, 0x36, 0x25, 0x19, 0xd7, 
			0x70, 0x30, 0x8a, 0x4c, 0x94, 0xdc, 0x3e, 0xeb, 
			0x61, 0x25, 0xbc, 0xa0, 0x27, 0xd9, 0x17, 0xa5, 
			0x19, 0x4f, 0xf4, 0x93, 0x32, 0x56, 0x9a, 0x0b, 
			0x77, 0xb4, 0x55, 0x1b, 0x8f, 0x9e, 0x69, 0x5b, 
			0xe2, 0x6d, 0x70, 0x15, 0x79, 0x5c, 0xf6, 0xb6, 
			0x04, 0xa2, 0x01, 0x37, 0x74, 0x20, 0xb8, 0x62, 
			0xf6, 0x37, 0x3c, 0xab, 0xca, 0x71, 0xa5, 0x8a, 
			0x56, 0x5d, 0x6a, 0x4a, 0x61, 0x2e, 0xb8, 0x62, 
			0x7d, 0x47, 0x34, 0x7d, 0xcd, 0x4d, 0x70, 0x23, 
			0xf5, 0xaa, 0xd1, 0xa5, 0xf0, 0x4c, 0x38, 0xc3, 
			0x98, 0x79, 0x4c, 0x0b, 0x6b, 0xcc, 0xe7, 0xd7, 
			0x09, 0xae, 0x23, 0x9b, 0x2f, 0xde, 0x70, 0xc6, 
			0xad, 0x0f, 0x66, 0xb5, 0x78, 0x6b, 0x0b, 0xb0, 
			0x2e, 0x94, 0xf2, 0xa8, 0x8b, 0x74, 0xf0, 0x03, 
			0x47, 0xd8, 0xec, 0xe8, 0x1f, 0xa3, 0x7b, 0x38, 
			0x9e, 0x0e, 0xc0, 0x47, 0xd2, 0x0f, 0x8e, 0x7f, 
			0xb1, 0x83, 0xd3, 0x86, 0x79, 0x3c, 0xa1, 0xae, 
			0xc4, 0xaf, 0xae, 0x9d, 0x83, 0xc0, 0xd1, 0x2b, 
			0x2b, 0xda, 0x50, 0x8c, 0xea, 0x41, 0x97, 0x9b, 
			0x0f, 0x15, 0xc2, 0xe2, 0x8f, 0x39, 0x0b, 0x92, 
			0xdd, 0xde, 0x52, 0x62, 0x74, 0xdc, 0xda, 0x11, 
			0x87, 0x4d, 0xa9, 0x4a, 0xc5, 0x2f, 0xae, 0xaf, 
			0xc1, 0xc3, 0x05, 0xfa, 0x38, 0xcc, 0x5c, 0xb1, 
			0x9f, 0xe0, 0x82, 0x90, 0xb3, 0xd5, 0xdc, 0xf4, 
			0x55, 0xdb, 0xea, 0x94, 0x06, 0x7c, 0x2c, 0x82, 
			0x78, 0xeb, 0xa5, 0x01, 0xf0, 0x3d, 0x4b, 0x87, 
			0xdd, 0xd5, 0x91, 0x4f, 0xf3, 0xa7, 0xdf, 0xa1, 
			0xd8, 0x31, 0xde, 0x05, 0x99, 0x67, 0x3d, 0xa4, 
			0x6b, 0x19, 0xa3, 0xe8, 0x55, 0xb7, 0xf5, 0xc3, 
			0x63, 0x5e, 0xd4, 0x38, 0xf9, 0x24, 0x64, 0x7d, 
			0x17, 0xc1, 0x07, 0xbe, 0x39, 0x54, 0x1b, 0x44, 
			0xe5, 0xc6, 0x3c, 0x02, 0xb1, 0x6f, 0xff, 0x8c, 
			0xcb, 0x79, 0xe2, 0xec, 0x4d, 0x01, 0xfa, 0x7f, 
			0x88, 0x1d, 0xc3, 0x4c, 0x6a, 0xfb, 0x0b, 0xc6, 
			0x57, 0xc3, 0xd8, 0x24, 0x47, 0x41, 0xbd, 0x27, 
			0xc4, 0xd4, 0x49, 0xfb, 0x52, 0xe6, 0x77, 0x5f, 
			0x0a, 0xdf, 0xea, 0xd5, 0xd3, 0x22, 0xc3, 0x53, 
			0x16, 0xf3, 0x1b, 0x7b, 0x09, 0xd7, 0x10, 0x0e, 
			0x23, 0xae, 0x16, 0x8a, 0x93, 0xcb, 0xc9, 0xb7, 
			0xb8, 0xff, 0xd2, 0x50, 0x1f, 0x25, 0xa7, 0x71, 
			0x8f, 0x3f, 0xc0, 0xe1, 0x37, 0x10, 0x0b, 0x43, 
			0x6e, 0x2b, 0x16, 0x59, 0x8f, 0x77, 0x77, 0x6b, 
			0x77, 0xce, 0x76, 0x6b, 0x37, 0x81, 0xaf, 0x83, 
			0x42, 0x92, 0x93, 0xe5, 0x39, 0xca, 0xd2, 0x20, 
			0x2e, 0xcf, 0x24, 0x26, 0x4c, 0x51, 0x1c, 0x58, 
			0xc5, 0x8d, 0x05, 0x11, 0xdf, 0xae, 0x51, 0x38, 
			0xde, 0xab, 0x4e, 0x04, 0xc8, 0x24, 0x24, 0x0d, 
			0xd5, 0x9c, 0x5b, 0x2b, 0xe6, 0x0d, 0x83, 0x95, 
			0xcd, 0x1c, 0x89, 0xa1, 0xaf, 0x67, 0x47, 0xfb, 
			0x08, 0x02, 0xf8, 0x8b, 0x63, 0x05, 0x73, 0x20, 
			0x64, 0xd7, 0x52, 0x15, 0xa4, 0x5d, 0x63, 0x73, 
			0x73, 0x12, 0x0b, 0xdd, 0xfe, 0x9f, 0xb7, 0xe8, 
			0xa8, 0x94, 0x3a, 0x86, 0xff, 0xcf, 0x7d, 0x24, 
			0xbd, 0xb9, 0xea, 0x68, 0x23, 0xf4, 0x07, 0xc3, 
			0xfe, 0x63, 0xd0, 0xab, 0x65, 0x8a, 0xf0, 0x6d, 
			0x81, 0x8c, 0xc8, 0x0e, 0xc6, 0x6b, 0xdd, 0x2e, 
			0x65, 0x9b, 0x17, 0xcf, 0x82, 0x69, 0x46, 0xba, 
			0x62, 0x5d, 0x31, 0x33, 0x60, 0x18, 0x94, 0xa5, 
			0x77, 0x24, 0xc6, 0x45, 0xe5, 0xb3, 0xd5, 0x12, 
			0x10, 0xc9, 0x22, 0x98, 0xf9, 0xca, 0x20, 0x89, 
			0x79, 0x04, 0x08, 0xf5, 0x1c, 0xf8, 0x50, 0x8c, 
			0x25, 0xaa, 0x90, 0x90, 0x44, 0xbc, 0xfb, 0x5d, 
			0x3f, 0xf8, 0x38, 0x64, 0xca, 0x8d, 0xff, 0x17, 
			0xce, 0x70, 0x51, 0x90, 0x75, 0x6b, 0x7d, 0x64, 
			0x43, 0x56, 0xcd, 0xf8, 0x85, 0x93, 0x65, 0x09, 
			0x81, 0x30, 0x76, 0x79, 0xcc, 0xdf, 0x9c, 0x6d, 
			0xff, 0x89, 0x38, 0x60, 0xbf, 0x07, 0xcb, 0x2f, 
			0xc9, 0x87, 0xd7, 0xac, 0x74, 0x19, 0x57, 0x90, 
			0x5e, 0x69, 0x61, 0xf6, 0xca, 0xea, 0x45, 0x6b, 
			0xe2, 0xfe, 0x2c, 0xff, 0x1b, 0x23, 0x15, 0x52, 
			0xdd, 0x57, 0xfe, 0x1d, 0x10, 0xea, 0x0f, 0xce, 
			0x98, 0xe7, 0x47, 0x27, 0xec, 0x36, 0xe5, 0x68, 
			0x17, 0xcf, 0xdc, 0xb9, 0xef, 0x6a, 0xbc, 0xec, 
			0x78, 0x08, 0x64, 0x06, 0xe1, 0x1c, 0xc6, 0x87, 
			0xd6, 0x0a, 0xb1, 0x81, 0xc6, 0xb6, 0xf8, 0x8b, 
			0xe3, 0x19, 0x8c, 0xce, 0x46, 0x40, 0xc5, 0xc2, 
			0xae, 0x50, 0x26, 0x4a, 0x90, 0x91, 0x8d, 0xfe, 
			0x6b, 0x7d, 0x0a, 0x54, 0x4a, 0x4b, 0x48, 0x74, 
			0x4a, 0x37, 0x21, 0x7f, 0xdd, 0x87, 0xa3, 0x1e, 
			0xac, 0xcd, 0xf5, 0x9e, 0x75, 0xa2, 0x52, 0x63, 
			0x76, 0xca, 0x9e, 0x02, 0xeb, 0xe6, 0xa6, 0x73, 
			0xad, 0xea, 0xe8, 0x3e, 0x6f, 0x44, 0xed, 0xe8, 
			0x01, 0x29, 0x19, 0x6a, 0x20, 0x35, 0xa7, 0xf0, 
			0xf1, 0xaf, 0xc0, 0x3b, 0xb1, 0xd5, 0xe4, 0xfb, 
			0xf7, 0xd7, 0x2f, 0x33, 0x6c, 0x73, 0xfd, 0xe5, 
			0x5c, 0x63, 0xf6, 0x1c, 0x06, 0x13, 0xaf, 0xc1, 
			0x80, 0x55, 0x07, 0xae, 0x8c, 0x13, 0x74, 0xf6, 
			0xe0, 0x54, 0x15, 0xd8, 0xe0, 0xa5, 0x03, 0xcf, 
			0x22, 0xbe, 0x18, 0xef, 0x26, 0xad, 0x9c, 0x9d, 
			0x51, 0xb1, 0x3b, 0x37, 0x03, 0xbf, 0xf0, 0xc5, 
			0xcb, 0x6c, 0x5d, 0x30, 0xa9, 0x5a, 0x10, 0x90, 
			0xfa, 0xb4, 0xd4, 0x0e, 0x6b, 0x4a, 0x0a, 0x6c, 
			0x9d, 0x2e, 0x69, 0xe8, 0xec, 0x69, 0xe2, 0x50, 
			0xab, 0x2f, 0xdc, 0xff, 0xaf, 0xac, 0x65, 0xe7, 
			0xf0, 0xc1, 0x6f, 0x7c, 0x2d, 0xa1, 0xeb, 0x97, 
			0x90, 0x7c, 0x1e, 0xa8, 0x53, 0x1b, 0x87, 0xc5, 
			0xa9, 0xa1, 0xcf, 0x86, 0x7e, 0x11, 0xf8, 0xd6, 
			0x14, 0xda, 0x19, 0x81, 0x19, 0xb4, 0x45, 0x1c, 
			0x7c, 0xb9, 0x96, 0xa2, 0xac, 0x79, 0x24, 0x94, 
			0x7c, 0xb2, 0x1e, 0x83, 0xea, 0xc4, 0xb9, 0xd2, 
			0x0d, 0x4c, 0x55, 0x3d, 0x15, 0x7b, 0x65, 0xd8, 
			0xff, 0x03, 0x5d, 0xed, 0x3c, 0x94, 0x76, 0x19, 
			0x40, 0x3b, 0xcc, 0x45, 0xbe, 0x91, 0x19, 0x8c, 
			0x75, 0xe5, 0xd2, 0xbe, 0x67, 0x40, 0xb1, 0x67, 
			0x8e, 0x2a, 0x34, 0xd5, 0x99, 0xee, 0xd9, 0x4f, 
			0x89, 0x7c, 0xf0, 0xd6, 0x93, 0x59, 0x4b, 0x3a, 
			0x8d, 0xe6, 0xbd, 0xde, 0xce, 0xef, 0x8b, 0x3c, 
			0xe3, 0xf7, 0x06, 0x33, 0x27, 0x8d, 0xd9, 0x22, 
			0x1a, 0x65, 0x40, 0xfc, 0x69, 0x1b, 0x7d, 0xf0, 
			0xed, 0xe4, 0xe0, 0x7f, 0x6d, 0x23, 0xed, 0x11, 
			0xd1, 0x07, 0xb0, 0x2f, 0x8a, 0xbf, 0x51, 0x37, 
			0x22, 0x04, 0xed, 0x93, 0xea, 0x1d, 0x0b, 0x30, 
			0x15, 0x89, 0x22, 0x7a, 0x45, 0x56, 0x99, 0xc6, 
			0xac, 0xd6, 0xce, 0x61, 0xea, 0xb2, 0x59, 0xe8, 
			0xb5, 0xfc, 0x87, 0xa7, 0xfe, 0x09, 0xa2, 0x0d, 
			0x5e, 0xbe, 0xb9, 0xd4, 0x9a, 0x1b, 0x60, 0xda, 
			0xb9, 0x32, 0xf1, 0x30, 0x3e, 0xb2, 0x45, 0x6d, 
			0x55, 0x0c, 0x2c, 0x4b, 0x9a, 0xc0, 0xbb, 0x8e, 
			0xac, 0x9c, 0x95, 0x5f, 0x08, 0x88, 0xa0, 0x53, 
			0x05, 0x75, 0x8d, 0x9e, 0x9d, 0x3f, 0x0f, 0xdd, 
			0x50, 0x0d, 0xf8, 0x11, 0xbd, 0xf9, 0xfb, 0x22, 
			0x5c, 0x7b, 0x9e, 0x7c, 0x8e, 0x2f, 0x0e, 0xdb, 
			0xb8, 0x1d, 0x0c, 0x5e, 0x82, 0xf3, 0x8e, 0xec, 
			0x32, 0x1c, 0x59, 0x73, 0xa5, 0xf3, 0x5b, 0x47, 
			0x00, 0x64, 0x89, 0x68, 0x3b, 0xaf, 0xe8, 0xe2, 
			0x9b, 0xa6, 0xac, 0x2c, 0xf9, 0x2b, 0x92, 0xf3, 
			0xf0, 0x5b, 0xcc, 0x75, 0x22, 0xd5, 0xf4, 0x2b, 
			0x06, 0x96, 0xc8, 0x50, 0xee, 0xac, 0x62, 0x16, 
			0x45, 0x9e, 0xbc, 0xcc, 0x8f, 0x5a, 0x66, 0xc6, 
			0x30, 0x7c, 0xe0, 0x22, 0xcc, 0xb9, 0xda, 0x0b, 
			0x0a, 0xbd, 0x2a, 0x2e, 0x46, 0x7d, 0xb6, 0x86, 
			0x70, 0xa3, 0x16, 0x49, 0x85, 0x28, 0x7b, 0xe9, 
			0x00, 0x6b, 0xfa, 0x06, 0xb0, 0xeb, 0xbd, 0x67, 
			0x28, 0x6f, 0x27, 0xd7, 0x9c, 0x7f, 0xda, 0xec, 
			0xf4, 0x7e, 0x55, 0xe1, 0x0c, 0x29, 0x61, 0x7a, 
			0xf5, 0xb6, 0xb8, 0xa5, 0xef, 0x36, 0x6a, 0xad, 
			0x59, 0x22, 0xbd, 0x3d, 0xad, 0x86, 0xe7, 0x4c, 
			0x69, 0x26, 0x0f, 0xbf, 0x67, 0xad, 0x65, 0x32, 
			0xbd, 0x21, 0xd6, 0x59, 0x6b, 0xe3, 0xda, 0xc1, 
			0x6f, 0x82, 0x41, 0x2c, 0xaa, 0xe4, 0x8c, 0xfc, 
			0x7c, 0x61, 0x28, 0x51, 0x52, 0x3d, 0xf1, 0x84, 
			0xb5, 0x0b, 0xfd, 0x1f, 0x2a, 0x06, 0x2e, 0x30, 
			0xed, 0x63, 0x43, 0xc9, 0x83, 0x97, 0xb1, 0xd4, 
			0x80, 0x6f, 0x2c, 0x50, 0xec, 0x20, 0x95, 0x42, 
			0xa0, 0x34, 0x94, 0x1a, 0xa9, 0x5e, 0x5b, 0x59, 
			0xe3, 0x39, 0xac, 0xbd, 0x2f, 0x77, 0x36, 0x59, 
			0x9c, 0xc3, 0x3c, 0x66, 0x87, 0xf5, 0x81, 0x4b, 
			0xb0, 0x10, 0x4a, 0xe6, 0x46, 0xe7, 0xce, 0x93, 
			0x7b, 0x24, 0x6b, 0x2e, 0xc1, 0xe5, 0xaf, 0x4b, 
			0x71, 0x22, 0xad, 0x88, 0xda, 0x55, 0xcb, 0xe0, 
			0x73, 0xd1, 0x65, 0x7d, 0xa5, 0x7f, 0x36, 0xbc, 
			0x42, 0xc2, 0x78, 0x9f, 0x88, 0xe8, 0xdb, 0xff, 
			0x8a, 0x5a, 0x80, 0x34, 0x3a, 0x23, 0x4c, 0x8a, 
			0x81, 0xff, 0xbd, 0xb7, 0x88, 0xd0, 0x73, 0x07, 
			0x8a, 0x4e, 0xa7, 0x4a, 0x61, 0x0f, 0x1f, 0x1c, 
			0xe7, 0x34, 0x37, 0x1c, 0x53, 0x90, 0x3b, 0xa4, 
			0x32, 0x6c, 0x6d, 0xe8, 0x00, 0xde, 0xe0, 0x0c, 
			0x5e, 0x06, 0xef, 0xb8, 0x48, 0x2e, 0xb3, 0xda, 
			0xac, 0x92, 0x4d, 0x0d, 0x95, 0x75, 0x44, 0x01, 
			0x6f, 0x97, 0xc3, 0x29, 0x76, 0x33, 0x36, 0x9a, 
			0xae, 0xfb, 0x1b, 0x43, 0xe5, 0xb1, 0x54, 0x3a, 
			0x9c, 0x76, 0x7f, 0x76, 0x83, 0xc9, 0x9c, 0xd6, 
			0x56, 0x59, 0x83, 0xa9, 0xde, 0xd7, 0xb0, 0xf3, 
			0x34, 0x11, 0x31, 0x06, 0x8e, 0xe9, 0xd4, 0x79, 
			0xd5, 0x3d, 0x31, 0x6b, 0x59, 0xe9, 0x54, 0x69, 
			0x12, 0xfd, 0x44, 0x59, 0x4e, 0x1b, 0x3b, 0xb4, 
			0x12, 0xe9, 0xfb, 0xb0, 0xb4, 0x84, 0xb9, 0x7d, 
			0xea, 0x4f, 0xd1, 0x5f, 0xd0, 0x3e, 0xce, 0xef, 
			0x5c, 0xf7, 0xea, 0x55, 0xa0, 0x8f, 0xa8, 0xa7, 
			0x98, 0xe7, 0xa1, 0x6b, 0x3f, 0xba, 0x5a, 0x32, 
			0x4b, 0xfa, 0x31, 0xb6, 0x63, 0x86, 0x19, 0x00, 
			0xa2, 0x6d, 0x7d, 0x15, 0x56, 0x05, 0x68, 0xa3, 
			0xe0, 0xf3, 0xd4, 0x82, 0xcf, 0xeb, 0xd4, 0x1c, 
			0xd0, 0xb6, 0x14, 0x5e, 0x9e, 0x6b, 0xed, 0x7a, 
			0x02, 0x1a, 0xcd, 0x09, 0xdc, 0x26, 0x98, 0x50, 
			0x11, 0x34, 0x39, 0x50, 0x5a, 0x70, 0x79, 0x85, 
			0xca, 0xd2, 0xf2, 0x0c, 0x0d, 0x12, 0x1f, 0x2e, 
			0x41, 0x46, 0x51, 0x72, 0x75, 0x78, 0x8c, 0xa4, 
			0xaf, 0xba, 0xca, 0xd3, 0xdf, 0xea, 0xf8, 0x09, 
			0x0b, 0x36, 0x45, 0x4f, 0x77, 0x83, 0xae, 0xbc, 
			0xc5, 0xce, 0xe1, 0xf6, 0x1d, 0x1e, 0x38, 0x56, 
			0x9c, 0x9f, 0xb1, 0xbd, 0xda, 0xe7, 0xf0, 0xf4, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			0x0b, 0x1f, 0x2c, 0x38, },
		.key_hash = {
			0x2c, 0xe3, 0x4f, 0xa6, 0x39, 0xd2, 0x7a, 0x22, 
			0x9e, 0xb5, 0x37, 0x10, 0x18, 0x4d, 0xdf, 0x5f, 
			0xb8, 0xd3, 0xa4, 0xfa, 0x0e, 0x3f, 0xdb, 0x30, 
			0x61, 0x8a, 0xcf, 0xb3, 0xd1, 0xe7, 0x15, 0x18, 
			},
		.sig_hash = {
			0x16, 0x87, 0x15, 0x84, 0x3e, 0xd3, 0x9b, 0xf5, 
			0x48, 0xc9, 0x7d, 0xb3, 0xb8, 0x13, 0xca, 0x1b, 
			0x7d, 0x9f, 0x40, 0x41, 0x78, 0xa4, 0xd2, 0xc1, 
			0x4d, 0x3a, 0xf5, 0x2b, 0x44, 0x47, 0xb8, 0xc8, 
			},
	},
};
#endif
