/*
 * Copyright (C) 2024 - 2025, Stephan Mueller <smueller@chronox.de>
 *
 * License: see LICENSE file in root directory
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ALL OF
 * WHICH ARE HEREBY DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF NOT ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
/*
 * This code is derived in parts from the code distribution provided with
 * https://github.com/sphincs/sphincsplus
 *
 * That code is released under Public Domain
 * (https://creativecommons.org/share-your-work/public-domain/cc0/).
 */

#ifndef SPHINCS_FORS_H
#define SPHINCS_FORS_H

#include "sphincs_type.h"
#include "sphincs_internal.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Signs a message m, deriving the secret key from sk_seed and the FTS address.
 * Assumes m contains at least SPX_FORS_HEIGHT * SPX_FORS_TREES bits.
 */
int fors_sign_c(uint8_t sig[LC_SPX_FORS_BYTES], uint8_t pk[LC_SPX_N],
		const uint8_t m[LC_SPX_FORS_MSG_BYTES], const spx_ctx *ctx,
		const uint32_t fors_addr[8]);

/**
 * Derives the FORS public key from a signature.
 * This can be used for verification by comparing to a known public key, or to
 * subsequently verify a signature on the derived public key. The latter is the
 * typical use-case when used as an FTS below an OTS in a hypertree.
 * Assumes m contains at least SPX_FORS_HEIGHT * SPX_FORS_TREES bits.
 */
int fors_pk_from_sig_c(uint8_t pk[LC_SPX_N],
		       const uint8_t sig[LC_SPX_FORS_BYTES],
		       const uint8_t m[LC_SPX_FORS_MSG_BYTES],
		       const spx_ctx *ctx, const uint32_t fors_addr[8]);

typedef int (*fors_sign_f)(uint8_t sig[LC_SPX_FORS_BYTES], uint8_t pk[LC_SPX_N],
			   const uint8_t m[LC_SPX_FORS_MSG_BYTES],
			   const spx_ctx *ctx, const uint32_t fors_addr[8]);
typedef int (*fors_pk_from_sig_f)(uint8_t pk[LC_SPX_N],
				  const uint8_t sig[LC_SPX_FORS_BYTES],
				  const uint8_t m[LC_SPX_FORS_MSG_BYTES],
				  const spx_ctx *ctx,
				  const uint32_t fors_addr[8]);

#ifdef __cplusplus
}
#endif

#endif /* SPHINCS_FORS_H */
