#!/bin/bash
MANAGER_DB_NAME=susemanager

run_sql() {
    PGHOST= PGHOSTADDR= psql -v ON_ERROR_STOP=1 -U "$POSTGRES_USER" --no-password --no-psqlrc "$@"
}

echo "CREATE DATABASE $MANAGER_DB_NAME ENCODING = UTF8 ;" | run_sql
echo "CREATE ROLE $MANAGER_USER PASSWORD '$MANAGER_PASS' NOSUPERUSER NOCREATEDB NOCREATEROLE INHERIT LOGIN;" | run_sql
echo "GRANT ALL PRIVILEGES ON DATABASE $MANAGER_DB_NAME TO $MANAGER_USER;" | run_sql -d $MANAGER_DB_NAME
echo "ALTER DATABASE $MANAGER_DB_NAME OWNER TO $MANAGER_USER;" | run_sql -d $MANAGER_DB_NAME
echo "GRANT ALL PRIVILEGES ON SCHEMA public TO $MANAGER_USER;" | run_sql -d $MANAGER_DB_NAME
