```toml
[advisory]
id = "CVE-2021-29922"
package = "std"
date = "2020-01-31"
url = "https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-29922"
keywords = ["IpAddr", "SSRF", "RFI", "LFI"]

[versions]
patched = [">= 1.53.0"]

[affected]
[affected.functions]
"std::net::IpAddr::from_str" = ["<= 1.52.1"]
"std::net::Ipv4Addr::from_str" = ["<= 1.52.1"]
"std::net::Ipv6Addr::from_str" = ["<= 1.52.1"]
```

# Improper Input Validation of octal literals in `std::net`

Improper input validation of octal strings in rust-lang standard library `net` allows unauthenticated remote attackers to perform
indeterminate SSRF, RFI, and LFI attacks on many programs that rely on rust-lang std::net.
IP address octets are left stripped instead of evaluated as valid IP addresses.
For example, an attacker submitting an IP address to a web application that relies on `std::net::IpAddr`,
could cause SSRF via inputting octal input data;
An attacker can submit exploitable IP addresses if the octet is 3 digits,
with the minimum exploitable octet being 08 (Denial of Service) and the maximum exploitable octet is 099 (Denial of Service).
For example, an attacker can submit `010.8.8.8`, which is `8.8.8.8` (RFI), yet `std::net::IpAddr` will evaluate this as `10.8.8.8`.
Equally, an attacker can input `127.0.026.1` which is really `127.0.22.1` but rust evaluates it as `127.0.26.1`.
