```toml
[advisory]
id = "RUSTSEC-2022-0082"
package = "warp"
date = "2022-01-14"
url = "https://github.com/seanmonstar/warp/issues/937"
categories = ["file-disclosure"]
keywords = ["directory traversal", "http"]
aliases = ["GHSA-8v4j-7jgf-5rg9"]

[affected]
os = ["windows"]

[versions]
patched = [">= 0.3.3"]
```

# Improper validation of Windows paths could lead to directory traversal attack

Path resolution in `warp::filters::fs::dir` didn't correctly validate Windows paths
meaning paths like `/foo/bar/c:/windows/web/screen/img101.png` would be allowed
and respond with the contents of `c:/windows/web/screen/img101.png`. Thus users
could potentially read files anywhere on the filesystem.

This only impacts Windows. Linux and other unix likes are not impacted by this.
