```toml
[advisory]
id = "RUSTSEC-2024-0354"
package = "vodozemac"
date = "2024-07-17"
url = "https://github.com/matrix-org/vodozemac/security/advisories/GHSA-j8cm-g7r6-hfpq"
categories = ["crypto-failure", "memory-exposure"]
aliases = ["CVE-2024-40640", "GHSA-j8cm-g7r6-hfpq"]

[versions]
patched = [">= 0.7.0"]
```

#  Usage of non-constant time base64 decoder could lead to leakage of secret key material 

Versions before 0.7.0 of vodozemac use a non-constant time base64 implementation
for importing key material for Megolm group sessions and `PkDecryption` Ed25519
secret keys. This flaw might allow an attacker to infer some information about
the secret key material through a side-channel attack.

## Impact

The use of a non-constant time base64 implementation might allow an attacker to
observe timing variations in the encoding and decoding operations of the secret
key material. This could potentially provide insights into the underlying secret
key material.

The impact of this vulnerability is considered low because exploiting the
attacker is required to have access to high precision timing measurements, as
well as repeated access to the base64 encoding or decoding processes.
Additionally, the estimated leakage amount is bounded and low according to the
referenced paper[[1]].

[1]: https://arxiv.org/abs/2108.04600
