```toml
[advisory]
id = "RUSTSEC-2024-0002"
package = "vmm-sys-util"
date = "2024-01-02"
url = "https://github.com/advisories/GHSA-875g-mfp6-g7f9"
informational = "unsound"
categories = ["memory-corruption"]
cvss = "CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:C/C:N/I:L/A:L"
aliases = ["CVE-2023-50711", "GHSA-875g-mfp6-g7f9"]

[affected]
functions = { "vmm_sys_util::fam::FamStructWrapper::deserialize" = ["< 0.12.0, >= 0.5.0"] }

[versions]
patched = [">= 0.12.0"]
unaffected = ["< 0.5.0"]
```

# `serde` deserialization for `FamStructWrapper` lacks bound checks that could potentially lead to out-of-bounds memory access

## Impact

An issue was discovered in the `FamStructWrapper::deserialize` implementation
provided by the crate for `vmm_sys_util::fam::FamStructWrapper`, which can lead
to out of bounds memory accesses. The deserialization does not check that the
length stored in the header matches the flexible array length. Mismatch in the
lengths might allow out of bounds memory access through Rust-safe methods.

Impacted versions: >= 0.5.0

## Patches

The issue was corrected in version 0.12.0 by inserting a check that verifies
the lengths of compared flexible arrays are equal for any deserialized header
and aborting deserialization otherwise. Moreover, the API was changed so that
header length can only be modified through Rust-unsafe code. This ensures that
users cannot trigger out-of-bounds memory access from Rust-safe code.
