```toml
[advisory]
id = "RUSTSEC-2023-0080"
package = "transpose"
date = "2023-12-18"
url = "https://github.com/ejmahler/transpose/issues/11"
categories = ["memory-corruption"]
aliases = ["GHSA-5gmm-6m36-r7jh"]

[versions]
patched = [">= 0.2.3"]

[affected]
functions = { "transpose::transpose" = [">= 0.1.0"] }
```

# Buffer overflow due to integer overflow in `transpose`

Given the function `transpose::transpose`:
```rust
fn transpose<T: Copy>(input: &[T], output: &mut [T], input_width: usize, input_height: usize)
```

The safety check `input_width * input_height == output.len()` can fail due to `input_width * input_height` overflowing in such a way that it equals `output.len()`.
As a result of failing the safety check, memory past the end of `output` is written to. This only occurs in release mode since `*` panics on overflow in debug mode.

Exploiting this issue requires the caller to pass `input_width` and `input_height` arguments such that multiplying them overflows, and the overflown result equals the lengths of input and output slices.
