```toml
[advisory]
id = "RUSTSEC-2020-0090"
package = "thex"
aliases = ["CVE-2020-35927", "GHSA-j42v-6wpm-r847"]
cvss = "CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:H"
date = "2020-12-08"
categories = ["memory-corruption", "thread-safety"]
keywords = ["concurrency"]

[versions]
patched = []
```

# Thex<T> allows data races of non-Send types across threads

`thex::Thex<T>` implements `Sync` for all types `T`. However, it is missing a
bound for `T: Send`.

This allows non-Send types such as `Rc` to be sent across thread boundaries
which can trigger undefined behavior and memory corruption.
