```toml
[advisory]
id = "RUSTSEC-2021-0033"
package = "stack_dst"
aliases = ["CVE-2021-28034", "CVE-2021-28035", "GHSA-45w7-7g63-2m5w", "GHSA-8mjx-h23h-w2pg"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
date = "2021-02-22"
url = "https://github.com/thepowersgang/stack_dst-rs/issues/5"
categories = ["memory-corruption"]
keywords = ["memory-safety", "double-free"]

[versions]
patched = [">= 0.6.1"]

[affected]
functions = { "stack_dst::StackA::push_cloned" = ["< 0.6.1"] }
```

# push_cloned can drop uninitialized memory or double free on panic

Affected versions of `stack_dst` used a `push_inner` function that increased
the internal length of the array and then called `val.clone()`.

If the `val.clone()` call panics, the stack could drop an already dropped
element or drop uninitialized memory.

This issue was fixed in `2a4d538` by increasing the length of the array after
elements are cloned.
