```toml
[advisory]
id = "RUSTSEC-2019-0009"
package = "smallvec"
aliases = ["CVE-2019-15551", "GHSA-mm7v-vpv8-xfc3"]
cvss = "CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
date = "2019-06-06"
keywords = ["double free", "use after free", "arbitrary code execution"]
url = "https://github.com/servo/rust-smallvec/issues/148"

[affected.functions]
"smallvec::SmallVec::grow" = ["< 0.6.10, >= 0.6.5"]

[versions]
patched = [">= 0.6.10"]
unaffected = ["< 0.6.5"]
```

# Double-free and use-after-free in SmallVec::grow()

Attempting to call `grow` on a spilled SmallVec with a value equal to the current capacity causes it to free the existing data. This performs a double free immediately and may lead to use-after-free on subsequent accesses to the SmallVec contents.

An attacker that controls the value passed to `grow` may exploit this flaw to obtain memory contents or gain remote code execution.

Credits to @ehuss for discovering, reporting and fixing the bug.
