```toml
[advisory]
id = "RUSTSEC-2019-0022"
package = "portaudio-rs"
aliases = ["CVE-2019-16881", "GHSA-qpjr-ch72-2qq4"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
categories = ["code-execution", "memory-corruption"]
date = "2019-09-14"
keywords = ["audio", "ffi"]
url = "https://github.com/mvdnes/portaudio-rs/issues/20"

[versions]
patched = ["> 0.3.1"]
```

# Stream callback function is not unwind safe

Affected versions of this crate is not panic safe within callback functions `stream_callback` and `stream_finished_callback`.

The call to user-provided closure might panic before a `mem::forget` call, which then causes a use after free that grants attacker to control the callback function pointer.

This allows an attacker to construct an arbitrary code execution .
 
The flaw was reported by Phosphorus15.
