```toml
[advisory]
id = "RUSTSEC-2021-0152"
package = "out-reference"
date = "2021-01-20"
url = "https://github.com/RustyYato/out-ref/issues/1"
informational = "unsound"
categories = ["memory-corruption"]
keywords = ["unsound", "raw-pointer"]
aliases = ["GHSA-p7mj-xvxg-grff"]

[versions]
patched = [">= 0.2.0"]
unaffected = ["< 0.1.0"]

[affected.functions]
"out_reference::Out::from_raw" = [">= 0.1.0, < 0.2.0"]
```

# `out_reference::Out::from_raw` should be `unsafe`

`Out::from_raw` in affected versions allows writing a value to invalid memory address without requiring `unsafe`.

The soundness issue has been addressed by making `Out::from_raw` an unsafe function.
