```toml
[advisory]
id = "RUSTSEC-2022-0033"
package = "openssl-src"
aliases = ["CVE-2022-2274", "GHSA-735f-pg76-fxc4"]
categories = ["crypto-failure"]
date = "2022-07-05"
url = "https://www.openssl.org/news/secadv/20220705.txt"

[versions]
patched = [">= 300.0.9"]
unaffected = ["< 300.0.8"]
```

# Heap memory corruption with RSA private key operation

The OpenSSL 3.0.4 release introduced a serious bug in the RSA
implementation for X86_64 CPUs supporting the AVX512IFMA instructions.
This issue makes the RSA implementation with 2048 bit private keys
incorrect on such machines and memory corruption will happen during
the computation. As a consequence of the memory corruption an attacker
may be able to trigger a remote code execution on the machine performing
the computation.

SSL/TLS servers or other servers using 2048 bit RSA private keys running
on machines supporting AVX512IFMA instructions of the X86_64 architecture
are affected by this issue.

Note that on a vulnerable machine, proper testing of OpenSSL would fail and
should be noticed before deployment.
