```toml
[advisory]
id = "RUSTSEC-2022-0026"
package = "openssl-src"
aliases = ["CVE-2022-1434", "GHSA-638m-m8mh-7gw2"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:N/I:H/A:N"
categories = ["crypto-failure"]
date = "2022-05-03"
url = "https://www.openssl.org/news/secadv/20220503.txt"

[versions]
patched = [">= 300.0.6"]
unaffected = ["< 300.0"]
```

# Incorrect MAC key used in the RC4-MD5 ciphersuite

The OpenSSL 3.0 implementation of the RC4-MD5 ciphersuite incorrectly uses the
AAD data as the MAC key. This makes the MAC key trivially predictable.

An attacker could exploit this issue by performing a man-in-the-middle attack to
modify data being sent from one endpoint to an OpenSSL 3.0 recipient such that
the modified data would still pass the MAC integrity check.

Note that data sent from an OpenSSL 3.0 endpoint to a non-OpenSSL 3.0 endpoint
will always be rejected by the recipient and the connection will fail at that
point. Many application protocols require data to be sent from the client to the
server first. Therefore, in such a case, only an OpenSSL 3.0 server would be
impacted when talking to a non-OpenSSL 3.0 client.

If both endpoints are OpenSSL 3.0 then the attacker could modify data being
sent in both directions. In this case both clients and servers could be
affected, regardless of the application protocol.

Note that in the absence of an attacker this bug means that an OpenSSL 3.0
endpoint communicating with a non-OpenSSL 3.0 endpoint will fail to complete the
handshake when using this ciphersuite.

The confidentiality of data is not impacted by this issue, i.e. an attacker
cannot decrypt data that has been encrypted using this ciphersuite - they can
only modify it.

In order for this attack to work both endpoints must legitimately negotiate the
RC4-MD5 ciphersuite. This ciphersuite is not compiled by default in OpenSSL 3.0,
and is not available within the default provider or the default ciphersuite
list. This ciphersuite will never be used if TLSv1.3 has been negotiated. In
order for an OpenSSL 3.0 endpoint to use this ciphersuite the following must
have occurred:

1. OpenSSL must have been compiled with the (non-default) compile time option
   enable-weak-ssl-ciphers
2. OpenSSL must have had the legacy provider explicitly loaded (either through
   application code or via configuration)
3. The ciphersuite must have been explicitly added to the ciphersuite list
4. The libssl security level must have been set to 0 (default is 1)
5. A version of SSL/TLS below TLSv1.3 must have been negotiated
6. Both endpoints must negotiate the RC4-MD5 ciphersuite in preference to any
   others that both endpoints have in common
