```toml
[advisory]
id = "RUSTSEC-2020-0089"
package = "nanorand"
aliases = ["CVE-2020-35926", "GHSA-m9m5-cg5h-r582"]
date = "2020-12-09"
url = "https://twitter.com/aspenluxxxy/status/1336684692284772352"
categories = ["crypto-failure"]
cvss = "CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:N"
keywords = ["rng"]

[versions]
patched = [">= 0.5.1"]
```

# nanorand 0.5.0 - RNGs failed to generate properly for non-64-bit numbers

In versions of `nanorand` prior to 0.5.1, `RandomGen` implementations for standard unsigned integers could
fail to properly generate numbers, due to using bit-shifting to truncate a 64-bit number, rather than just
an `as` conversion.

This often manifested as RNGs returning nothing but 0, including the cryptographically secure `ChaCha` random
number generator..
