```toml
[advisory]
id = "RUSTSEC-2020-0004"
package = "lucet-runtime-internals"
aliases = ["CVE-2020-35859", "GHSA-3933-wvjf-pcvc"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:H"
categories = ["memory-corruption", "memory-exposure"]
date = "2020-01-24"
url = "https://github.com/bytecodealliance/lucet/pull/401"

[versions]
patched = ["< 0.5.0, >= 0.4.3", ">= 0.5.1"]
```

# sigstack allocation bug can cause memory corruption or leak

An embedding using affected versions of lucet-runtime configured to use
non-default Wasm globals sizes of more than 4KiB, or compiled in debug mode
without optimizations, could leak data from the signal handler stack to guest
programs. This can potentially cause data from the embedding host to leak to
guest programs or cause corruption of guest program memory.

This flaw was resolved by correcting the sigstack allocation logic.
