```toml
[advisory]
id = "RUSTSEC-2022-0084"
package = "libp2p"
date = "2022-07-12"
url = "https://github.com/libp2p/rust-libp2p/security/advisories/GHSA-jvgw-gccv-q5p8"
aliases = ["CVE-2022-23486", "GHSA-jvgw-gccv-q5p8"]
categories = ["denial-of-service"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"

[versions]
patched = [">= 0.45.1"]
```
# libp2p Lack of resource management DoS

libp2p allows a potential attacker to cause victim p2p node to run out of memory

The out of memory failure can cause crashes where libp2p is intended to be used
within large scale networks leading to potential Denial of Service (DoS) vector

Users should upgrade or reference the [DoS mitigation strategies](https://docs.libp2p.io/reference/dos-mitigation/).
