```toml
[advisory]
id = "RUSTSEC-2020-0137"
package = "lever"
date = "2020-11-10"
url = "https://github.com/vertexclique/lever/issues/15"
categories = ["memory-corruption", "thread-safety"]
keywords = ["concurrency"]
aliases = ["CVE-2020-36457", "GHSA-9pp4-8p8v-g78w"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H"

[versions]
patched = [">= 0.1.1"]
```

# AtomicBox<T> lacks bound on its Send and Sync traits allowing data races

`AtomicBox<T>` is a `Box` type designed to be used across threads, however, it
implements the `Send` and `Sync` traits for all types `T`.

This allows non-Send types such as `Rc` and non-Sync types such as `Cell` to
be used across thread boundaries which can trigger undefined behavior and
memory corruption.
