```toml
[advisory]
id = "RUSTSEC-2019-0014"
package = "image"
aliases = ["CVE-2019-16138", "GHSA-m2pf-hprp-3vqm"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
date = "2019-08-21"
keywords = ["drop", "use-after-free"]
url = "https://github.com/image-rs/image/pull/985"

[affected.functions]
"image::hdr::HDRDecoder::read_image_transform" = ["< 0.21.3, >= 0.10.2"]

[versions]
patched = [">= 0.21.3"]
unaffected = ["< 0.10.2"]
```

# Flaw in interface may drop uninitialized instance of arbitrary types

Affected versions of this crate would call `Vec::set_len` on an uninitialized
vector with user-provided type parameter, in an interface of the HDR image
format decoder. They would then also call other code that could panic before
initializing all instances.

This could run Drop implementations on uninitialized types, equivalent to
use-after-free, and allow an attacker arbitrary code execution.

Two different fixes were applied. It is possible to conserve the interface by
ensuring proper initialization before calling `Vec::set_len`. Drop is no longer
called in case of panic, though.

Starting from version `0.22`, a breaking change to the interface requires
callers to pre-allocate the output buffer and pass a mutable slice instead,
avoiding all unsafe code.
