```toml
[advisory]
id = "RUSTSEC-2021-0071"
package = "grep-cli"
date = "2021-06-12"
url = "https://github.com/BurntSushi/ripgrep/issues/1773"
categories = ["code-execution"]
keywords = ["windows", "ripgrep", "PATH", "arbitrary", "binary"]
aliases = ["CVE-2021-3013", "GHSA-g4xg-fxmg-vcg5"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"

[versions]
patched = [">= 0.1.6"]
unaffected = []

[affected]
os = ["windows"]
functions = { "grep_cli::DecompressionReader::new" = ["< 0.1.6"] }
```

# `grep-cli` may run arbitrary executables on Windows

On Windows in versions of `grep-cli` prior to `0.1.6`, it's possible for some
of the routines to execute arbitrary executables. In particular, a quirk of
the Windows process execution API is that it will automatically consider the
current directory before other directories when resolving relative binary
names. Therefore, if you use `grep-cli` to read decompressed files in an
untrusted directory with that directory as the CWD, a malicious actor to could
put, e.g., a `gz.exe` binary in that directory and `grep-cli` will use the
malicious actor's version of `gz.exe` instead of the system's.

This is also technically possible on Unix as well, but only if the `PATH`
variable contains `.`. Conventionally, they do not.

A `DecompressionReader` has been fixed to automatically resolve binary names
using `PATH`, instead of relying on the Windows API to do it.

If you use `grep-cli`'s `CommandReader` with a `std::process::Command` value
on Windows, then it is recommended to either construct the `Command` with an
absolute binary name, or use `grep-cli`'s new
[`resolve_binary`](https://docs.rs/grep-cli/0.1.6/grep_cli/fn.resolve_binary.html)
helper function.

To be clear, `grep-cli 0.1.6` mitigates this issue in two ways:

* A `DecompressionReader` will resolve decompression programs to absolute
paths automatically using the `PATH` environment variable, instead of relying
on Windows APIs to do it (which would result in the undesirable behavior of
checking the CWD for a program first).
* A new function, `resolve_binary`, was added to help users of this crate
mitigate this behavior when they need to create their own
`std::process::Command`. For example,
[ripgrep uses `grep_cli::resolve_binary`](https://github.com/BurntSushi/ripgrep/blob/7ce66f73cf7e76e9f2557922ac8e650eb02cf4ed/crates/core/search.rs#L119-L122)
on the argument given to its `--pre` flag.

While the first mitigation fixes this issue for sensible values of `PATH`
when doing decompression search, the second mitigation is imperfect. The more
fundamental issue is that `std::process::Command` is itself vulnerable to this.
