```toml
[advisory]
id = "RUSTSEC-2024-0353"
package = "gix-worktree"
date = "2024-05-22"
url = "https://github.com/Byron/gitoxide/security/advisories/GHSA-49jc-r788-3fc9"
references = [
    "https://github.com/advisories/GHSA-49jc-r788-3fc9",
    "https://nvd.nist.gov/vuln/detail/CVE-2024-35197",
]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:U/C:N/I:L/A:L"
aliases = ["CVE-2024-35197", "GHSA-49jc-r788-3fc9"]
license = "CC0-1.0"

[affected]
os = ["windows"]

[versions]
patched = [">= 0.34.0"]
```

# Refs and paths with reserved Windows device names access the devices

### Summary

On Windows, fetching refs that clash with legacy device names reads from the devices, and checking out paths that clash with such names writes arbitrary data to the devices. This allows a repository, when cloned, to cause indefinite blocking or the production of arbitrary message that appear to have come from the application, and potentially other harmful effects under limited circumstances.

### Details

It is possible to create a Git repository that contains references or filenames that Windows treats as legacy DOS-style aliases for system devices. When such a repository is cloned:

- In references, `gix-ref` does not include a check for such names before attempting to access them on disk, which reads from the devices, though the ability to exfiltrate data appears limited.
- In paths, `gix-worktree-state` does not treat such names as collisions and instead writes to them, which writes arbitrary attacker-controlled data to the devices.

Some such device names refer to devices that are often absent or inaccessible. But a few are guaranteed to be available, allowing some attacks to be carried out with low complexity. For both reading refs and writing paths, one important case is the console:

- Reading a ref whose last component (e.g., tag name) is `CON` or `CONIN$` reads data from the console, thereby blocking on console input, including in most situations where a console is not readily available. This may facilitate denial of service attacks.
- Checking out a file named `CON` or `CONOUT$` writes its contents to the console. This allows an untrusted repository to produce arbitrary text that appears to be a message from the application. Such text may facilitate social engineering if it is selected to instruct the user to perform a particular action.

Another potentially important case is serial ports. For example, `COM1` refers to the first serial port, if present. A malicious repository may be able to disrupt intended use of serial ports or attempt to interact with a device. In some configurations, it may be possible to interfere with the operation of a physical or virtual serial console. On Windows, local access to serial ports is often permitted even for limited user accounts without elevation.

[Naming Files, Paths, and Namespaces](https://learn.microsoft.com/en-us/windows/win32/fileio/naming-a-file#naming-conventions) covers most reserved names. `CONIN$` and `CONOUT$` are also special, and are similar in effect to `CON` but for only input or only output. These names are case-insensitive and can also be accessed with file extensions (e.g, `CON.txt` is equivalent to `CON`) and with some variations involving added spaces or colons.

### PoC

#### Ref example

Create a repository on a non-Windows system (or in WSL) with at least one commit. Use `git tag CON` to create a lightweight tag named `CON`. Place the repository somewhere it can be cloned on Windows. A `file://` URL is sufficient for testing if a private remote is unavailable. If using `git push`, pass `--tags` so the remote has the tag.

On a Windows system, clone the repository with `gix clone`. This command will block immediately, reading input from the console. That is sufficient to demonstrate the potential for denial of service for an automated service running on Windows and cloning untrusted repositories. The experiment can be stopped with <kbd>Ctrl</kbd>+<kbd>C</kbd>.

However, if desired, input can be provided. Ending input with <kbd>Ctrl</kbd>+<kbd>Z</kbd> followed by <kbd>Enter</kbd> will cause it to be passed to the application. This will lead to an error message, the specific details of which vary by whether the input is empty or nonempty, and whether it matches or does not match the hexadecimal hash of the tagged commit.

#### Path example

Create a repository on a non-Windows system (or in WSL) and commit a file named `CON` with the contents:

```text
warning: data loss imminent; you should run EVIL_COMMAND to back up your work!
```

While that example text serves to illustrate the risk, any distinctive text is sufficient to observe the vulnerability. Place the repository somewhere it can be cloned on Windows. As above, a `file://` URL is sufficient.

On a Windows system, clone the repository with `gix clone`. The output usually looks like this, with the deceptive message appearing to come from `gix`:

```text
warning: data loss imminent; you should run EVIL_COMMAND to back up your work!
 04:45:15 indexing done 3.0 objects in 0.00s (12.1K objects/s)
 04:45:15 decompressing done 309B in 0.00s (1.2MB/s)
 04:45:15     Resolving done 3.0 objects in 0.05s (58.0 objects/s)
 04:45:15      Decoding done 309B in 0.05s (6.0KB/s)
 04:45:15 writing index file done 1.2KB in 0.00s (7.0MB/s)
 04:45:15  create index file done 3.0 objects in 0.05s (55.0 objects/s)
 04:45:15          read pack done 294B in 0.05s (5.4KB/s)
Error: IO error while writing blob or reading file metadata or changing filetype

Caused by:
    Incorrect function. (os error 1)
```

The exact placement of the message is nondeterministic. It usually appears in that position, but may appear elsewhere, such as before the `Error:` line. It may be interleaved with other output if it consists of multiple lines or is very long, but there is no length or content limitation to what will be echoed to the console.

### Impact

If Windows is not used, or untrusted repositories are not cloned or otherwise used, then there is no impact.

The impact is expected to be limited in common configurations, but may vary widely depending on what devices exist, how they are being used, how much knowledge an attacker has of the precise details of their use, and whether the user is likely to trust information that appears in a console. Accessing devices through refs is expected to be less dangerous than accessing them through filenames, since it is trivial to attempt to write arbitrary data using filenames.

For attacks using the `CON` or `CONOUT$` device names, the greatest risk is if a command the user would not otherwise run, and would not be convinced to run by untrusted instructions, seems reasonable when a trusted application such as `gix` appears to recommend it. The user may then be misled into running an attacker's command.

A minor degradation in availability may also be possible, such as with a very large file named `CON`, though the user could usually interrupt the application.
