```toml
[advisory]
id = "RUSTSEC-2017-0005"
package = "cookie"
aliases = ["CVE-2017-18589", "GHSA-vjrq-cg9x-rfjp"]
cvss = "CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"
date = "2017-05-06"
keywords = ["crash"]
url = "https://github.com/alexcrichton/cookie-rs/pull/86"

[versions]
patched = ["< 0.6.0", "^0.6.2", ">= 0.7.6"]
```

# Large cookie Max-Age values can cause a denial of service

Affected versions of this crate use the `time` crate and the method
`Duration::seconds` to parse the `Max-Age` duration cookie setting. This method
will panic if the value is greater than 2^64/1000 and less than or equal to
2^64, which can result in denial of service for a client or server.

This flaw was corrected by explicitly checking for the `Max-Age` being in this
integer range and clamping the value to the maximum duration value.
