/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class Copy
extends Task {
    protected File file = null;
    protected File destFile = null;
    protected File destDir = null;
    protected Vector filesets = new Vector();
    protected boolean filtering = false;
    protected boolean forceOverwrite = false;
    protected boolean flatten = false;
    protected int verbosity = 3;
    protected boolean includeEmpty = true;
    protected Hashtable fileCopyMap = new Hashtable();
    protected Hashtable dirCopyMap = new Hashtable();

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    protected void doFileOperations() {
        Enumeration<Object> e;
        if (this.fileCopyMap.size() > 0) {
            this.log("Copying " + this.fileCopyMap.size() + " file" + (this.fileCopyMap.size() == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath());
            e = this.fileCopyMap.keys();
            while (e.hasMoreElements()) {
                String fromFile = (String)e.nextElement();
                String toFile = (String)this.fileCopyMap.get(fromFile);
                try {
                    this.log("Copying " + fromFile + " to " + toFile, this.verbosity);
                    this.project.copyFile(fromFile, toFile, this.filtering, this.forceOverwrite);
                }
                catch (IOException ioe) {
                    String msg = "Failed to copy " + fromFile + " to " + toFile + " due to " + ioe.getMessage();
                    throw new BuildException(msg, ioe, this.location);
                }
            }
        }
        if (this.includeEmpty) {
            e = this.dirCopyMap.elements();
            int count = 0;
            while (e.hasMoreElements()) {
                File d = new File((String)e.nextElement());
                if (d.exists()) continue;
                if (!d.mkdirs()) {
                    this.log("Unable to create directory " + d.getAbsolutePath(), 0);
                    continue;
                }
                ++count;
            }
            if (count > 0) {
                this.log("Copied " + count + " empty directories to " + this.destDir.getAbsolutePath());
            }
        }
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        if (this.file != null) {
            if (this.file.exists()) {
                if (this.destFile == null) {
                    this.destFile = new File(this.destDir, this.file.getName());
                }
                if (this.forceOverwrite || this.file.lastModified() > this.destFile.lastModified()) {
                    this.fileCopyMap.put(this.file.getAbsolutePath(), this.destFile.getAbsolutePath());
                }
            } else {
                this.log("Could not find file " + this.file.getAbsolutePath() + " to copy.");
            }
        }
        int i = 0;
        while (i < this.filesets.size()) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.project);
            File fromDir = fs.getDir(this.project);
            String[] srcFiles = ds.getIncludedFiles();
            String[] srcDirs = ds.getIncludedDirectories();
            this.scan(fromDir, this.destDir, srcFiles, srcDirs);
            ++i;
        }
        this.doFileOperations();
        if (this.destFile != null) {
            this.destDir = null;
        }
    }

    protected void scan(File fromDir, File toDir, String[] files, String[] dirs) {
        int i = 0;
        while (i < files.length) {
            String filename = files[i];
            File src = new File(fromDir, filename);
            File dest = this.flatten ? new File(toDir, new File(filename).getName()) : new File(toDir, filename);
            if (this.forceOverwrite || src.lastModified() > dest.lastModified()) {
                this.fileCopyMap.put(src.getAbsolutePath(), dest.getAbsolutePath());
            }
            ++i;
        }
        if (this.includeEmpty) {
            int i2 = 0;
            while (i2 < dirs.length) {
                String dname = dirs[i2];
                File sd = new File(fromDir, dname);
                File dd = this.flatten ? new File(toDir, new File(dname).getName()) : new File(toDir, dname);
                if (this.forceOverwrite || sd.lastModified() > dd.lastModified()) {
                    this.dirCopyMap.put(sd.getAbsolutePath(), dd.getAbsolutePath());
                }
                ++i2;
            }
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFiltering(boolean filtering) {
        this.filtering = filtering;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public void setIncludeEmptyDirs(boolean includeEmpty) {
        this.includeEmpty = includeEmpty;
    }

    public void setOverwrite(boolean overwrite) {
        this.forceOverwrite = overwrite;
    }

    public void setTodir(File destDir) {
        this.destDir = destDir;
    }

    public void setTofile(File destFile) {
        this.destFile = destFile;
    }

    public void setVerbose(boolean verbose) {
        this.verbosity = verbose ? 2 : 3;
    }

    protected void validateAttributes() throws BuildException {
        if (this.file == null && this.filesets.size() == 0) {
            throw new BuildException("Specify at least one source - a file or a fileset.");
        }
        if (this.destFile != null && this.destDir != null) {
            throw new BuildException("Only one of destfile and destdir may be set.");
        }
        if (this.destFile == null && this.destDir == null) {
            throw new BuildException("One of destfile or destdir must be set.");
        }
        if (this.file != null && this.file.exists() && this.file.isDirectory()) {
            throw new BuildException("Use a fileset to copy directories.");
        }
        if (this.destFile != null && this.filesets.size() > 0) {
            throw new BuildException("Cannot concatenate multple files into a single file.");
        }
        if (this.destFile != null) {
            this.destDir = new File(this.destFile.getParent());
        }
    }
}

