// This file was autogenerated using go run mkcode.go -- memory.go
// DO NOT EDIT.

package ntdll

import "unsafe"

// The MemoryInformationClass constants have been derived from the MEMORY_INFORMATION_CLASS enum definition.
type MemoryInformationClass uint32

const (
	MemoryBasicInformation              MemoryInformationClass = 0
	MemoryWorkingSetInformation                                = 1
	MemoryMappedFilenameInformation                            = 2
	MemoryRegionInformation                                    = 3
	MemoryWorkingSetExInformation                              = 4
	MemorySharedCommitInformation                              = 5
	MemoryImageInformation                                     = 6
	MemoryRegionInformationEx                                  = 7
	MemoryPrivilegedBasicInformation                           = 8
	MemoryEnclaveImageInformation                              = 9
	MemoryBasicInformationCapped                               = 10
	MemoryPhysicalContiguityInformation                        = 11
)

var (
	procNtAllocateVirtualMemory = modntdll.NewProc("NtAllocateVirtualMemory")
	procNtFreeVirtualMemory     = modntdll.NewProc("NtFreeVirtualMemory")
	procNtReadVirtualMemory     = modntdll.NewProc("NtReadVirtualMemory")
	procNtWriteVirtualMemory    = modntdll.NewProc("NtWriteVirtualMemory")
	procNtProtectVirtualMemory  = modntdll.NewProc("NtProtectVirtualMemory")
	procNtQueryVirtualMemory    = modntdll.NewProc("NtQueryVirtualMemory")
	procNtFlushVirtualMemory    = modntdll.NewProc("NtFlushVirtualMemory")
)

// MemoryBasicInformationT has been derived from the MEMORY_BASIC_INFORMATION struct definition.
type MemoryBasicInformationT struct {
	BaseAddress       *byte
	AllocationBase    *byte
	AllocationProtect uint32
	PartitionId       uint16
	RegionSize        uintptr
	State             uint32
	Protect           uint32
	Type              uint32
}

// MemoryBasicInformation32 has been derived from the MEMORY_BASIC_INFORMATION32 struct definition.
type MemoryBasicInformation32 struct {
	BaseAddress       uint32
	AllocationBase    uint32
	AllocationProtect uint32
	RegionSize        uint32
	State             uint32
	Protect           uint32
	Type              uint32
}

// MemoryBasicInformation64 has been derived from the MEMORY_BASIC_INFORMATION64 struct definition.
type MemoryBasicInformation64 struct {
	BaseAddress       uint64
	AllocationBase    uint64
	AllocationProtect uint32
	__alignment1      uint32
	RegionSize        uint64
	State             uint32
	Protect           uint32
	Type              uint32
	__alignment2      uint32
}

// MemoryWorkingSetInformationT has been derived from the MEMORY_WORKING_SET_INFORMATION struct definition.
type MemoryWorkingSetInformationT struct {
	NumberOfEntries *uint32
	WorkingSetInfo  [1]MemoryWorkingSetBlock
}

// MemoryRegionInformationT has been derived from the MEMORY_REGION_INFORMATION struct definition.
type MemoryRegionInformationT struct {
	AllocationBase    *byte
	AllocationProtect uint32
	RegionType        uint32
	RegionSize        uintptr
	CommitSize        uintptr
	PartitionId       *uint32
	NodePreference    *uint32
}

// MemoryWorkingSetExInformationT has been derived from the MEMORY_WORKING_SET_EX_INFORMATION struct definition.
type MemoryWorkingSetExInformationT struct {
	VirtualAddress    *byte
	VirtualAttributes MemoryWorkingSetExBlock
}

// MemorySharedCommitInformationT has been derived from the MEMORY_SHARED_COMMIT_INFORMATION struct definition.
type MemorySharedCommitInformationT struct {
	CommitSize uintptr
}

// MemoryImageInformationT has been derived from the MEMORY_IMAGE_INFORMATION struct definition.
type MemoryImageInformationT struct {
	ImageBase   *byte
	SizeOfImage uintptr
	ImageFlags  uint32
}

// INOUT-parameter: BaseAddress, RegionSize.
func NtAllocateVirtualMemory(
	ProcessHandle Handle,
	BaseAddress *byte,
	ZeroBits *uint32,
	RegionSize *uintptr,
	AllocationType uint32,
	Protect uint32,
) NtStatus {
	r0, _, _ := procNtAllocateVirtualMemory.Call(uintptr(ProcessHandle),
		uintptr(unsafe.Pointer(BaseAddress)),
		uintptr(unsafe.Pointer(ZeroBits)),
		uintptr(unsafe.Pointer(RegionSize)),
		uintptr(AllocationType),
		uintptr(Protect))
	return NtStatus(r0)
}

// INOUT-parameter: BaseAddress, RegionSize.
func NtFreeVirtualMemory(
	ProcessHandle Handle,
	BaseAddress *byte,
	RegionSize *uintptr,
	FreeType uint32,
) NtStatus {
	r0, _, _ := procNtFreeVirtualMemory.Call(uintptr(ProcessHandle),
		uintptr(unsafe.Pointer(BaseAddress)),
		uintptr(unsafe.Pointer(RegionSize)),
		uintptr(FreeType))
	return NtStatus(r0)
}

// OUT-parameter: Buffer, NumberOfBytesRead.
// *OPT-parameter: BaseAddress, NumberOfBytesRead.
func NtReadVirtualMemory(
	ProcessHandle Handle,
	BaseAddress *byte,
	Buffer *byte,
	BufferSize uintptr,
	NumberOfBytesRead *uintptr,
) NtStatus {
	r0, _, _ := procNtReadVirtualMemory.Call(uintptr(ProcessHandle),
		uintptr(unsafe.Pointer(BaseAddress)),
		uintptr(unsafe.Pointer(Buffer)),
		uintptr(BufferSize),
		uintptr(unsafe.Pointer(NumberOfBytesRead)))
	return NtStatus(r0)
}

// OUT-parameter: NumberOfBytesWritten.
// *OPT-parameter: BaseAddress, NumberOfBytesWritten.
func NtWriteVirtualMemory(
	ProcessHandle Handle,
	BaseAddress *byte,
	Buffer *byte,
	BufferSize uintptr,
	NumberOfBytesWritten *uintptr,
) NtStatus {
	r0, _, _ := procNtWriteVirtualMemory.Call(uintptr(ProcessHandle),
		uintptr(unsafe.Pointer(BaseAddress)),
		uintptr(unsafe.Pointer(Buffer)),
		uintptr(BufferSize),
		uintptr(unsafe.Pointer(NumberOfBytesWritten)))
	return NtStatus(r0)
}

// OUT-parameter: OldProtect.
// INOUT-parameter: BaseAddress, RegionSize.
func NtProtectVirtualMemory(
	ProcessHandle Handle,
	BaseAddress *byte,
	RegionSize *uintptr,
	NewProtect uint32,
	OldProtect *uint32,
) NtStatus {
	r0, _, _ := procNtProtectVirtualMemory.Call(uintptr(ProcessHandle),
		uintptr(unsafe.Pointer(BaseAddress)),
		uintptr(unsafe.Pointer(RegionSize)),
		uintptr(NewProtect),
		uintptr(unsafe.Pointer(OldProtect)))
	return NtStatus(r0)
}

// OUT-parameter: MemoryInformation, ReturnLength.
// *OPT-parameter: BaseAddress, ReturnLength.
func NtQueryVirtualMemory(
	ProcessHandle Handle,
	BaseAddress *byte,
	MemoryInformationClass MemoryInformationClass,
	MemoryInformation *byte,
	MemoryInformationLength uintptr,
	ReturnLength *uintptr,
) NtStatus {
	r0, _, _ := procNtQueryVirtualMemory.Call(uintptr(ProcessHandle),
		uintptr(unsafe.Pointer(BaseAddress)),
		uintptr(MemoryInformationClass),
		uintptr(unsafe.Pointer(MemoryInformation)),
		uintptr(MemoryInformationLength),
		uintptr(unsafe.Pointer(ReturnLength)))
	return NtStatus(r0)
}

// OUT-parameter: IoStatus.
// INOUT-parameter: BaseAddress, RegionSize.
func NtFlushVirtualMemory(
	ProcessHandle Handle,
	BaseAddress *byte,
	RegionSize *uintptr,
	IoStatus *IoStatusBlock,
) NtStatus {
	r0, _, _ := procNtFlushVirtualMemory.Call(uintptr(ProcessHandle),
		uintptr(unsafe.Pointer(BaseAddress)),
		uintptr(unsafe.Pointer(RegionSize)),
		uintptr(unsafe.Pointer(IoStatus)))
	return NtStatus(r0)
}
