/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.impl.ICULocaleData;
import com.ibm.icu.impl.LocaleUtility;
import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Currency
implements Serializable {
    private String isoCode;
    public static final int SYMBOL_NAME = 0;
    public static final int LONG_NAME = 1;
    private static ServiceShim shim;
    private static final Integer[] LAST_RESORT_DATA;
    private static final int[] POW10;
    static /* synthetic */ Class class$com$ibm$icu$util$Currency;

    private static ServiceShim getShim() {
        if (shim == null) {
            try {
                Class<?> cls = Class.forName("com.ibm.icu.util.CurrencyServiceShim");
                shim = (ServiceShim)cls.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
        return shim;
    }

    public static Currency getInstance(Locale locale) {
        if (shim == null) {
            return Currency.createCurrency(locale);
        }
        return shim.createInstance(locale);
    }

    static Currency createCurrency(Locale loc) {
        String country = loc.getCountry();
        String variant = loc.getVariant();
        if (variant.equals("PREEURO") || variant.equals("EURO")) {
            country = country + '_' + variant;
        }
        ResourceBundle bundle = ICULocaleData.getLocaleElements(new Locale("", "", ""));
        Object[][] cm = (Object[][])bundle.getObject("CurrencyMap");
        String curriso = null;
        int i = 0;
        while (i < cm.length) {
            if (country.equals((String)cm[i][0])) {
                curriso = (String)cm[i][1];
                break;
            }
            ++i;
        }
        return curriso != null ? new Currency(curriso) : null;
    }

    public static Currency getInstance(String theISOCode) {
        return new Currency(theISOCode);
    }

    public static Object registerInstance(Currency currency, Locale locale) {
        return Currency.getShim().registerInstance(currency, locale);
    }

    public static boolean unregister(Object registryKey) {
        if (registryKey == null) {
            throw new IllegalArgumentException("registryKey must not be null");
        }
        if (shim == null) {
            return false;
        }
        return shim.unregister(registryKey);
    }

    public static Locale[] getAvailableLocales() {
        if (shim == null) {
            return ICULocaleData.getAvailableLocales();
        }
        return shim.getAvailableLocales();
    }

    public int hashCode() {
        return this.isoCode.hashCode();
    }

    public boolean equals(Object rhs) {
        try {
            return this.equals((Currency)rhs);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean equals(Currency c) {
        if (c == null) {
            return false;
        }
        if (c == this) {
            return true;
        }
        return c.getClass() == (class$com$ibm$icu$util$Currency == null ? (class$com$ibm$icu$util$Currency = Currency.class$("com.ibm.icu.util.Currency")) : class$com$ibm$icu$util$Currency) && this.isoCode.equals(c.isoCode);
    }

    public String getCurrencyCode() {
        return this.isoCode;
    }

    public String getName(Locale locale, int nameStyle, boolean[] isChoiceFormat) {
        if (nameStyle < 0 || nameStyle > 1) {
            throw new IllegalArgumentException();
        }
        String s = null;
        while (locale != null) {
            ResourceBundle rb = ICULocaleData.getLocaleElements(locale);
            try {
                Object[][] currencies = (Object[][])rb.getObject("Currencies");
                int i = 0;
                while (i < currencies.length) {
                    if (this.isoCode.equals((String)currencies[i][0])) {
                        s = ((String[])currencies[i][1])[nameStyle];
                        break;
                    }
                    ++i;
                }
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            if (s != null) break;
            locale = LocaleUtility.fallback(locale);
        }
        isChoiceFormat[0] = false;
        if (s != null) {
            int i = 0;
            while (i < s.length() && s.charAt(i) == '=' && i < 2) {
                ++i;
            }
            boolean bl = isChoiceFormat[0] = i == 1;
            if (i != 0) {
                s = s.substring(1);
            }
            return s;
        }
        return this.isoCode;
    }

    public int getDefaultFractionDigits() {
        return this.findData()[0];
    }

    public double getRoundingIncrement() {
        Integer[] data = this.findData();
        int data1 = data[1];
        if (data1 == 0) {
            return 0.0;
        }
        int data0 = data[0];
        if (data0 < 0 || data0 >= POW10.length) {
            return 0.0;
        }
        return (double)data1 / (double)POW10[data0];
    }

    public String toString() {
        return this.isoCode;
    }

    private Currency(String theISOCode) {
        this.isoCode = theISOCode;
    }

    private Integer[] findData() {
        try {
            ResourceBundle root = ICULocaleData.getLocaleElements("");
            Object[][] currencyMeta = (Object[][])root.getObject("CurrencyMeta");
            Integer[] i = null;
            int defaultPos = -1;
            int j = 0;
            while (j < currencyMeta.length) {
                Object[] row = currencyMeta[j];
                String s = (String)row[0];
                int c = this.isoCode.compareToIgnoreCase(s);
                if (c == 0) {
                    i = (Integer[])row[1];
                    break;
                }
                if ("DEFAULT".equalsIgnoreCase(s)) {
                    defaultPos = j;
                }
                if (c < 0 && defaultPos >= 0) break;
                ++j;
            }
            if (i == null && defaultPos >= 0) {
                i = (Integer[])currencyMeta[defaultPos][1];
            }
            if (i != null && i.length >= 2) {
                return i;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return LAST_RESORT_DATA;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        LAST_RESORT_DATA = new Integer[]{new Integer(2), new Integer(0)};
        POW10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    }

    static abstract class ServiceShim {
        ServiceShim() {
        }

        abstract Locale[] getAvailableLocales();

        abstract Currency createInstance(Locale var1);

        abstract Object registerInstance(Currency var1, Locale var2);

        abstract boolean unregister(Object var1);
    }
}

