/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.depend;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.taskdefs.optional.depend.ClassFile;
import org.apache.tools.ant.taskdefs.optional.depend.ClassFileIterator;

public class DirectoryIterator
implements ClassFileIterator {
    private Stack enumStack = new Stack();
    private Enumeration currentEnum;
    int rootLength;

    public DirectoryIterator(File file, boolean bl) throws IOException {
        this.rootLength = file.isAbsolute() || bl ? file.getPath().length() + 1 : 0;
        Vector vector = this.getDirectoryEntries(file);
        this.currentEnum = vector.elements();
    }

    private Vector getDirectoryEntries(File file) {
        Vector<File> vector = new Vector<File>();
        String[] stringArray = file.list();
        if (stringArray != null) {
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                vector.addElement(new File(file, stringArray[n2]));
                ++n2;
            }
        }
        return vector;
    }

    public ClassFile getNextClassFile() {
        ClassFile classFile = null;
        try {
            while (classFile == null) {
                if (this.currentEnum.hasMoreElements()) {
                    Object object;
                    File file = (File)this.currentEnum.nextElement();
                    if (file.isDirectory()) {
                        this.enumStack.push(this.currentEnum);
                        object = this.getDirectoryEntries(file);
                        this.currentEnum = ((Vector)object).elements();
                        continue;
                    }
                    object = new FileInputStream(file);
                    if (!file.getName().endsWith(".class")) continue;
                    ClassFile classFile2 = new ClassFile();
                    classFile2.read((InputStream)object);
                    classFile = classFile2;
                    continue;
                }
                if (!this.enumStack.empty()) {
                    this.currentEnum = (Enumeration)this.enumStack.pop();
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            classFile = null;
        }
        return classFile;
    }
}

