/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Property
extends Task {
    protected String name;
    protected String value;
    protected File file;
    protected String resource;
    protected Path classpath;
    protected String env;
    protected Reference ref = null;
    protected boolean userProperty = false;

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setLocation(File file) {
        this.setValue(file.getAbsolutePath());
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setRefid(Reference reference) {
        this.ref = reference;
    }

    public Reference getRefid() {
        return this.ref;
    }

    public void setResource(String string) {
        this.resource = string;
    }

    public String getResource() {
        return this.resource;
    }

    public void setEnvironment(String string) {
        this.env = string;
    }

    public String getEnvironment() {
        return this.env;
    }

    public void setClasspath(Path path) {
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setUserProperty(boolean bl) {
        this.userProperty = bl;
    }

    public String toString() {
        return this.value == null ? "" : this.value;
    }

    public void execute() throws BuildException {
        try {
            Object object;
            if (this.name != null && this.value != null) {
                this.addProperty(this.name, this.value);
            }
            if (this.file != null) {
                this.loadFile(this.file);
            }
            if (this.resource != null) {
                this.loadResource(this.resource);
            }
            if (this.env != null) {
                this.loadEnvironment(this.env);
            }
            if (this.name != null && this.ref != null && (object = this.ref.getReferencedObject(this.getProject())) != null) {
                this.addProperty(this.name, object.toString());
            }
        }
        catch (Exception exception) {
            throw new BuildException(exception, this.location);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadFile(File file) throws BuildException {
        Properties properties = new Properties();
        this.log("Loading " + file.getAbsolutePath(), 3);
        try {
            block5: {
                if (!file.exists()) {
                    this.log("Unable to find " + file.getAbsolutePath(), 3);
                    return;
                }
                FileInputStream fileInputStream = new FileInputStream(file);
                try {
                    properties.load(fileInputStream);
                    Object var5_5 = null;
                    if (fileInputStream == null) break block5;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    if (fileInputStream == null) throw throwable;
                    fileInputStream.close();
                    throw throwable;
                }
                fileInputStream.close();
            }
            this.addProperties(properties);
            return;
        }
        catch (Exception exception) {
            throw new BuildException(exception.getMessage(), exception, this.location);
        }
    }

    protected void loadResource(String string) {
        Properties properties = new Properties();
        this.log("Resource Loading " + string, 3);
        try {
            ClassLoader classLoader = null;
            InputStream inputStream = null;
            classLoader = this.classpath != null ? new AntClassLoader(this.project, this.classpath, false) : this.getClass().getClassLoader();
            inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string) : classLoader.getResourceAsStream(string);
            if (inputStream != null) {
                properties.load(inputStream);
                this.addProperties(properties);
            } else {
                this.log("Unable to find resource " + string, 1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void loadEnvironment(String string) {
        Properties properties = new Properties();
        if (!string.endsWith(".")) {
            string = string + ".";
        }
        this.log("Loading Environment " + string, 3);
        try {
            Vector vector = Execute.getProcEnvironment();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                int n = string2.indexOf(61);
                ((Hashtable)properties).put(string + string2.substring(0, n), string2.substring(n + 1));
            }
            this.addProperties(properties);
        }
        catch (Exception exception) {
            throw new BuildException(exception, this.location);
        }
    }

    protected void addProperties(Properties properties) {
        this.resolveAllProperties(properties);
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            String string3 = ProjectHelper.replaceProperties(this.project, string2, this.project.getProperties());
            this.addProperty(string, string2);
        }
    }

    protected void addProperty(String string, String string2) {
        if (this.userProperty) {
            if (this.project.getUserProperty(string) == null) {
                this.project.setUserProperty(string, string2);
            } else {
                this.log("Override ignored for " + string, 3);
            }
        } else if (this.project.getProperty(string) == null) {
            this.project.setProperty(string, string2);
        } else {
            this.log("Override ignored for " + string, 3);
        }
    }

    private void resolveAllProperties(Hashtable hashtable) {
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            boolean bl = false;
            while (!bl) {
                Vector vector = new Vector();
                bl = true;
                boolean bl2 = false;
                if (this.extractProperties(string2, vector)) {
                    int n = 0;
                    while (n < vector.size()) {
                        String string3 = (String)vector.elementAt(n);
                        if (string3.equals(string) || hashtable2.containsKey(string3)) {
                            bl2 = true;
                            break;
                        }
                        if (this.project.getProperties().containsKey(string3) || hashtable.containsKey(string3)) {
                            bl = false;
                        }
                        ++n;
                    }
                }
                if (bl2) {
                    hashtable2.put(string, string2);
                    bl = true;
                }
                if (bl) continue;
                string2 = ProjectHelper.replaceProperties(this.project, string2, this.project.getProperties());
                string2 = ProjectHelper.replaceProperties(this.project, string2, hashtable);
                hashtable.put(string, string2);
            }
        }
    }

    private boolean extractProperties(String string, Vector vector) {
        int n;
        boolean bl = false;
        int n2 = 0;
        while ((n = string.indexOf("$", n2)) >= 0) {
            if (n == string.length() - 1) {
                n2 = n + 1;
                continue;
            }
            if (string.charAt(n + 1) != '{') {
                n2 = n + 2;
                continue;
            }
            int n3 = string.indexOf(125, n);
            String string2 = string.substring(n + 2, n3);
            vector.addElement(string2);
            n2 = n3 + 1;
        }
        return vector.size() > 0;
    }
}

