"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Node = void 0;
const assert = require("assert");
const constants_1 = require("../constants");
class Node {
    ref;
    cachedDecl;
    privCompilation;
    constructor(ref) {
        this.ref = ref;
    }
    build(compilation) {
        if (this.cachedDecl !== undefined) {
            return this.cachedDecl;
        }
        const res = constants_1.STATE_PREFIX + this.ref.id.name;
        this.cachedDecl = res;
        this.privCompilation = compilation;
        const out = [];
        compilation.debug(out, `Entering node "${this.ref.id.originalName}" ("${this.ref.id.name}")`);
        this.doBuild(out);
        compilation.addState(res, out);
        return res;
    }
    get compilation() {
        assert(this.privCompilation !== undefined);
        return this.privCompilation;
    }
    prologue(out) {
        const ctx = this.compilation;
        out.push(`if (${ctx.posArg()} == ${ctx.endPosArg()}) {`);
        const tmp = [];
        this.pause(tmp);
        this.compilation.indent(out, tmp, '  ');
        out.push('}');
    }
    pause(out) {
        out.push(`return ${this.cachedDecl};`);
    }
    tailTo(out, edge) {
        const ctx = this.compilation;
        const target = ctx.unwrapNode(edge.node).build(ctx);
        if (!edge.noAdvance) {
            out.push(`${ctx.posArg()}++;`);
        }
        if (edge.value !== undefined) {
            out.push(`${ctx.matchVar()} = ${edge.value};`);
        }
        out.push(`goto ${constants_1.LABEL_PREFIX}${target};`);
    }
}
exports.Node = Node;
//# sourceMappingURL=base.js.map