import * as frontend from 'llparse-frontend';
import { Code } from './code';
import { Node } from './node';
import { Transform } from './transform';
type WrappedNode = frontend.IWrap<frontend.node.Node>;
export interface ICompilationOptions {
    readonly debug?: string;
}
export interface ICompilationProperty {
    readonly name: string;
    readonly ty: string;
}
export declare class Compilation {
    readonly prefix: string;
    private readonly properties;
    private readonly options;
    private readonly stateMap;
    private readonly blobs;
    private readonly codeMap;
    private readonly matchSequence;
    private readonly resumptionTargets;
    constructor(prefix: string, properties: ReadonlyArray<ICompilationProperty>, resumptionTargets: ReadonlySet<WrappedNode>, options: ICompilationOptions);
    private buildStateEnum;
    private buildBlobs;
    private buildMatchSequence;
    reserveSpans(spans: ReadonlyArray<frontend.SpanField>): void;
    debug(out: string[], message: string): void;
    buildGlobals(out: string[]): void;
    buildResumptionStates(out: string[]): void;
    buildInternalStates(out: string[]): void;
    addState(state: string, lines: ReadonlyArray<string>): void;
    buildCode(code: Code<frontend.code.Code>): string;
    getFieldType(field: string): string;
    unwrapCode(code: frontend.IWrap<frontend.code.Code>): Code<frontend.code.Code>;
    unwrapNode(node: WrappedNode): Node<frontend.node.Node>;
    unwrapTransform(node: frontend.IWrap<frontend.transform.Transform>): Transform<frontend.transform.Transform>;
    indent(out: string[], lines: ReadonlyArray<string>, pad: string): void;
    getMatchSequence(transform: frontend.IWrap<frontend.transform.Transform>, select: Buffer): string;
    stateArg(): string;
    posArg(): string;
    endPosArg(): string;
    matchVar(): string;
    indexField(): string;
    currentField(): string;
    errorField(): string;
    reasonField(): string;
    errorPosField(): string;
    spanPosField(index: number): string;
    spanCbField(index: number): string;
    stateField(name: string): string;
    cstring(value: string): string;
    blob(value: Buffer, alignment?: number): string;
    toChar(value: number): string;
}
export {};
