import * as frontend from 'llparse-frontend';
import source = frontend.source;
import * as cImpl from '../implementation/c';
export interface ICompilerOptions {
    /**
      * Debug method name
      *
      * The method must have following signature:
      *
      * ```c
      * void debug(llparse_t* state, const char* p, const char* endp,
      *            const char* msg);
      * ```
      *
      * Where `llparse_t` is a parser state type.
      */
    readonly debug?: string;
    /**
     * What guard define to use in `#ifndef` in C headers.
     *
     * Default value: `prefix` argument
     */
    readonly headerGuard?: string;
    /** Optional frontend configuration */
    readonly frontend?: frontend.IFrontendLazyOptions;
    /** Optional C-backend configuration */
    readonly c?: cImpl.ICPublicOptions;
}
export interface ICompilerResult {
    /**
     * Textual C code
     */
    readonly c: string;
    /**
     * Textual C header file
     */
    readonly header: string;
}
export declare class Compiler {
    readonly prefix: string;
    readonly options: ICompilerOptions;
    constructor(prefix: string, options: ICompilerOptions);
    compile(root: source.node.Node, properties: ReadonlyArray<source.Property>): ICompilerResult;
}
