"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LLParse = exports.source = void 0;
const frontend = require("llparse-frontend");
var source = frontend.source;
exports.source = source;
const compiler_1 = require("./compiler");
// TODO(indutny): API for disabling/short-circuiting spans
/**
 * LLParse graph builder and compiler.
 */
class LLParse extends source.Builder {
    prefix;
    /**
     * The prefix controls the names of methods and state struct in generated
     * public C headers:
     *
     * ```c
     * // state struct
     * struct PREFIX_t {
     *   ...
     * }
     *
     * int PREFIX_init(PREFIX_t* state);
     * int PREFIX_execute(PREFIX_t* state, const char* p, const char* endp);
     * ```
     *
     * @param prefix  Prefix to be used when generating public API.
     */
    constructor(prefix = 'llparse') {
        super();
        this.prefix = prefix;
    }
    /**
     * Compile LLParse graph to the C code and C headers
     *
     * @param root  Root node of the parse graph (see `.node()`)
     * @param options Compiler options.
     */
    build(root, options = {}) {
        const c = new compiler_1.Compiler(this.prefix, options);
        return c.compile(root, this.properties);
    }
}
exports.LLParse = LLParse;
//# sourceMappingURL=api.js.map