import * as source from 'llparse-builder';
import * as frontend from './namespace/frontend';
import { Container, ContainerWrap } from './container';
import { IImplementation } from './implementation';
import { SpanField } from './span-field';
import { Identifier, IUniqueName } from './utils';
import { IWrap } from './wrap';
export { code, node, transform } from './namespace/frontend';
export { source, Identifier, IUniqueName, IWrap, SpanField, Container, ContainerWrap, };
export declare const DEFAULT_MIN_TABLE_SIZE = 32;
export declare const DEFAULT_MAX_TABLE_WIDTH = 4;
declare type WrappedNode = IWrap<frontend.node.Node>;
export interface IFrontendLazyOptions {
    readonly maxTableElemWidth?: number;
    readonly minTableSize?: number;
}
export interface IFrontendResult {
    readonly prefix: string;
    readonly properties: ReadonlyArray<source.Property>;
    readonly root: IWrap<frontend.node.Node>;
    readonly spans: ReadonlyArray<SpanField>;
    readonly resumptionTargets: ReadonlySet<WrappedNode>;
}
export declare class Frontend {
    private readonly prefix;
    private readonly implementation;
    private readonly options;
    private readonly id;
    private readonly codeId;
    private readonly map;
    private readonly spanMap;
    private readonly codeCache;
    private readonly resumptionTargets;
    constructor(prefix: string, implementation: IImplementation, options?: IFrontendLazyOptions);
    compile(root: source.node.Node, properties: ReadonlyArray<source.Property>): IFrontendResult;
    getResumptionTargets(): ReadonlySet<WrappedNode>;
    private translate;
    private registerNode;
    private translateMatch;
    private translateTrie;
    private translateSingle;
    private maybeTableLookup;
    private translateSequence;
    private translateCode;
    private translateSpanCode;
    private translateTransform;
}
