"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Container = exports.ContainerWrap = void 0;
const assert = require("assert");
const wrap_1 = require("./wrap");
Object.defineProperty(exports, "ContainerWrap", { enumerable: true, get: function () { return wrap_1.ContainerWrap; } });
class Container {
    constructor() {
        this.map = new Map();
    }
    add(key, impl) {
        assert(!this.map.has(key), `Duplicate implementation key: "${key}"`);
        this.map.set(key, impl);
    }
    build() {
        return {
            code: this.buildCode(),
            node: this.buildNode(),
            transform: this.buildTransform(),
        };
    }
    buildCode() {
        return {
            And: this.combine((impl) => impl.code.And),
            IsEqual: this.combine((impl) => impl.code.IsEqual),
            Load: this.combine((impl) => impl.code.Load),
            Match: this.combine((impl) => impl.code.Match),
            MulAdd: this.combine((impl) => impl.code.MulAdd),
            Or: this.combine((impl) => impl.code.Or),
            Span: this.combine((impl) => impl.code.Span),
            Store: this.combine((impl) => impl.code.Store),
            Test: this.combine((impl) => impl.code.Test),
            Update: this.combine((impl) => impl.code.Update),
            Value: this.combine((impl) => impl.code.Value),
        };
    }
    buildNode() {
        return {
            Consume: this.combine((impl) => impl.node.Consume),
            Empty: this.combine((impl) => impl.node.Empty),
            Error: this.combine((impl) => impl.node.Error),
            Invoke: this.combine((impl) => impl.node.Invoke),
            Pause: this.combine((impl) => impl.node.Pause),
            Sequence: this.combine((impl) => impl.node.Sequence),
            Single: this.combine((impl) => impl.node.Single),
            SpanEnd: this.combine((impl) => impl.node.SpanEnd),
            SpanStart: this.combine((impl) => impl.node.SpanStart),
            TableLookup: this.combine((impl) => impl.node.TableLookup),
        };
    }
    buildTransform() {
        return {
            ID: this.combine((impl) => impl.transform.ID),
            ToLower: this.combine((impl) => impl.transform.ToLower),
            ToLowerUnsafe: this.combine((impl) => impl.transform.ToLowerUnsafe),
        };
    }
    combine(gather) {
        const wraps = new Map();
        for (const [key, impl] of this.map) {
            wraps.set(key, gather(impl));
        }
        return class ContainerWrapSingle extends wrap_1.ContainerWrap {
            constructor(ref) {
                super(ref);
                for (const [key, impl] of wraps) {
                    this.map.set(key, new impl(ref));
                }
            }
        };
    }
}
exports.Container = Container;
//# sourceMappingURL=index.js.map