export declare type LatticeValue = 'empty' | ReadonlyArray<number> | 'any';
/**
 * A fixed-size bitfield, really
 */
export declare class Lattice {
    protected readonly words: number[];
    constructor(value: LatticeValue);
    check(bit: number): boolean;
    union(other: Lattice): Lattice;
    intersect(other: Lattice): Lattice;
    subtract(other: Lattice): Lattice;
    isEqual(other: Lattice): boolean;
    [Symbol.iterator](): Iterator<number>;
    toJSON(): any;
    private add;
}
