/// <reference types="node" />
import { Node } from './node';
/**
 * This class represents an edge in the parser graph.
 */
export declare class Edge {
    readonly node: Node;
    readonly noAdvance: boolean;
    readonly key: Buffer | number | undefined;
    readonly value: number | undefined;
    /**
     * Comparator for `.sort()` function.
     */
    static compare(a: Edge, b: Edge): number;
    /**
     * @param node       Edge target
     * @param noAdvance  If `true` - the parent should not consume bytes before
     *                   moving to the target `node`
     * @param key        `Buffer` for `node.Match`, `number` for `node.Invoke`,
     *                   `undefined` for edges created with `.otherwise()`
     * @param value      `.select()` value associated with the edge
     */
    constructor(node: Node, noAdvance: boolean, key: Buffer | number | undefined, value: number | undefined);
}
