// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{ffi, LayoutChild, Orientation, SizeRequestMode, Widget};
use glib::{prelude::*, translate::*};

glib::wrapper! {
    #[doc(alias = "GtkLayoutManager")]
    pub struct LayoutManager(Object<ffi::GtkLayoutManager, ffi::GtkLayoutManagerClass>);

    match fn {
        type_ => || ffi::gtk_layout_manager_get_type(),
    }
}

impl LayoutManager {
    pub const NONE: Option<&'static LayoutManager> = None;
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::LayoutManager>> Sealed for T {}
}

pub trait LayoutManagerExt: IsA<LayoutManager> + sealed::Sealed + 'static {
    #[doc(alias = "gtk_layout_manager_allocate")]
    fn allocate(&self, widget: &impl IsA<Widget>, width: i32, height: i32, baseline: i32) {
        unsafe {
            ffi::gtk_layout_manager_allocate(
                self.as_ref().to_glib_none().0,
                widget.as_ref().to_glib_none().0,
                width,
                height,
                baseline,
            );
        }
    }

    #[doc(alias = "gtk_layout_manager_get_layout_child")]
    #[doc(alias = "get_layout_child")]
    fn layout_child(&self, child: &impl IsA<Widget>) -> LayoutChild {
        unsafe {
            from_glib_none(ffi::gtk_layout_manager_get_layout_child(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_layout_manager_get_request_mode")]
    #[doc(alias = "get_request_mode")]
    fn request_mode(&self) -> SizeRequestMode {
        unsafe {
            from_glib(ffi::gtk_layout_manager_get_request_mode(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_layout_manager_get_widget")]
    #[doc(alias = "get_widget")]
    fn widget(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_layout_manager_get_widget(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_layout_manager_layout_changed")]
    fn layout_changed(&self) {
        unsafe {
            ffi::gtk_layout_manager_layout_changed(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_layout_manager_measure")]
    fn measure(
        &self,
        widget: &impl IsA<Widget>,
        orientation: Orientation,
        for_size: i32,
    ) -> (i32, i32, i32, i32) {
        unsafe {
            let mut minimum = std::mem::MaybeUninit::uninit();
            let mut natural = std::mem::MaybeUninit::uninit();
            let mut minimum_baseline = std::mem::MaybeUninit::uninit();
            let mut natural_baseline = std::mem::MaybeUninit::uninit();
            ffi::gtk_layout_manager_measure(
                self.as_ref().to_glib_none().0,
                widget.as_ref().to_glib_none().0,
                orientation.into_glib(),
                for_size,
                minimum.as_mut_ptr(),
                natural.as_mut_ptr(),
                minimum_baseline.as_mut_ptr(),
                natural_baseline.as_mut_ptr(),
            );
            (
                minimum.assume_init(),
                natural.assume_init(),
                minimum_baseline.assume_init(),
                natural_baseline.assume_init(),
            )
        }
    }
}

impl<O: IsA<LayoutManager>> LayoutManagerExt for O {}
