/*
 * Copyright 2021-2025 the Pacemaker project contributors
 *
 * The version control history for this file may have further details.
 *
 * This source code is licensed under the GNU General Public License version 2
 * or later (GPLv2+) WITHOUT ANY WARRANTY.
 */

#include <crm_internal.h>

#include <crm/common/unittest_internal.h>
#include <crm/common/xml_internal.h>

static void
empty_input(void **state)
{
    xmlNode *node = pcmk__xml_parse("<node/>");
    bool value;

    assert_int_equal(pcmk__xe_get_bool(NULL, NULL, &value), EINVAL);
    assert_int_equal(pcmk__xe_get_bool(NULL, "whatever", &value), EINVAL);
    assert_int_equal(pcmk__xe_get_bool(node, NULL, &value), EINVAL);
    assert_int_equal(pcmk__xe_get_bool(node, "whatever", NULL), EINVAL);

    pcmk__xml_free(node);
}

static void
attr_missing(void **state)
{
    xmlNode *node = pcmk__xml_parse("<node a=\"true\" b=\"false\"/>");
    bool value;

    assert_int_equal(pcmk__xe_get_bool(node, "c", &value), ENXIO);
    pcmk__xml_free(node);
}

static void
attr_present(void **state)
{
    xmlNode *node = pcmk__xml_parse("<node a=\"true\" b=\"false\" "
                                                 "c=\"blah\"/>");
    bool value;

    value = false;
    assert_int_equal(pcmk__xe_get_bool(node, "a", &value), pcmk_rc_ok);
    assert_true(value);

    value = true;
    assert_int_equal(pcmk__xe_get_bool(node, "b", &value), pcmk_rc_ok);
    assert_false(value);

    assert_int_not_equal(pcmk__xe_get_bool(node, "c", &value), pcmk_rc_ok);

    pcmk__xml_free(node);
}

PCMK__UNIT_TEST(pcmk__xml_test_setup_group, pcmk__xml_test_teardown_group,
                cmocka_unit_test(empty_input),
                cmocka_unit_test(attr_missing),
                cmocka_unit_test(attr_present))
