#
# Set your ORACLE environment variable here
# ORACLE_HOME - Used here and in /etc/init.d/oracle (ora_environment())
# ORACLE_SID - Your Oracle System Identifier
#
  setenv ORACLE_BASE /opt/oracle
  setenv ORACLE_HOME ${ORACLE_BASE}/product/19c
  setenv ORACLE_SID orcl

# For RAC
# setenv ORA_CRS_HOME ${ORACLE_BASE}/product/12cR2/crs
# setenv ORA_ASM_HOME ${ORACLE_BASE}/product/12cR2/asm

# 
# Login environment variable settings for Oracle
# Set environment for user Oracle *ONLY*
# 

if ( `id -un` == "oracle" ) then

  #
  # The configuration file /etc/sysconfig/oracle is Bourne shell syntax
  # so we create C shell syntax from it and then read in the variables.
  #
  # Note: If required please adjust export in /etc/init.d/oracle script
  #       to work in csh/tcsh environment with following changes:
  #       su - $ORACLE_OWNER -c "exec bash -c 'export X=Y Z=A; CMD 2>/dev/null'"
  # 
  grep -v '^#' /etc/sysconfig/oracle | sed '/^$/ d' | sed 's/=/ /' | sed 's/^/setenv /' > /tmp/oracle-$$.csh
  source /tmp/oracle-$$.csh
  rm -f /tmp/oracle-$$.csh

  # Grid Control Agent Home
  setenv AGENT_HOME ${ORACLE_BASE}/product/10.2/agent
  
  setenv TNS_ADMIN ${ORACLE_HOME}/network/admin
  # Set ORA_NLSxx for 9i and 10g
  test -d ${ORACLE_HOME}/ocommon/nls/admin/data && setenv ORA_NLS33 ${ORACLE_HOME}/ocommon/nls/admin/data
  test -d ${ORACLE_HOME}/nls/data && setenv ORA_NLS10 ${ORACLE_HOME}/nls/data

  setenv PATH ${PATH}:${ORACLE_HOME}/bin
  setenv CLASSPATH ${ORACLE_HOME}/JRE:${ORACLE_HOME}/jlib:${ORACLE_HOME}/rdbms/jlib:${ORACLE_HOME}/network/jlib
  if ( ${?LD_LIBRARY_PATH} ) then
      setenv LD_LIBRARY_PATH ${LD_LIBRARY_PATH}:${ORACLE_HOME}/lib
  else
      setenv LD_LIBRARY_PATH ${ORACLE_HOME}/lib
  endif
  
  # Set ulimits:
  #
  # We suppress any warning messages, so if the hard limits have not been
  # increased by root and the commands don't work we keep silent... 
  # This is because the only one who needs it is the shell that starts
  # the DB server processes, and the number of warning messages created 
  # here is potentially way too much and confusing

endif

