# Copyright (c)1995 SuSE GmbH Nuernberg, Germany.
# 
# Author: SuSE Oracle Team <feedback@suse.de>
# Homepage: http://www.suse.com/oracle/
# 

ORACLE_RAC="no"
USE_SYSCTL="no"
LOAD_O2CB=/etc/init.d/o2cb
LOAD_OCFS2=/etc/init.d/ocfs2
MOUNT=/bin/mount
UMOUNT=/bin/umount
MKDIR=/bin/mkdir
RMMOD=/sbin/rmmod

CHECKPROC="/sbin/checkproc"
test -x "$CHECKPROC" || CHECKPROC="test -x "


# Get settings, if file(s) exist(s). If not, we simply use defaults.
if test -f /etc/sysconfig/oracle; then
    # new location as of SL 8.0 is directory /etc/sysconfig/
    . /etc/sysconfig/oracle
else
  if test -f /etc/rc.config.d/oracle.rc.config; then
    # location is directory /etc/rc.config.d/
    . /etc/rc.config.d/oracle.rc.config
  else
    if test -f /etc/rc.config; then
    # old SuSE location was to have everything in one file
    . /etc/rc.config
    fi
  fi
fi


# 
# Get and check environment (e.g. ORACLE_HOME)
# 
ora_environment()
{
  test -f /etc/profile.d/oracle.sh && . /etc/profile.d/oracle.sh
 # Check, If Oracle SW is installed, before spitting too many warnings
 if [ ! -f /etc/oratab -a ! -d "$ORACLE_HOME" ]; then
    echo "${warn}Oracle Database Software not yet installed!$norm"
    echo
 else
  if [ ! -z "$ORACLE_HOME" -a ! -d "$ORACLE_HOME" ]; then
    echo "${warn}ORACLE_HOME directory $ORACLE_HOME does not exist!$norm"
    echo "Unsetting ORACLE_HOME, will try to determine it from system..."
    unset ORACLE_HOME
  fi

  # Try /etc/oratab if it's not set in /etc/profile.d/oracle.sh
  test -z "$ORACLE_HOME" && test -f /etc/oratab &&                        \
    ORACLE_HOME=`awk -F: '/^[^#].*:.+:[YN]/ {if ($2!="") print $2; exit}' </etc/oratab` &&   \
    echo && echo "ORACLE_HOME not set, but I found this in /etc/oratab: $ORACLE_HOME" && echo

  if [ -z "$ORACLE_HOME" ]; then
    echo "${warn}ORACLE_HOME environment variable not set.$norm"
    echo "Check /etc/profile.d/oracle.sh and /etc/oratab"
  fi

  if [ ! -d "$ORACLE_HOME" ]; then
    echo "${warn}Cannot find ORACLE_HOME directory $ORACLE_HOME.$norm"
    echo "Environment settings are wrong! Check /etc/profile.d/oracle.sh"
  fi

  test -z "$ORACLE_OWNER" && ORACLE_OWNER="oracle"

  echo

  # Set Intelligent Agent Start/Stop 
  AGENT_VERSION="unknown"
  if [ ! -z "$ORACLE_HOME" -a ! -d "$ORACLE_HOME" ]; then
  if test -x "$AGENT_HOME/bin/emctl"; then
    # If Oracle Grid Control Agent is installed 
    AGENT_VERSION="10gA"
    # bz#308851 - 10gR3 Agent uses emagent
    if test -x "$AGENT_HOME/bin/emagent"; then
    	AGENT_PROG="$AGENT_HOME/bin/emagent"
    else
    	AGENT_PROG="$AGENT_HOME/bin/emctl"
    fi
    AGENT_START="$AGENT_HOME/bin/emctl start agent"
    AGENT_STOP="$AGENT_HOME/bin/emctl stop agent"
  elif test -x "$ORACLE_HOME/bin/agtctl"; then 
    # 10g
    AGENT_VERSION="10g"
    AGENT_HOME=$ORACLE_HOME
    AGENT_PROG="$ORACLE_HOME/bin/agtctl"                                            AGENT_START="$ORACLE_HOME/bin/agtctl startup"
    AGENT_STOP="$ORACLE_HOME/bin/agtctl stop"
  elif test -x "$ORACLE_HOME/bin/agentctl"; then
    # Oracle 9i
    AGENT_VERSION="9i"
    AGENT_HOME=$ORACLE_HOME
    AGENT_PROG="$ORACLE_HOME/bin/agentctl"
    AGENT_START="$ORACLE_HOME/bin/agentctl start"
    AGENT_STOP="$ORACLE_HOME/bin/agentctl stop"
  else
    # Oracle 8i
    AGENT_VERSION="8i"
    AGENT_HOME=$ORACLE_HOME
    AGENT_PROG="$ORACLE_HOME/bin/lsnrctl"
    AGENT_START="$ORACLE_HOME/bin/lsnrctl dbsnmp_start"
    AGENT_STOP="$ORACLE_HOME/bin/lsnrctl dbsnmp_stop"
    if [ `$ORACLE_HOME/bin/lsnrctl help | grep -q dbsnmp_start; echo $?` = "0"  -a  ${START_ORACLE_DB_AGENT:-no} = "yes" ]; then
     echo "${warn}Cannot start agent - Setting START_ORACLE_DB_AGENT = no $norm"
     START_ORACLE_DB_AGENT="cannot";
    fi
  fi
  fi
 fi

#  If Oracle Grid Control Agent is installed 
#  if test -x "$AGENT_HOME/bin/emctl"; then
#    AGENT_VERSION="10g"
#    AGENT_HOME=$AGENT_HOME
#    AGENT_PROG="$AGENT_HOME/bin/emctl"
#    AGENT_START="$AGENT_HOME/bin/emctl start agent"
#    AGENT_STOP="$AGENT_HOME/bin/emctl stop agent"
#  fi

# If Oracle Clusteware is installed, Set ORACLE_RAC Variable to "yes"
# ORA_CRS_HOME is defined in /etc/profile.d/oracle[c].sh

  if (test -x "$ORA_CRS_HOME/bin/crsctl" ); then
	ORACLE_RAC="yes"
  fi

#   If init.crs is configured (systemctl is-enabled) to start then
#   Don't starting CRS again
    if ( (/usr/bin/systemctl is-enabled --quiet init.crs) ); then
      START_ORACLE_RAC_CRS="cannot";
    fi

#   If OCFS2 is configured (systemctl is-enabled) to start then Don't start again
    if ( (/usr/bin/systemctl is-enabled --quiet ocfs2) ); then
      START_ORACLE_RAC_OCFS2="cannot";
    fi

  test -d "${TNS_ADMIN}" || TNS_ADMIN="$ORACLE_HOME/network/admin"

  if [ "$1" = "start" ]; then
    echo -n " ${extd}SETTINGS $1 from /etc/sysconfig/oracle$norm"
    if [ ! -f /etc/sysconfig/oracle ]; then
      echo " - ${warn}!!! MISSING !!!$norm"
    else
      echo
    fi
    echo " - Set Kernel Parameters for Oracle:   ${SET_ORACLE_KERNEL_PARAMETERS:-no}"
   if [ "$ORACLE_RAC" = "yes" ]; then
    echo " - Start Oracle OCFS2:                 ${START_ORACLE_RAC_OCFS2:-no}"
    echo " - Start Oracle CRS:                   ${START_ORACLE_RAC_CRS:-no}"
    echo " - Start Oracle Enterprise Manager:    ${START_ORACLE_DB_EMANAGER:-no}"
   else
    echo " - Start Oracle Listener:              ${START_ORACLE_DB_LISTENER:-no}"
    echo " - Start Oracle Database:              ${START_ORACLE_DB:-no}"
    echo " - Start Oracle Webserver:             ${START_ORACLE_DB_APACHE:-no}"
    echo " - Start Oracle EManager:              ${START_ORACLE_DB_EMANAGER:-no}"
    echo " - Start Oracle iSQLPLUS Manager:      ${START_ORACLE_DB_ISQLPLUS:-no}"
    echo " - Start Oracle Agent:                 ${START_ORACLE_DB_AGENT:-no}"
    echo " - Start Oracle Internet Filesystem:   ${START_ORACLE_DB_IFS:-no}"
    echo " - Start Oracle Directory Manager:     ${START_ORACLE_DB_OID:-no}"
   fi
  fi

  export ORACLE_HOME
  export TNS_ADMIN
}


